/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import java.util.ArrayList;
import java.util.Arrays;
import mcib3d.image3d.Coordinate3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.comparator.ComparatorByte;
import mcib3d.image3d.comparator.ComparatorFloat;
import mcib3d.image3d.comparator.ComparatorInvByte;
import mcib3d.image3d.comparator.ComparatorInvFloat;
import mcib3d.image3d.comparator.ComparatorInvShort;
import mcib3d.image3d.comparator.ComparatorShort;

public class MaskIterator {
    ImageHandler mask;
    public Integer[] coords;
    private Coordinate3D c3D;
    public int limit;

    public MaskIterator(ImageHandler imageHandler) {
        if (imageHandler instanceof ImageByte) {
            int n;
            int n2;
            ImageByte imageByte = (ImageByte)imageHandler;
            int n3 = 0;
            for (n2 = 0; n2 < imageHandler.sizeZ; ++n2) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (imageByte.pixels[n2][n] == 0) continue;
                    ++n3;
                }
            }
            this.coords = new Integer[n3];
            n3 = 0;
            for (n2 = 0; n2 < imageHandler.sizeZ; ++n2) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (imageByte.pixels[n2][n] == 0) continue;
                    this.coords[n3] = n2 * imageHandler.sizeXY + n;
                    ++n3;
                }
            }
        } else if (imageHandler instanceof ImageShort) {
            int n;
            int n4;
            ImageShort imageShort = (ImageShort)imageHandler;
            int n5 = 0;
            for (n4 = 0; n4 < imageHandler.sizeZ; ++n4) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (imageShort.pixels[n4][n] == 0) continue;
                    ++n5;
                }
            }
            this.coords = new Integer[n5];
            n5 = 0;
            for (n4 = 0; n4 < imageHandler.sizeZ; ++n4) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (imageShort.pixels[n4][n] == 0) continue;
                    this.coords[n5] = n4 * imageHandler.sizeXY + n;
                    ++n5;
                }
            }
        } else if (imageHandler instanceof ImageFloat) {
            int n;
            int n6;
            ImageFloat imageFloat = (ImageFloat)imageHandler;
            int n7 = 0;
            for (n6 = 0; n6 < imageHandler.sizeZ; ++n6) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (imageFloat.pixels[n6][n] == 0.0f) continue;
                    ++n7;
                }
            }
            this.coords = new Integer[n7];
            n7 = 0;
            for (n6 = 0; n6 < imageHandler.sizeZ; ++n6) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (imageFloat.pixels[n6][n] == 0.0f) continue;
                    this.coords[n7] = n6 * imageHandler.sizeXY + n;
                    ++n7;
                }
            }
        }
        this.c3D = new Coordinate3D(0, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ);
    }

    public MaskIterator(ImageHandler imageHandler, float f) {
        if (imageHandler instanceof ImageByte) {
            int n;
            int n2;
            ImageByte imageByte = (ImageByte)imageHandler;
            int n3 = 0;
            for (n2 = 0; n2 < imageHandler.sizeZ; ++n2) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (!((float)(imageByte.pixels[n2][n] & 0xFF) >= f)) continue;
                    ++n3;
                }
            }
            this.coords = new Integer[n3];
            n3 = 0;
            for (n2 = 0; n2 < imageHandler.sizeZ; ++n2) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (!((float)(imageByte.pixels[n2][n] & 0xFF) >= f)) continue;
                    this.coords[n3] = n2 * imageHandler.sizeXY + n;
                    ++n3;
                }
            }
        } else if (imageHandler instanceof ImageShort) {
            int n;
            int n4;
            ImageShort imageShort = (ImageShort)imageHandler;
            int n5 = 0;
            for (n4 = 0; n4 < imageHandler.sizeZ; ++n4) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (!((float)(imageShort.pixels[n4][n] & 0xFFFF) >= f)) continue;
                    ++n5;
                }
            }
            this.coords = new Integer[n5];
            n5 = 0;
            for (n4 = 0; n4 < imageHandler.sizeZ; ++n4) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (!((float)(imageShort.pixels[n4][n] & 0xFFFF) >= f)) continue;
                    this.coords[n5] = n4 * imageHandler.sizeXY + n;
                    ++n5;
                }
            }
        } else if (imageHandler instanceof ImageFloat) {
            int n;
            int n6;
            ImageFloat imageFloat = (ImageFloat)imageHandler;
            int n7 = 0;
            for (n6 = 0; n6 < imageHandler.sizeZ; ++n6) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (!(imageFloat.pixels[n6][n] >= f)) continue;
                    ++n7;
                }
            }
            this.coords = new Integer[n7];
            n7 = 0;
            for (n6 = 0; n6 < imageHandler.sizeZ; ++n6) {
                for (n = 0; n < imageHandler.sizeXY; ++n) {
                    if (!(imageFloat.pixels[n6][n] >= f)) continue;
                    this.coords[n7] = n6 * imageHandler.sizeXY + n;
                    ++n7;
                }
            }
        }
        this.c3D = new Coordinate3D(0, imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ);
    }

    public MaskIterator(int n, int n2, int n3) {
        this.coords = new Integer[n * n2 * n3];
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = i;
        }
        this.c3D = new Coordinate3D(0, n, n2, n3);
    }

    public void sort(boolean bl, ImageHandler imageHandler) {
        if (imageHandler instanceof ImageByte) {
            if (bl) {
                Arrays.sort(this.coords, new ComparatorInvByte((ImageByte)imageHandler));
            } else {
                Arrays.sort(this.coords, new ComparatorByte((ImageByte)imageHandler));
            }
        } else if (imageHandler instanceof ImageShort) {
            if (bl) {
                Arrays.sort(this.coords, new ComparatorInvShort((ImageShort)imageHandler));
            } else {
                Arrays.sort(this.coords, new ComparatorShort((ImageShort)imageHandler));
            }
        } else if (imageHandler instanceof ImageFloat) {
            if (bl) {
                Arrays.sort(this.coords, new ComparatorInvFloat((ImageFloat)imageHandler));
            } else {
                Arrays.sort(this.coords, new ComparatorFloat((ImageFloat)imageHandler));
            }
        }
    }

    public boolean isIn(int n, int n2, int n3) {
        if (n >= 0 && n < this.mask.sizeX && n2 >= 0 && n2 < this.mask.sizeY && n3 >= 0 && n3 < this.mask.sizeZ) {
            return this.mask.getPixel(n, n2, n3) != 0.0f;
        }
        return false;
    }

    public ArrayList<Integer> getVois1(int n) {
        this.c3D.setCoord(n);
        if (this.mask != null) {
            return this.c3D.getVois1(this.mask);
        }
        return this.c3D.getVois1();
    }

    public ArrayList<Integer> getVois15(int n) {
        this.c3D.setCoord(n);
        if (this.mask != null) {
            return this.c3D.getVois15(this.mask);
        }
        return this.c3D.getVois15();
    }

    public void setVois(float f, float f2) {
        this.c3D.setVois(f, f2);
    }

    public ArrayList<Integer> getVois(int n) {
        this.c3D.setCoord(n);
        if (this.mask != null) {
            return this.c3D.getVois(this.mask);
        }
        return this.c3D.getVois();
    }
}

