/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageShort;

public class EdtShort {
    public ImageFloat run(ImageShort imageShort, int n, float f, float f2, int n2) throws Exception {
        int n3;
        int n4;
        int n5;
        FloatProcessor floatProcessor;
        int n6 = imageShort.sizeX;
        int n7 = imageShort.sizeY;
        int n8 = imageShort.sizeZ;
        float f3 = f2 / f;
        short[][] sArray = imageShort.pixels;
        int n9 = n2;
        ImageStack imageStack = new ImageStack(n6, n7);
        float[][] fArrayArray = new float[n8][];
        for (int i = 0; i < n8; ++i) {
            floatProcessor = new FloatProcessor(n6, n7);
            imageStack.addSlice(null, (ImageProcessor)floatProcessor);
            fArrayArray[i] = (float[])floatProcessor.getPixels();
        }
        floatProcessor = new Step1Thread[n9];
        for (n5 = 0; n5 < n9; ++n5) {
            floatProcessor[n5] = new Step1Thread(n5, n9, n6, n7, n8, n, fArrayArray, sArray, f3);
            floatProcessor[n5].start();
        }
        try {
            for (n5 = 0; n5 < n9; ++n5) {
                floatProcessor[n5].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 1 .");
        }
        Step2Thread[] step2ThreadArray = new Step2Thread[n9];
        for (n4 = 0; n4 < n9; ++n4) {
            step2ThreadArray[n4] = new Step2Thread(n4, n9, n6, n7, n8, fArrayArray);
            step2ThreadArray[n4].start();
        }
        try {
            for (n4 = 0; n4 < n9; ++n4) {
                step2ThreadArray[n4].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 2 .");
        }
        Step3Thread[] step3ThreadArray = new Step3Thread[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            step3ThreadArray[n3] = new Step3Thread(n3, n9, n6, n7, n8, fArrayArray, sArray, n, f3);
            step3ThreadArray[n3].start();
        }
        try {
            for (n3 = 0; n3 < n9; ++n3) {
                step3ThreadArray[n3].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 3 .");
        }
        float f4 = 0.0f;
        int n10 = n6 * n7;
        for (int i = 0; i < n8; ++i) {
            float[] fArray = fArrayArray[i];
            for (int j = 0; j < n10; ++j) {
                float f5;
                if ((sArray[i][j] & 0xFFFF) <= n) {
                    fArray[j] = 0.0f;
                    continue;
                }
                fArray[j] = f5 = (float)Math.sqrt(fArray[j]) * f;
                f4 = f5 > f4 ? f5 : f4;
            }
        }
        ImageFloat imageFloat = (ImageFloat)ImageFloat.wrap(imageStack);
        imageFloat.setScale(imageShort);
        imageFloat.setOffset(imageShort);
        imageFloat.setMinAndMax(0.0f, f4);
        return imageFloat;
    }

    String stripExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    class Step3Thread
    extends Thread {
        int thresh;
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        short[][] data;
        float scaleZ;

        public Step3Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray, short[][] sArray, int n6, float f) {
            this.thresh = n6;
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
            this.data = sArray;
            this.scaleZ = f * f;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            for (int i = this.thread; i < this.h; i += this.nThreads) {
                for (int j = 0; j < this.w; ++j) {
                    int n3;
                    int n4;
                    int n5;
                    boolean bl = false;
                    for (n5 = 0; n5 < this.d; ++n5) {
                        fArray2[n5] = this.s[n5][j + this.w * i];
                        if (!(fArray2[n5] > 0.0f)) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    for (n4 = 0; n4 < this.d - 1 && fArray2[n4] == 0.0f; ++n4) {
                    }
                    if (n4 > 0) {
                        --n4;
                    }
                    for (n3 = this.d - 1; n3 > 0 && fArray2[n3] == 0.0f; --n3) {
                    }
                    if (n3 < this.d - 1) {
                        ++n3;
                    }
                    for (n5 = 0; n5 < this.d; ++n5) {
                        if ((this.data[n5][j + this.w * i] & 0xFFFF) <= this.thresh) continue;
                        float f = n2;
                        int n6 = n4;
                        int n7 = n3;
                        if (n6 > n5) {
                            n6 = n5;
                        }
                        if (n7 < n5) {
                            n7 = n5;
                        }
                        int n8 = n5 - n6;
                        for (int k = n6; k <= n7; ++k) {
                            int n9 = n8;
                            int n10 = n8--;
                            float f2 = fArray2[k] + (float)(n9 * n10) * this.scaleZ;
                            if (!(f2 < f)) continue;
                            f = f2;
                        }
                        fArray[n5] = f;
                    }
                    for (n5 = 0; n5 < this.d; ++n5) {
                        this.s[n5][j + this.w * i] = fArray[n5];
                    }
                }
            }
        }
    }

    class Step2Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;

        public Step2Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                float[] fArray3 = this.s[i];
                for (int j = 0; j < this.w; ++j) {
                    int n3;
                    boolean bl = false;
                    for (n3 = 0; n3 < this.h; ++n3) {
                        fArray2[n3] = fArray3[j + this.w * n3];
                        if (!(fArray2[n3] > 0.0f)) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    for (n3 = 0; n3 < this.h; ++n3) {
                        float f = n2;
                        int n4 = n3;
                        for (int k = 0; k < this.h; ++k) {
                            int n5 = n4;
                            int n6 = n4--;
                            float f2 = fArray2[k] + (float)(n5 * n6);
                            if (!(f2 < f)) continue;
                            f = f2;
                        }
                        fArray[n3] = f;
                    }
                    for (n3 = 0; n3 < this.h; ++n3) {
                        fArray3[j + this.w * n3] = fArray[n3];
                    }
                }
            }
        }
    }

    class Step1Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        int thresh;
        float[][] s;
        short[][] data;
        float scaleZ;

        public Step1Thread(int n, int n2, int n3, int n4, int n5, int n6, float[][] fArray, short[][] sArray, float f) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.thresh = n6;
            this.data = sArray;
            this.s = fArray;
            this.scaleZ = f * f;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            boolean[] blArray = new boolean[n];
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                float[] fArray = this.s[i];
                short[] sArray = this.data[i];
                boolean bl = i == 0 || i == this.d - 1;
                for (int j = 0; j < this.h; ++j) {
                    int n3;
                    for (n3 = 0; n3 < this.w; ++n3) {
                        blArray[n3] = (sArray[n3 + this.w * j] & 0xFFFF) <= this.thresh;
                    }
                    n3 = j == 0 || j == this.h - 1 ? 1 : 0;
                    for (int k = 0; k < this.w; ++k) {
                        float f = n2;
                        if (n3 != 0 || k == 0 || k == this.w - 1) {
                            f = 1.0f;
                        } else {
                            float f2;
                            int n4;
                            if (bl) {
                                f = this.scaleZ;
                            }
                            for (n4 = k; n4 < this.w; ++n4) {
                                if (!blArray[n4]) continue;
                                f2 = k - n4;
                                if (!((f2 *= f2) < f)) break;
                                f = f2;
                                break;
                            }
                            for (n4 = k - 1; n4 >= 0; --n4) {
                                if (!blArray[n4]) continue;
                                f2 = k - n4;
                                if (!((f2 *= f2) < f)) break;
                                f = f2;
                                break;
                            }
                        }
                        fArray[k + this.w * j] = f;
                    }
                }
            }
        }
    }
}

