/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

public class CannyDeriche1D {
    private double[] line;
    private double alpha;

    public CannyDeriche1D(double[] dArray, double d) {
        this.line = dArray;
        this.alpha = d;
    }

    private double[] computeCannyderiche() {
        int n = this.line.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        if (n > 2) {
            int n2;
            double d = Math.exp(-this.alpha);
            double d2 = Math.exp(-2.0 * this.alpha);
            double d3 = 0.0;
            double d4 = 1.0;
            double d5 = -1.0;
            double d6 = 0.0;
            double d7 = 2.0 * d;
            double d8 = -d2;
            dArray2[0] = this.line[0] * (d3 + d4) / (1.0 - d7 - d8);
            dArray2[1] = this.line[1] * d3 + d4 * this.line[0] + dArray2[0] * (d7 + d8);
            dArray3[n - 1] = this.line[n - 1] * (d5 + d6) / (1.0 - d7 - d8);
            dArray3[n - 2] = this.line[n - 1] * d5 + d6 * this.line[n - 1] + dArray3[n - 1] * (d7 + d8);
            for (n2 = 2; n2 < n; ++n2) {
                dArray2[n2] = d3 * this.line[n2] + d4 * this.line[n2 - 1] + d7 * dArray2[n2 - 1] + d8 * dArray2[n2 - 2];
            }
            for (n2 = n - 3; n2 >= 0; --n2) {
                dArray3[n2] = d5 * this.line[n2 + 1] + d6 * this.line[n2 + 2] + d7 * dArray3[n2 + 1] + d8 * dArray3[n2 + 2];
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = d8 * (dArray2[n2] + dArray3[n2]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray[i] = 0.0;
            }
        }
        return dArray;
    }

    public double[] getCannyDeriche() {
        return this.computeCannyderiche();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public double[] getLine() {
        return this.line;
    }

    public void setLine(double[] dArray) {
        this.line = dArray;
    }
}

