/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.math;

import net.phys2d.math.Vector2f;

public strictfp class Matrix2f {
    public Vector2f col1 = new Vector2f();
    public Vector2f col2 = new Vector2f();

    public Matrix2f() {
    }

    public Matrix2f(float angle) {
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        this.col1.x = c;
        this.col2.x = -s;
        this.col1.y = s;
        this.col2.y = c;
    }

    public Matrix2f(Vector2f col1, Vector2f col2) {
        this.col1.set(col1);
        this.col2.set(col2);
    }

    public Matrix2f transpose() {
        return new Matrix2f(new Vector2f(this.col1.x, this.col2.x), new Vector2f(this.col1.y, this.col2.y));
    }

    public Matrix2f invert() {
        float a = this.col1.x;
        float b = this.col2.x;
        float c = this.col1.y;
        float d = this.col2.y;
        Matrix2f B = new Matrix2f();
        float det = a * d - b * c;
        if (det == 0.0f) {
            throw new RuntimeException("Matrix2f: invert() - determinate is zero!");
        }
        det = 1.0f / det;
        B.col1.x = det * d;
        B.col2.x = -det * b;
        B.col1.y = -det * c;
        B.col2.y = det * a;
        return B;
    }
}

