/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;

public class StackCombiner
implements PlugIn {
    ImagePlus imp1;
    ImagePlus imp2;
    static boolean vertical;

    public void run(String arg) {
        if (!this.showDialog()) {
            return;
        }
        if (this.imp1.getType() != this.imp2.getType() || this.imp1.isHyperStack() || this.imp2.isHyperStack()) {
            this.error();
            return;
        }
        ImageStack stack1 = this.imp1.getStack();
        ImageStack stack2 = this.imp2.getStack();
        ImageStack stack3 = vertical ? this.combineVertically(stack1, stack2) : this.combineHorizontally(stack1, stack2);
        this.imp1.changes = false;
        this.imp1.close();
        this.imp2.changes = false;
        this.imp2.close();
        new ImagePlus("Combined Stacks", stack3).show();
    }

    public ImageStack combineHorizontally(ImageStack stack1, ImageStack stack2) {
        int d1 = stack1.getSize();
        int d2 = stack2.getSize();
        int d3 = Math.max(d1, d2);
        int w1 = stack1.getWidth();
        int h1 = stack1.getHeight();
        int w2 = stack2.getWidth();
        int h2 = stack2.getHeight();
        int w3 = w1 + w2;
        int h3 = Math.max(h1, h2);
        ImageStack stack3 = new ImageStack(w3, h3, stack1.getColorModel());
        ImageProcessor ip = stack1.getProcessor(1);
        Color background = Toolbar.getBackgroundColor();
        for (int i = 1; i <= d3; ++i) {
            IJ.showProgress((double)i / (double)d3);
            ImageProcessor ip3 = ip.createProcessor(w3, h3);
            if (h1 != h2) {
                ip3.setColor(background);
                ip3.fill();
            }
            if (i <= d1) {
                ip3.insert(stack1.getProcessor(1), 0, 0);
                if (stack2 != stack1) {
                    stack1.deleteSlice(1);
                }
            }
            if (i <= d2) {
                ip3.insert(stack2.getProcessor(1), w1, 0);
                stack2.deleteSlice(1);
            }
            stack3.addSlice(null, ip3);
        }
        return stack3;
    }

    public ImageStack combineVertically(ImageStack stack1, ImageStack stack2) {
        int d1 = stack1.getSize();
        int d2 = stack2.getSize();
        int d3 = Math.max(d1, d2);
        int w1 = stack1.getWidth();
        int h1 = stack1.getHeight();
        int w2 = stack2.getWidth();
        int h2 = stack2.getHeight();
        int w3 = Math.max(w1, w2);
        int h3 = h1 + h2;
        ImageStack stack3 = new ImageStack(w3, h3, stack1.getColorModel());
        ImageProcessor ip = stack1.getProcessor(1);
        Color background = Toolbar.getBackgroundColor();
        for (int i = 1; i <= d3; ++i) {
            IJ.showProgress((double)i / (double)d3);
            ImageProcessor ip3 = ip.createProcessor(w3, h3);
            if (w1 != w2) {
                ip3.setColor(background);
                ip3.fill();
            }
            if (i <= d1) {
                ip3.insert(stack1.getProcessor(1), 0, 0);
                if (stack2 != stack1) {
                    stack1.deleteSlice(1);
                }
            }
            if (i <= d2) {
                ip3.insert(stack2.getProcessor(1), 0, h1);
                stack2.deleteSlice(1);
            }
            stack3.addSlice(null, ip3);
        }
        return stack3;
    }

    boolean showDialog() {
        int[] wList = WindowManager.getIDList();
        if (wList == null || wList.length < 2) {
            this.error();
            return false;
        }
        String[] titles = new String[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        GenericDialog gd = new GenericDialog("Combiner");
        gd.addChoice("Stack1:", titles, titles[0]);
        gd.addChoice("Stack2:", titles, titles[1]);
        gd.addCheckbox("Combine vertically", false);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/image.html#combine");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int[] index = new int[3];
        int index1 = gd.getNextChoiceIndex();
        int index2 = gd.getNextChoiceIndex();
        this.imp1 = WindowManager.getImage(wList[index1]);
        this.imp2 = WindowManager.getImage(wList[index2]);
        vertical = gd.getNextBoolean();
        return true;
    }

    void error() {
        IJ.showMessage("StackCombiner", "This command requires two stacks\nthat are the same data type.");
    }
}

