/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.Location;

public class RandomAccessOutputStream
extends OutputStream
implements DataOutput,
Closeable {
    private IRandomAccess outputFile;
    private int currentBit = 0;
    private int currentByte = 0;
    private boolean dirtyByte = false;

    public RandomAccessOutputStream(String file2) throws IOException {
        this.outputFile = Location.getHandle(file2, true);
    }

    public RandomAccessOutputStream(IRandomAccess handle) {
        this.outputFile = handle;
    }

    public RandomAccessOutputStream(byte[] array) throws IOException {
        this(new ByteArrayHandle(array));
    }

    public void seek(long pos) throws IOException {
        this.outputFile.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.outputFile.getFilePointer();
    }

    public long length() throws IOException {
        return this.outputFile.length();
    }

    public void skipBytes(int skip) throws IOException {
        this.outputFile.seek(this.outputFile.getFilePointer() + (long)skip);
    }

    public void order(boolean little) {
        this.outputFile.setOrder(little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    public boolean isLittleEndian() {
        return this.outputFile.getOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    public void writeLine(String s) throws IOException {
        this.writeBytes(s);
        this.writeBytes("\n");
    }

    public void writeBits(int value, int numBits) throws IOException {
        if (numBits <= 0) {
            return;
        }
        for (int i = numBits - 1; i >= 0; --i) {
            int b = (value >> i & 1) << 7 - this.currentBit;
            this.currentByte |= b;
            this.dirtyByte = true;
            ++this.currentBit;
            if (this.currentBit <= 7) continue;
            this.currentBit = 0;
            this.flush();
            this.currentByte = 0;
        }
    }

    public void writeBits(String bitString) throws IOException {
        if (bitString == null) {
            throw new IllegalArgumentException("Bit string cannot be null");
        }
        for (char c : bitString.toCharArray()) {
            if (c == '1') {
                this.writeBits(1, 1);
                continue;
            }
            if (c == '0') {
                this.writeBits(0, 1);
                continue;
            }
            throw new IllegalArgumentException("Found illegal character '" + c + "'; write terminated");
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.flush();
        this.outputFile.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flush();
        this.outputFile.write(b, off, len);
    }

    public void write(ByteBuffer b) throws IOException {
        this.flush();
        this.outputFile.write(b);
    }

    public void write(ByteBuffer b, int off, int len) throws IOException {
        this.flush();
        this.outputFile.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.flush();
        this.outputFile.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.flush();
        this.outputFile.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.flush();
        this.outputFile.writeByte(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.flush();
        this.outputFile.writeBytes(s);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.flush();
        this.outputFile.writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.flush();
        this.outputFile.writeChars(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.flush();
        this.outputFile.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.flush();
        this.outputFile.writeFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.flush();
        this.outputFile.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.flush();
        this.outputFile.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.flush();
        this.outputFile.writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.flush();
        this.outputFile.writeUTF(str);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.outputFile.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.dirtyByte) {
            this.outputFile.writeByte(this.currentByte);
            this.dirtyByte = false;
        }
    }
}

