/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class MSVideoCodec
extends BaseCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("MS Video 1 compression not supported.");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        int y;
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        in.order(true);
        int row = 0;
        int column = 0;
        int plane = options.width * options.height;
        byte[] bytes = new byte[plane];
        short[] shorts = new short[plane];
        while (in.getFilePointer() < in.length() && row < options.width && column < options.height) {
            int ndx;
            int x;
            int y2;
            short a = (short)(in.read() & 0xFF);
            short b = (short)(in.read() & 0xFF);
            if (a == 0 && b == 0 && in.getFilePointer() >= in.length()) break;
            if (b >= 132 && b < 136) {
                int skip = (b - 132) * 256 + a;
                for (int i = 0; i < skip; ++i) {
                    if (options.previousImage != null) {
                        for (y2 = 0; y2 < 4; ++y2) {
                            for (x = 0; x < 4 && row + x < options.width && column + y2 < options.height; ++x) {
                                ndx = options.width * (column + y2) + row + x;
                                int oldNdx = options.width * (options.height - 1 - y2 - column) + row + x;
                                if (options.bitsPerSample == 8) {
                                    bytes[ndx] = options.previousImage[oldNdx];
                                    continue;
                                }
                                byte red = options.previousImage[oldNdx];
                                byte green = options.previousImage[oldNdx + plane];
                                byte blue = options.previousImage[oldNdx + 2 * plane];
                                shorts[ndx] = (short)((blue & 0x1F) << 10 | (green & 0x1F) << 5 | red & 0x1F);
                            }
                        }
                    }
                    if ((row += 4) < options.width) continue;
                    row = 0;
                    column += 4;
                }
                continue;
            }
            if (b >= 0 && b < 128) {
                if (options.bitsPerSample == 8) {
                    byte colorA = in.readByte();
                    byte colorB = in.readByte();
                    for (y2 = 0; y2 < 4; ++y2) {
                        for (x = 3; x >= 0; --x) {
                            ndx = options.width * (column + (3 - y2)) + row + x;
                            short flag = y2 < 2 ? b : a;
                            int shift = 4 - 4 * (y2 % 2) + x;
                            int cmp = 1 << shift;
                            bytes[ndx] = (flag & cmp) == cmp ? colorA : colorB;
                        }
                    }
                } else {
                    short check1 = in.readShort();
                    short check2 = in.readShort();
                    if ((check1 & 0x8000) == 32768) {
                        short q1a = check1;
                        short q1b = check2;
                        short q2a = in.readShort();
                        short q2b = in.readShort();
                        short q3a = in.readShort();
                        short q3b = in.readShort();
                        short q4a = in.readShort();
                        short q4b = in.readShort();
                        for (int y3 = 0; y3 < 4; ++y3) {
                            for (int x2 = 3; x2 >= 0; --x2) {
                                short colorA;
                                int ndx2 = options.width * (column + (3 - y3)) + row + x2;
                                short s = x2 < 2 ? (y3 < 2 ? q3a : q1a) : (colorA = y3 < 2 ? q4a : q2a);
                                short colorB = x2 < 2 ? (y3 < 2 ? q3b : q1b) : (y3 < 2 ? q4b : q2b);
                                short flag = y3 < 2 ? b : a;
                                int shift = 4 - 4 * (y3 % 2) + x2;
                                int cmp = 1 << shift;
                                if (ndx2 >= shorts.length) continue;
                                shorts[ndx2] = (flag & cmp) == cmp ? colorA : colorB;
                            }
                        }
                    } else {
                        short colorA = check1;
                        short colorB = check2;
                        for (int y4 = 0; y4 < 4; ++y4) {
                            int ndx3;
                            for (int x3 = 3; x3 >= 0 && (ndx3 = options.width * (column + (3 - y4)) + row + x3) < shorts.length; --x3) {
                                short flag = y4 < 2 ? b : a;
                                int shift = 4 - 4 * (y4 % 2) + x3;
                                int cmp = 1 << shift;
                                shorts[ndx3] = (flag & cmp) == cmp ? colorA : colorB;
                            }
                        }
                    }
                }
                if ((row += 4) < options.width) continue;
                row = 0;
                column += 4;
                continue;
            }
            if (options.bitsPerSample == 8 && 144 < b) {
                byte[] colors = new byte[8];
                in.read(colors);
                for (int y5 = 0; y5 < 4; ++y5) {
                    for (int x4 = 3; x4 >= 0; --x4) {
                        byte colorA;
                        int ndx4 = options.width * (column + (3 - y5)) + row + x4;
                        byte by = y5 < 2 ? (x4 < 2 ? colors[4] : colors[6]) : (colorA = x4 < 2 ? colors[0] : colors[2]);
                        byte colorB = y5 < 2 ? (x4 < 2 ? colors[5] : colors[7]) : (x4 < 2 ? colors[1] : colors[3]);
                        short flag = y5 < 2 ? b : a;
                        int shift = 4 - 4 * (y5 % 2) + x4;
                        int cmp = 1 << shift;
                        bytes[ndx4] = (flag & cmp) == cmp ? colorA : colorB;
                    }
                }
                if ((row += 4) < options.width) continue;
                row = 0;
                column += 4;
                continue;
            }
            for (int y6 = 0; y6 < 4; ++y6) {
                for (int x5 = 0; x5 < 4; ++x5) {
                    int ndx5 = options.width * (column + (3 - y6)) + row + x5;
                    if (options.bitsPerSample == 8) {
                        if (ndx5 >= bytes.length) continue;
                        bytes[ndx5] = (byte)(a & 0xFF);
                        continue;
                    }
                    if (ndx5 >= shorts.length) continue;
                    shorts[ndx5] = (short)((b << 8 | a) & 0xFFFF);
                }
            }
            if ((row += 4) < options.width) continue;
            row = 0;
            column += 4;
        }
        if (options.bitsPerSample == 8) {
            byte[] tmp = bytes;
            bytes = new byte[tmp.length];
            for (y = 0; y < options.height; ++y) {
                System.arraycopy(tmp, y * options.width, bytes, (options.height - y - 1) * options.width, options.width);
            }
            return bytes;
        }
        byte[] b = new byte[plane * 3];
        for (y = 0; y < options.height; ++y) {
            for (int x = 0; x < options.width; ++x) {
                int off = y * options.width + x;
                int dest = (options.height - y - 1) * options.width + x;
                b[dest + 2 * plane] = (byte)((shorts[off] & 0x7C00) >> 10);
                b[dest + plane] = (byte)((shorts[off] & 0x3E0) >> 5);
                b[dest] = (byte)(shorts[off] & 0x1F);
            }
        }
        return b;
    }
}

