/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.MDBService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.units.quantity.Length;

public class APLReader
extends FormatReader {
    private static final String[] METADATA_SUFFIXES = new String[]{"apl", "tnb", "mtb"};
    private String[] tiffFiles;
    private String[] xmlFiles;
    private transient TiffParser[] parser;
    private IFDList[] ifds;
    private List<String> used;

    public APLReader() {
        super("Olympus APL", new String[]{"apl", "tnb", "mtb", "tif"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
        this.datasetDescription = "One .apl file, one .mtb file, one .tnb file, and a directory containing one or more .tif files";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location file2;
        Location parent;
        if (APLReader.checkSuffix(name, METADATA_SUFFIXES)) {
            return true;
        }
        if (APLReader.checkSuffix(name, "tif") && open && (parent = (file2 = new Location(name).getAbsoluteFile()).getParentFile()) != null) {
            try {
                parent = parent.getParentFile();
                parent = parent.getParentFile();
            }
            catch (NullPointerException e) {
                return false;
            }
            Location aplFile = new Location(parent, parent.getName() + ".apl");
            return aplFile.exists();
        }
        return false;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        Location xmlFile;
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(this.used);
        if (this.getSeries() < this.xmlFiles.length && (xmlFile = new Location(this.xmlFiles[this.getSeries()])).exists() && !xmlFile.isDirectory()) {
            files.add(this.xmlFiles[this.getSeries()]);
        }
        if (!noPixels && this.getSeries() < this.tiffFiles.length && new Location(this.tiffFiles[this.getSeries()]).exists()) {
            files.add(this.tiffFiles[this.getSeries()]);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.parser == null) {
            this.parser = new TiffParser[this.getSeriesCount()];
        }
        if (this.parser[this.getSeries()] == null) {
            this.parser[this.getSeries()] = new TiffParser(this.tiffFiles[this.getSeries()]);
            this.parser[this.getSeries()].setDoCaching(false);
        }
        IFD ifd = (IFD)this.ifds[this.getSeries()].get(no);
        return this.parser[this.getSeries()].getSamples(ifd, buf, x, y, w, h);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tiffFiles = null;
            this.xmlFiles = null;
            this.used = null;
            this.ifds = null;
            if (this.parser != null) {
                for (TiffParser p : this.parser) {
                    if (p == null) continue;
                    p.getStream().close();
                }
            }
            this.parser = null;
        }
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds[this.getSeries()].get(0)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds[this.getSeries()].get(0)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        LOGGER.debug("Initializing {}", (Object)id);
        if (!APLReader.checkSuffix(id, "mtb")) {
            if (APLReader.checkSuffix(id, METADATA_SUFFIXES)) {
                String mtbFile;
                int underscore;
                int separator = id.lastIndexOf(File.separator);
                if (separator < 0) {
                    separator = 0;
                }
                if ((underscore = id.lastIndexOf("_")) < separator || APLReader.checkSuffix(id, "apl")) {
                    underscore = id.lastIndexOf(".");
                }
                if (!new Location(mtbFile = id.substring(0, underscore) + "_d.mtb").exists()) {
                    throw new FormatException(".mtb file not found");
                }
                this.currentId = new Location(mtbFile).getAbsolutePath();
            } else {
                String[] list;
                Location parent = new Location(id).getAbsoluteFile().getParentFile();
                parent = parent.getParentFile();
                for (String f : list = parent.list(true)) {
                    if (!APLReader.checkSuffix(f, "mtb")) continue;
                    this.currentId = new Location(parent, f).getAbsolutePath();
                    break;
                }
                if (!APLReader.checkSuffix(this.currentId, "mtb")) {
                    throw new FormatException(".mtb file not found");
                }
            }
        }
        String mtb = new Location(this.currentId).getAbsolutePath();
        LOGGER.debug("Reading .mtb file '{}'", (Object)mtb);
        MDBService mdb = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            mdb = factory.getInstance(MDBService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("MDB Tools Java library not found", de);
        }
        Object[] columnNames = null;
        List rows = null;
        try {
            mdb.initialize(mtb);
            rows = mdb.parseDatabase().get(0);
            Object[] tmpNames = columnNames = (String[])rows.get(0);
            columnNames = new String[tmpNames.length - 1];
            System.arraycopy(tmpNames, 1, columnNames, 0, columnNames.length);
        }
        finally {
            mdb.close();
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i = 1; i < rows.size(); ++i) {
                String[] row = (String[])rows.get(i);
                for (int q = 0; q < row.length; ++q) {
                    this.addGlobalMetaList(columnNames[q], row[q]);
                }
            }
        }
        this.used = new ArrayList<String>();
        this.used.add(mtb);
        String tnb = mtb.substring(0, mtb.lastIndexOf("."));
        if (tnb.lastIndexOf("_") > tnb.lastIndexOf(File.separator)) {
            tnb = tnb.substring(0, tnb.lastIndexOf("_"));
        }
        this.used.add(tnb + "_1.tnb");
        this.used.add(tnb + ".apl");
        String idPath = new Location(id).getAbsolutePath();
        if (!this.used.contains(idPath) && APLReader.checkSuffix(idPath, METADATA_SUFFIXES)) {
            this.used.add(idPath);
        }
        int calibrationUnit = DataTools.indexOf(columnNames, "Calibration Unit");
        int colorChannels = DataTools.indexOf(columnNames, "Color Channels");
        int frames = DataTools.indexOf(columnNames, "Frames");
        int calibratedHeight = DataTools.indexOf(columnNames, "Height");
        int calibratedWidth = DataTools.indexOf(columnNames, "Width");
        int path = DataTools.indexOf(columnNames, "Image Path");
        if (path == -1) {
            path = DataTools.indexOf(columnNames, "Path");
        }
        int filename = DataTools.indexOf(columnNames, "File Name");
        int magnification = DataTools.indexOf(columnNames, "Magnification");
        int width = DataTools.indexOf(columnNames, "X-Resolution");
        int height = DataTools.indexOf(columnNames, "Y-Resolution");
        int imageType = DataTools.indexOf(columnNames, "Image Type");
        int imageName = DataTools.indexOf(columnNames, "Image Name");
        int zLayers = DataTools.indexOf(columnNames, "Z-Layers");
        String parentDirectory = mtb.substring(0, mtb.lastIndexOf(File.separator));
        LOGGER.debug("Searching {} for a directory with TIFFs", (Object)parentDirectory);
        Location dir = new Location(parentDirectory);
        String topDirectory = null;
        int index = 2;
        String pathName = ((String[])rows.get(index++))[path].trim();
        while (pathName.equals("") && index < rows.size()) {
            pathName = ((String[])rows.get(index++))[path].trim();
        }
        pathName = pathName.replace('\\', File.separatorChar);
        pathName = pathName.replaceAll("/", File.separator);
        String[] dirs = pathName.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        for (int i = dirs.length - 1; i >= 0; --i) {
            Location file2;
            if (dirs[i].indexOf("_DocumentFiles") <= 0 || !(file2 = new Location(dir, dirs[i])).exists()) continue;
            topDirectory = file2.getAbsolutePath();
            break;
        }
        if (topDirectory == null) {
            String[] list;
            for (String f : list = dir.list()) {
                LOGGER.debug("  '{}'", (Object)f);
                Location file3 = new Location(dir, f);
                if (!file3.isDirectory() || f.indexOf("_DocumentFiles") <= 0) continue;
                topDirectory = file3.getAbsolutePath();
                LOGGER.debug("Found {}", (Object)topDirectory);
                break;
            }
        }
        if (topDirectory == null) {
            throw new FormatException("Could not find a directory with TIFF files.");
        }
        ArrayList<Integer> seriesIndexes = new ArrayList<Integer>();
        for (int i = 1; i < rows.size(); ++i) {
            String file4 = this.parseFilename((String[])rows.get(i), filename, path);
            if (file4.equals("") || !new Location(file4 = topDirectory + File.separator + file4).exists() || !APLReader.checkSuffix(file4, "tif")) continue;
            seriesIndexes.add(i);
        }
        int seriesCount = seriesIndexes.size();
        this.core.clear();
        this.tiffFiles = new String[seriesCount];
        this.xmlFiles = new String[seriesCount];
        this.parser = new TiffParser[seriesCount];
        this.ifds = new IFDList[seriesCount];
        for (int i = 0; i < seriesCount; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            int secondRow = (Integer)seriesIndexes.get(i);
            int firstRow = secondRow - 1;
            String[] row2 = (String[])rows.get(firstRow);
            String[] row3 = (String[])rows.get(secondRow);
            if (frames > -1) {
                ms.sizeT = this.parseDimension(row3[frames]);
            }
            if (zLayers > -1) {
                ms.sizeZ = this.parseDimension(row3[zLayers]);
            }
            if (colorChannels > -1) {
                ms.sizeC = this.parseDimension(row3[colorChannels]);
            } else if (imageType > -1 && row3[imageType] != null && row3[imageType].equals("RGB")) {
                ms.sizeC = 3;
            }
            ms.dimensionOrder = "XYCZT";
            if (ms.sizeZ == 0) {
                ms.sizeZ = 1;
            }
            if (ms.sizeC == 0) {
                ms.sizeC = 1;
            }
            if (ms.sizeT == 0) {
                ms.sizeT = 1;
            }
            this.xmlFiles[i] = topDirectory + File.separator + this.parseFilename(row2, filename, path);
            this.tiffFiles[i] = topDirectory + File.separator + this.parseFilename(row3, filename, path);
            this.parser[i] = new TiffParser(this.tiffFiles[i]);
            this.parser[i].setDoCaching(false);
            this.ifds[i] = this.parser[i].getIFDs();
            for (IFD ifd : this.ifds[i]) {
                this.parser[i].fillInIFD(ifd);
            }
            IFD ifd = (IFD)this.ifds[i].get(0);
            PhotoInterp photo = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.rgb = samples > 1 || photo == PhotoInterp.RGB;
            ms.pixelType = ifd.getPixelType();
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = photo == PhotoInterp.RGB_PALETTE && ifd.containsKey(320);
            ms.imageCount = this.ifds[i].size();
            if (ms.sizeZ * ms.sizeT * (ms.rgb ? 1 : ms.sizeC) == ms.imageCount) continue;
            ms.sizeT = ms.imageCount / (ms.rgb ? 1 : ms.sizeC);
            ms.sizeZ = 1;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < seriesCount; ++i) {
            String[] row = (String[])rows.get((Integer)seriesIndexes.get(i));
            MetadataTools.setDefaultCreationDate(store, mtb, i);
            store.setImageName(row[imageName].trim(), i);
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            double realWidth = Double.parseDouble(row[calibratedWidth]);
            double realHeight = Double.parseDouble(row[calibratedHeight]);
            String units = row[calibrationUnit];
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            double px = realWidth / (double)ms.sizeX;
            double py = realHeight / (double)ms.sizeY;
            Length physicalSizeX = FormatTools.getPhysicalSizeX((Double)px, units);
            Length physicalSizeY = FormatTools.getPhysicalSizeY((Double)py, units);
            if (physicalSizeX != null) {
                store.setPixelsPhysicalSizeX(physicalSizeX, i);
            }
            if (physicalSizeY == null) continue;
            store.setPixelsPhysicalSizeY(physicalSizeY, i);
        }
        this.setSeries(0);
    }

    private int parseDimension(String dim) {
        try {
            return Integer.parseInt(dim);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private String parseFilename(String[] row, int filenameIndex, int pathIndex) {
        String file2 = row[filenameIndex].trim();
        if (file2 != null && APLReader.checkSuffix(file2, "tif")) {
            return file2;
        }
        String filePath = row[pathIndex].trim();
        filePath = filePath.replace('\\', File.separatorChar);
        filePath = filePath.replaceAll("/", File.separator);
        String[] dirs = filePath.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        file2 = dirs[dirs.length - 1].trim();
        return file2;
    }
}

