/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5CompoundDataMap;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.io.IOException;
import java.util.List;
import loci.common.services.AbstractService;
import loci.formats.services.JHDFService;

public class JHDFServiceImpl
extends AbstractService
implements JHDFService {
    public static final String NO_JHDF_MSG = "JHDF is required to read HDF5 files. Please obtain the necessary JAR files from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html.\nRequired JAR files is cisd-jhdf5-batteries_included_lin_win_mac.jar.";
    private String currentFile;
    private IHDF5Reader hdfReader;
    private IHDF5Writer hdfWriter;

    public JHDFServiceImpl() {
        this.checkClassDependency(MDIntArray.class);
        this.checkClassDependency(HDF5Factory.class);
    }

    @Override
    public void setFile(String file2) throws IOException {
        this.currentFile = file2;
        this.hdfReader = HDF5Factory.openForReading(file2);
    }

    @Override
    public void setFileForWrite(String file2) throws IOException {
        this.currentFile = file2;
        this.hdfWriter = HDF5Factory.open(file2);
    }

    @Override
    public String getFile() {
        return this.currentFile;
    }

    @Override
    public List<String> getMember(String path) {
        return this.hdfReader.getGroupMembers(path);
    }

    @Override
    public int[] getShape(String path) {
        long[] tmp = this.hdfReader.getDataSetInformation(path).getDimensions();
        int[] result = new int[tmp.length];
        for (int k = 0; k < tmp.length; ++k) {
            result[k] = (int)tmp[k];
        }
        return result;
    }

    @Override
    public MDByteArray readByteArray(String path) {
        return this.hdfReader.int8().readMDArray(path);
    }

    @Override
    public MDIntArray readIntArray(String path) {
        return this.hdfReader.int32().readMDArray(path);
    }

    @Override
    public MDIntArray readIntBlockArray(String path, int[] offset, int[] size) {
        long[] longOffset = new long[offset.length];
        for (int k = 0; k < offset.length; ++k) {
            longOffset[k] = offset[k];
        }
        return this.hdfReader.int32().readMDArrayBlockWithOffset(path, size, longOffset);
    }

    @Override
    public MDByteArray readByteBlockArray(String path, int[] offset, int[] size) {
        long[] longOffset = new long[offset.length];
        for (int k = 0; k < offset.length; ++k) {
            longOffset[k] = offset[k];
        }
        return this.hdfReader.int8().readMDArrayBlockWithOffset(path, size, longOffset);
    }

    @Override
    public MDShortArray readShortBlockArray(String path, int[] offset, int[] size) {
        long[] longOffset = new long[offset.length];
        for (int k = 0; k < offset.length; ++k) {
            longOffset[k] = offset[k];
        }
        return this.hdfReader.int16().readMDArrayBlockWithOffset(path, size, longOffset);
    }

    @Override
    public String[] readStringArray(String path) {
        return this.hdfReader.string().readArray(path);
    }

    @Override
    public HDF5CompoundDataMap[] readCompoundArrayDataMap(String path) {
        return this.hdfReader.readCompoundArray(path, HDF5CompoundDataMap.class);
    }

    @Override
    public int getElementSize(String path) {
        return this.hdfReader.getDataSetInformation(path).getTypeInformation().getElementSize();
    }

    @Override
    public void initIntArray(String path, long[] dimensions, long bpp) {
        if (bpp == 1L) {
            this.hdfWriter.uint8().createMDArray(path, dimensions, new int[]{1, 1, 1, (int)dimensions[3], (int)dimensions[4]}, HDF5IntStorageFeatures.createDeflationKeep(1));
        } else if (bpp == 2L) {
            this.hdfWriter.uint16().createMDArray(path, dimensions, new int[]{1, 1, 1, (int)dimensions[3], (int)dimensions[4]}, HDF5IntStorageFeatures.createDeflationKeep(1));
        } else if (bpp == 4L) {
            this.hdfWriter.int32().createMDArray(path, dimensions, new int[]{1, 1, 1, (int)dimensions[3], (int)dimensions[4]}, HDF5IntStorageFeatures.createDeflationKeep(1));
        }
    }

    @Override
    public void writeArraySlice(String path, MDByteArray image, long[] offset) {
        int[] mem_offset = new int[]{0, 0, 0, 0, 0};
        this.hdfWriter.uint8().writeMDArrayBlockWithOffset(path, image, image.dimensions(), offset, mem_offset);
    }

    @Override
    public void writeArraySlice(String path, MDShortArray image, long[] offset) {
        int[] mem_offset = new int[]{0, 0, 0, 0, 0};
        this.hdfWriter.uint16().writeMDArrayBlockWithOffset(path, image, image.dimensions(), offset, mem_offset);
    }

    @Override
    public void writeArraySlice(String path, MDIntArray image, long[] offset) {
        int[] mem_offset = new int[]{0, 0, 0, 0, 0};
        this.hdfWriter.int32().writeMDArrayBlockWithOffset(path, image, image.dimensions(), offset, mem_offset);
    }

    @Override
    public void createGroup(String path) throws IOException {
        try {
            this.hdfWriter.object().createGroup(path);
        }
        catch (Exception e) {
            throw new IOException("JHDFService: Unable to create group.\n" + e.getMessage());
        }
    }

    @Override
    public boolean exists(String path) {
        return this.hdfReader.exists(path);
    }

    @Override
    public void close() throws IOException {
        if (this.hdfReader != null) {
            this.hdfReader.close();
        }
        if (this.hdfWriter != null) {
            this.hdfWriter.close();
        }
        this.currentFile = null;
        this.hdfReader = null;
    }
}

