/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Time;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsTimeEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsTime implements Enumeration
{
    YOTTAS("Ys"),
    ZETTAS("Zs"),
    EXAS("Es"),
    PETAS("Ps"),
    TERAS("Ts"),
    GIGAS("Gs"),
    MEGAS("Ms"),
    KS("ks"),
    HS("hs"),
    DAS("das"),
    S("s"),
    DS("ds"),
    CS("cs"),
    MS("ms"),
    MICROS("\u00b5s"),
    NS("ns"),
    PS("ps"),
    FS("fs"),
    AS("as"),
    ZS("zs"),
    YS("ys"),
    MIN("min"),
    H("h"),
    D("d");

    private final String value;

    private UnitsTime(String value) {
        this.value = value;
    }

    public static UnitsTime fromString(String value) throws EnumerationException {
        if ("Ys".equals(value)) {
            return YOTTAS;
        }
        if ("Zs".equals(value)) {
            return ZETTAS;
        }
        if ("Es".equals(value)) {
            return EXAS;
        }
        if ("Ps".equals(value)) {
            return PETAS;
        }
        if ("Ts".equals(value)) {
            return TERAS;
        }
        if ("Gs".equals(value)) {
            return GIGAS;
        }
        if ("Ms".equals(value)) {
            return MEGAS;
        }
        if ("ks".equals(value)) {
            return KS;
        }
        if ("hs".equals(value)) {
            return HS;
        }
        if ("das".equals(value)) {
            return DAS;
        }
        if ("s".equals(value)) {
            return S;
        }
        if ("ds".equals(value)) {
            return DS;
        }
        if ("cs".equals(value)) {
            return CS;
        }
        if ("ms".equals(value)) {
            return MS;
        }
        if ("\u00b5s".equals(value)) {
            return MICROS;
        }
        if ("ns".equals(value)) {
            return NS;
        }
        if ("ps".equals(value)) {
            return PS;
        }
        if ("fs".equals(value)) {
            return FS;
        }
        if ("as".equals(value)) {
            return AS;
        }
        if ("zs".equals(value)) {
            return ZS;
        }
        if ("ys".equals(value)) {
            return YS;
        }
        if ("min".equals(value)) {
            return MIN;
        }
        if ("h".equals(value)) {
            return H;
        }
        if ("d".equals(value)) {
            return D;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsTime.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PrimitiveNumber> Time create(T newValue, UnitsTime newUnit) {
        Time theQuantity = null;
        try {
            theQuantity = UnitsTimeEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Number> Time create(T newValue, UnitsTime newUnit) {
        Time theQuantity = null;
        try {
            theQuantity = UnitsTimeEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

