/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.util;

import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;

public class JNAUtils {
    public static NativeSizeByReference castToNS(IntByReference local) {
        NativeSizeByReference nl = new NativeSizeByReference();
        nl.setPointer(local.getPointer());
        return nl;
    }

    public static NativeSizeByReference castToNS(LongByReference local) {
        NativeSizeByReference nl = new NativeSizeByReference();
        nl.setPointer(local.getPointer());
        return nl;
    }

    public static NativeSize readNS(Pointer p, long offset) {
        if (NativeSize.SIZE == 4) {
            return new NativeSize((long)p.getInt(offset));
        }
        if (NativeSize.SIZE == 8) {
            return new NativeSize(p.getLong(offset));
        }
        throw new RuntimeException("sizeof(size_t) must be either 4 or 8");
    }

    public static void writeNS(Pointer p, long offset, long value) {
        if (NativeSize.SIZE == 4) {
            p.setInt(offset, (int)value);
        } else if (NativeSize.SIZE == 8) {
            p.setLong(offset, value);
        } else {
            throw new RuntimeException("sizeof(size_t) must be either 4 or 8");
        }
    }

    public static NativeSize[] readNSArray(Pointer p, int n) {
        NativeSize[] sizes = new NativeSize[n];
        for (int i = 0; i < n; ++i) {
            sizes[i] = JNAUtils.readNS(p, i * NativeSize.SIZE);
        }
        return sizes;
    }

    public static void writeNSArray(Pointer p, long ... values) {
        if (values == null) {
            return;
        }
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            JNAUtils.writeNS(p, i * NativeSize.SIZE, values[i]);
        }
    }

    public static Memory toNSArray(long ... values) {
        if (values == null) {
            return null;
        }
        Memory mem = new Memory(values.length * NativeSize.SIZE);
        JNAUtils.writeNSArray(mem, values);
        return mem;
    }

    public static NativeSize[] toNS(int[] ints) {
        if (ints == null) {
            return null;
        }
        int n = ints.length;
        NativeSize[] nls = new NativeSize[n];
        for (int i = 0; i < n; ++i) {
            nls[i] = JNAUtils.toNS(ints[i]);
        }
        return nls;
    }

    public static NativeSize[] toNS(long ... ints) {
        if (ints == null) {
            return null;
        }
        int n = ints.length;
        NativeSize[] nls = new NativeSize[n];
        for (int i = 0; i < n; ++i) {
            nls[i] = JNAUtils.toNS(ints[i]);
        }
        return nls;
    }

    public static NativeSize toNS(int i) {
        return new NativeSize((long)i);
    }

    public static NativeSize toNS(long i) {
        return new NativeSize(i);
    }
}

