package plugins.lagache.colocmanders;


import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javassist.expr.NewArray;
import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.Plugin;

import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI2DArea;
import icy.roi.ROI2DRectangle;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import icy.util.ShapeUtil.BooleanOperator;
import icy.util.StringUtil;


import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;



// Colocalisation with Ripley function K
// Significant 

public class Manders extends EzPlug{
	
		EzVarSequence sequence1 = new EzVarSequence("Sequence 1");
		EzVarSequence sequence2 = new EzVarSequence("Sequence 2");
		
		
		//private EzVarBoolean surface =  new EzVarBoolean("Use ROIs Surface", false) ;
		EzVarDouble M1 = new EzVarDouble("M1");
		EzVarDouble M2 = new EzVarDouble("M2");
		EzVarDouble M1S = new EzVarDouble("M1 (surface)");
		EzVarDouble M2S = new EzVarDouble("M2 (surface)");
		
		EzVarText M1_label,M2_label,M1S_label,M2S_label,P1_label,P2_label,P1S_label,P2S_label;
		
		//EzVarInteger block = new EzVarInteger("block size",1,1,20,1);
		EzVarDouble P1=new EzVarDouble("p value (M1)");
		EzVarDouble P2=new EzVarDouble("p value (M2)");
		EzVarDouble P1S=new EzVarDouble("p value (M1 Surface)");
		EzVarDouble P2S=new EzVarDouble("p value (M2 Surface)");
				
		protected EzVarBoolean exportExcel = new EzVarBoolean("Export to Excel",false);
		protected EzVarFile exportExcelFile = new EzVarFile("Excel file", "");

		
			private double[] MandersCoeff(EzVarSequence sequence1,
				EzVarSequence sequence2, int t) {
			
			double[] Manders = new double[16];
			double manders1=0;double manders2=0;			
			double manders_surface1=0;double manders_surface2=0;
			
			double I1_tot,I1_mean,I1_var,I1_surface,I2_tot,I2_mean,I2_var,I2_surface;
			
			Sequence seq1 = sequence1.getValue();
			Sequence seq2 = sequence2.getValue();
			IcyBufferedImage img1 = seq1.getAllImage().get(t);
			IcyBufferedImage img2 = seq2.getAllImage().get(t);

			//cration des 2 ROIs pour les 2 signaux
			//List<ROI2D> roiArrayList1 = seq1.getROI2Ds();
			//calcul de la ROI 1 
			ArrayList<ROI2D> roiArrayList1 = seq1.getROI2Ds();
			ArrayList<ROI2D> roiArrayList1_t = new ArrayList<ROI2D>();		
					for (ROI2D roi:roiArrayList1){
						if (roi.getT()==t||roi.getT()==-1){
							roi.setC(0);roi.setZ(0);
							if (roi.getT()==-1){
								ROI2D roiclone=(ROI2D) roi.getCopy();roiclone.setT(t);roiArrayList1_t.add(roiclone);roiclone.delete();}
							else{
								roiArrayList1_t.add(roi);}							
						}	
					}
								
					
					if (roiArrayList1_t.isEmpty())
						roiArrayList1_t.add(new ROI2DRectangle(seq1.getBounds2D()));
							//roiArrayList1_t.add(new ROI2DRectangle());						
						
						//calcul de l'union des ROIs en forcant le canal  0
					ROI2D roiUnion1 = roiArrayList1_t.get(0);
					for (ROI2D roi:roiArrayList1_t){						
						roiUnion1=(ROI2D)roiUnion1.getUnion(roi);
						roiUnion1.setC(0);roiUnion1.setZ(0);roiUnion1.setT(t);
					}
					
						//ROI roiUnion1 = ROIUtil.getUnion(roiArrayList1_t);
						Rectangle2D roiBounds1 = roiUnion1.getBounds5D().toRectangle2D();
						
						//calcul ROI 2
					 
						ArrayList<ROI2D> roiArrayList2 = seq2.getROI2Ds();
						ArrayList<ROI2D> roiArrayList2_t = new ArrayList<ROI2D>();		
								for (ROI2D roi:roiArrayList2){
									if (roi.getT()==t||roi.getT()==-1){
										roi.setC(0);roi.setZ(0);
										if (roi.getT()==-1){
											ROI2D roiclone=(ROI2D) roi.getCopy();roiclone.setT(t);roiArrayList2_t.add(roiclone);roiclone.delete();}
										else{
											roiArrayList2_t.add(roi);}							
									}	
								}
											
								
								if (roiArrayList2_t.isEmpty())
									roiArrayList2_t.add(new ROI2DRectangle(seq2.getBounds2D()));
										//roiArrayList2_t.add(new ROI2DRectangle());						
									
									//calcul de l'union des ROIs en forcant le canal  0
									//ROI roiUnion2 = ROIUtil.getUnion(roiArrayList2_t);
								ROI2D roiUnion2 = roiArrayList2_t.get(0);
								for (ROI2D roi:roiArrayList2_t){						
									roiUnion2 = (ROI2D)roiUnion2.getUnion(roi);
									roiUnion2.setC(0);roiUnion2.setZ(0);roiUnion2.setT(t);
								}
									Rectangle2D roiBounds2 = roiUnion2.getBounds5D().toRectangle2D();
				

												
			if ((roiUnion1 instanceof ROI2D)&&(roiUnion2 instanceof ROI2D)) {
				ROI2D roi2d1 = (ROI2D) roiUnion1;
				ROI2D roi2d2 = (ROI2D) roiUnion2;
				
				double[] tab1 = Array1DUtil.arrayToDoubleArray(img1.getDataXY(0),
						img1.isSignedDataType());
				double[] tab2 = Array1DUtil.arrayToDoubleArray(img2.getDataXY(0),
						img2.isSignedDataType());

				int sizeX = img1.getSizeX();
				
				int minX1 = (int) roiBounds1.getMinX();
				int minY1 = (int) roiBounds1.getMinY();
				int maxX1 = (int) roiBounds1.getMaxX();
				int maxY1 = (int) roiBounds1.getMaxY();
				
				
				int minX2 = (int) roiBounds2.getMinX();
				int minY2 = (int) roiBounds2.getMinY();
				int maxX2 = (int) roiBounds2.getMaxX();
				int maxY2 = (int) roiBounds2.getMaxY();
				
				int minX = Math.min(minX1, minX2);
				int minY = Math.min(minY1, minY2);
				int maxX=  Math.max(maxX1, maxX2);
				int maxY=  Math.max(maxY1, maxY2);
				
				
				double intensite1 = 0;
				double intensite_2_1 = 0;
				
				double intensite2 = 0;
				double intensite_2_2 = 0;
				
				double inter1 = 0;
				double inter2 = 0;
				double inter1_2 = 0;
				double inter2_2 = 0;

				
				double surface_inter=0;
				double surface1 = 0;
				double surface2 = 0;
				
				Rectangle2D rect = seq1.getBounds2D();
				double minXSequence = rect.getMinX()+1;
				double maxXSequence = rect.getMaxX()-1;
				double minYSequence = rect.getMinY()+1;
				double maxYSequence = rect.getMaxY()-1;
				
				minX = Math.max(minX, (int)minXSequence);
				maxX = Math.min(maxX, (int)maxXSequence);
				minY = Math.max(minY, (int)minYSequence);
				maxY = Math.min(maxY, (int)maxYSequence);
				
				for (int x = minX; x <= maxX; x++) {
					for (int y = minY; y <= maxY; y++) {
						int off = (y * sizeX) + x;
						if (roi2d1.contains(x, y)) {							
							intensite1 += tab1[off];
							intensite_2_1 += Math.pow(tab1[off],2);
							surface1+=1;
							if (roi2d2.contains(x, y)) {
								inter1+= tab1[off];
								inter1_2+=Math.pow(tab1[off],2);
								
								inter2+= tab2[off];
								inter2_2+=Math.pow(tab2[off],2);
								
								surface_inter+=1;								
							}}
						if (roi2d2.contains(x, y)){
							intensite2+=tab2[off];
							intensite_2_2 += Math.pow(tab2[off],2);
							surface2+=1;							}
						}
					}
				
				I1_tot=inter1;I2_tot=inter2;
				I1_surface=surface_inter;I2_surface=surface_inter;
				if (surface_inter>0)
					{I1_mean=I1_tot/I1_surface;I2_mean=I2_tot/I2_surface;
					I1_var=inter1_2/surface_inter-Math.pow(I1_mean, 2);
					I2_var=inter2_2/surface_inter-Math.pow(I2_mean, 2);
					}
				else
					{I1_mean=0;I2_mean=0;I1_var=0;I2_var=0;}
				
				Manders[8]=I1_tot;Manders[9]=I1_mean;Manders[10]=I1_var;Manders[11]=I1_surface;
				Manders[12]=I2_tot;Manders[13]=I2_mean;Manders[14]=I2_var;Manders[15]=I2_surface;
												
				if (intensite1 != 0) 
				manders1=inter1/intensite1;
				else
				manders1=0;	
				
				if (intensite2 != 0)
				manders2=inter2/intensite2;
				else
				manders2=0;	
					
				
				if (surface1> 0)
					manders_surface1=surface_inter/surface1;
				else
					manders_surface1=0;
					
				if (surface2 > 0)
					manders_surface2=surface_inter/surface2;
				else
				manders_surface2=0;
					
				Manders[0]=manders1;
				Manders[1]=manders2;
				Manders[2]=manders_surface1;
				Manders[3]=manders_surface2;
				
				//calcul des p_vallues par TCL sur pixel scrambling
				//int blocksize = block.getValue();
				double p2=surface2/(seq1.getWidth()*seq1.getHeight());												
				double p1=surface1/(seq2.getWidth()*seq2.getHeight());
				
				double variance_M1=0,variance_M2=0;
				double variance_M1_surface=0,variance_M2_surface=0;
				double mean_1 = p2;double mean_2 = p1;
				
				if (intensite1>0)
					variance_M1 = (p2*(1-p2)*intensite_2_1)/(Math.pow(intensite1,2));
				
				if (surface1>0)
					variance_M1_surface = p2*(1-p2)/(surface1);
				
				if (intensite2>0)
					variance_M2 = (p1*(1-p1)*intensite_2_2)/(Math.pow(intensite2,2));
				
				if (surface2>0)
					variance_M2_surface = p1*(1-p1)/(surface2);
				
				//sous l'hypothese nulle, M1-mu/sigma est normal-centre-reduit
				double R1=0;double R2=0;
				double R1_surface=0;double R2_surface=0;
				
				if (variance_M1>0)
					R1=(manders1-mean_1)/Math.sqrt(variance_M1);
								
				if (variance_M1_surface>0)
					R1_surface=(manders_surface1-mean_1)/Math.sqrt(variance_M1_surface);
								
				if (variance_M2>0)
					R2=(manders2-mean_2)/Math.sqrt(variance_M2);
								
				if (variance_M2_surface>0)
					R2_surface=(manders_surface2-mean_2)/Math.sqrt(variance_M2_surface);
															
				ErrorFunction er = new ErrorFunction();
				
				Manders[4]=0.5*(1+er.erf(R1/Math.sqrt(2)));				
				if (manders1==1)
					Manders[4]=0;				
				
				Manders[5]=0.5*(1+er.erf(R1/Math.sqrt(2)));				
				if (manders2==1)
					Manders[5]=0;
				
				Manders[6]=0.5*(1+er.erf(R1_surface/Math.sqrt(2)));
				if (manders_surface1==1)
					Manders[6]=0;
				
				Manders[7]=0.5*(1+er.erf(R2_surface/Math.sqrt(2)));
				if (manders_surface2==1)
					Manders[7]=0;}

			return Manders;
		}


		// AIRE
		private double Roiarea(ROI2D roi) {
			BooleanMask2D roiMask = roi.getAsBooleanMask(true);
			int minx = Math.max(0, roiMask.bounds.x);
			int maxx = roiMask.bounds.x + roiMask.bounds.width;
			int miny = Math.max(0, roiMask.bounds.y);
			int maxy = roiMask.bounds.y + roiMask.bounds.height;

			int areaR = 0;// size Cell
			for (int ix = minx; ix < maxx; ix++)
				for (int y = miny; y < maxy; y++) {
					if (roiMask.contains(ix, y)) {
						areaR++;
					}

				}
			return areaR;
		}

		private void performAnalysis(EzVarSequence sequence_1,
				EzVarSequence sequence_2, EzVarBoolean exportExcel) {

			//initialisation excel dans tous les cas
			
			// initialisation xls
					int row = 0;
					XlsManager xlsManager = null;
					if (exportExcel.getValue()) {
						int page = 1;
						try {
							File f = exportExcelFile.getValue(true);
							if (!FileUtil.getFileExtension(f.getPath(), false)
									.equalsIgnoreCase("xls"))
								f = new File(f.getPath() + ".xls");
							xlsManager = new XlsManager(f);
							xlsManager.createNewPage("Page " + page);
						} catch (Exception e) {
							e.printStackTrace();
							return;
						}

						xlsManager.setLabel(0, 0, "Date of XLS page:");
						row++;
						xlsManager.setLabel(0, row, new Date().toString());
						row++;
						
						xlsManager.setLabel(0, row, "Time");
						xlsManager.setLabel(1, row, "M1");
						xlsManager.setLabel(2, row, "M2");
						xlsManager.setLabel(3, row, "p value (M1)");
						xlsManager.setLabel(4, row, "p value (M2)");
						xlsManager.setLabel(5, row, "M1 (Surface)");
						xlsManager.setLabel(6, row, "M2 (Surface)");
						xlsManager.setLabel(7, row, "p value (M1 Surface)");
						xlsManager.setLabel(8, row, "p value(M2 Surface)");
						xlsManager.setLabel(9, row, "Total colocalized intensity (1)");
						xlsManager.setLabel(10, row, "Mean colocalized intensity (1)");
						xlsManager.setLabel(11, row, "Variance colocalized intensity (1)");
						xlsManager.setLabel(12, row, "Total colocalized surface (1)");
						xlsManager.setLabel(13, row, "Total colocalized intensity (2)");
						xlsManager.setLabel(14, row, "Mean colocalized intensity (2)");
						xlsManager.setLabel(15, row, "Variance colocalized intensity (2)");
						xlsManager.setLabel(16, row, "Total colocalized surface (2)");
						row++;}		
										
		//initialisation boucle en temps
			// temps total de la sequence
			int T;
			if (sequence_1.getValue()!=null){T=sequence_1.getValue().getLength();}
			else{return;}
						
				//dmarrage boucle en temps
				for (int t = 0; t < T; t += 1) {
					if (exportExcel.getValue()){
					xlsManager.setNumber(0, row, t);}
											
				
				double manders[] = MandersCoeff(sequence_1, sequence_2, t);
				M1.setValue(manders[0]);
				M1_label.setValue(StringUtil.toString(manders[0], 2));
				
				M2.setValue(manders[1]);
				M2_label.setValue(StringUtil.toString(manders[1], 2));
				
				M1S.setValue(manders[2]);
				M1S_label.setValue(StringUtil.toString(manders[2], 2));
				
				M2S.setValue(manders[3]);
				M2S_label.setValue(StringUtil.toString(manders[3], 2));
				
				P1.setValue(manders[4]);
				P1_label.setValue(StringUtil.toString(manders[4], 2));
				
				P2.setValue(manders[5]);
				P2_label.setValue(StringUtil.toString(manders[5], 2));
				
				P1S.setValue(manders[6]);
				P1S_label.setValue(StringUtil.toString(manders[6], 2));
				
				P2S.setValue(manders[7]);
				P2S_label.setValue(StringUtil.toString(manders[7], 2));
							
				//gerer l'export excel
				if (exportExcel.getValue()) {
				xlsManager.setNumber(1, row, M1.getValue());
				xlsManager.setNumber(2, row, M2.getValue());
				xlsManager.setNumber(3, row, P1.getValue());
				xlsManager.setNumber(4, row, P2.getValue());
				
				xlsManager.setNumber(5, row, M1S.getValue());
				xlsManager.setNumber(6, row, M2S.getValue());
				xlsManager.setNumber(7, row, P1S.getValue());
				xlsManager.setNumber(8, row, P2S.getValue());
				
				xlsManager.setNumber(9, row, manders[8]);
				xlsManager.setNumber(10, row, manders[9]);
				xlsManager.setNumber(11, row, manders[10]);
				xlsManager.setNumber(12, row, manders[11]);
				xlsManager.setNumber(13, row, manders[12]);
				xlsManager.setNumber(14, row, manders[13]);
				xlsManager.setNumber(15, row, manders[14]);
				xlsManager.setNumber(16, row, manders[15]);
				
				
				}
				
				row++;
				}
				
				
			if (exportExcel.getValue()) {
				xlsManager.SaveAndClose();}	
			}
			


		@Override
		public void clean() {
			// TODO Auto-generated method stub

		}

		@Override
		protected void execute() {
			if (sequence1.getValue() == null || sequence2.getValue() == null) {
				new AnnounceFrame("Please first select sequences");
				return;} 
			else {performAnalysis(sequence1, sequence2, exportExcel);}				
		}
					
		@Override
		protected void initialize() {

			addEzComponent(sequence1);
			addEzComponent(sequence2);
			
			M1_label=new EzVarText("Manders Coefficient M1");
			M2_label=new EzVarText("Manders Coefficient M2");			
			M1S_label=new EzVarText("Manders Coefficient M1 (Surface)");
			M2S_label=new EzVarText("Manders Coefficient M2 (Surface)");
			
			EzGroup results = new EzGroup("Results",M1_label,M2_label,M1S_label,M2S_label);
			super.addEzComponent(results);			
			
			//statistical analysis
			P1_label=new EzVarText("p value (M1)");
			P2_label=new EzVarText("p value (M2)");
			P1S_label=new EzVarText("p value (M1 surface)");
			P2S_label=new EzVarText("p value (M2 surface)");			
			
			EzGroup stat = new EzGroup("Statistics",P1_label,P2_label,P1S_label,P2S_label);
			super.addEzComponent(stat);			
						
			addEzComponent(new EzGroup("Export", exportExcel, exportExcelFile));
			exportExcel.addVisibilityTriggerTo(exportExcelFile, true);		
		}

}				
