package plugins.jmutterer.plantSeg;

import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;
import icy.math.Histogram;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.rectangle.Rectangle5D;

import ij.gui.Plot;
import ij.process.ImageProcessor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import plugins.kernel.roi.roi2d.ROI2DArea;

@SuppressWarnings("serial")
public class ThresholdSlider extends JPanel implements ChangeListener {
	private JSlider slider;
	private Sequence HSBsequence;
	private Sequence sequence;
	private ROI2DArea r;
	private BufferedImage image;
	private JLabel histDisplayArea;
	private ArrayList<ROI> rois;
	private Color[] colors = {Color.RED,Color.GREEN,Color.BLUE,Color.ORANGE};

	public ThresholdSlider(Sequence sequence) {
		this.sequence = sequence;
		slider = new JSlider();
		slider.setMaximum(255);
		slider.addChangeListener(this);
		r = new ROI2DArea();

		this.HSBsequence = computeHSBseq(sequence);
		setLayout(new BorderLayout(0, 0));

		add(slider, BorderLayout.NORTH);

		JPanel buttonPanel = new JPanel();
		add(buttonPanel, BorderLayout.SOUTH);

		JButton measureBtn = new JButton("Measure Hues");
		measureBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				measureQuadrants();
			}
		});
		buttonPanel.add(measureBtn);

		image = new BufferedImage(321, 121, BufferedImage.TYPE_INT_RGB);
		Graphics g = image.getGraphics();
		g.setColor(Color.red);
		g.drawString("-Adjust Threshold slider", 10,20);
		g.drawString(" to highlight plantlets ", 10,35);
		g.drawString("-Then press measure button", 10,50);

		histDisplayArea = new JLabel("");
		histDisplayArea.setIcon(new ImageIcon(image));
		add(histDisplayArea, BorderLayout.CENTER);
		slider.setValue(128);
		slider.setValueIsAdjusting(true);
		slider.setValueIsAdjusting(false);
		
	}

	public int getSliderValue() {
		return slider.getValue();
	}

	@Override
	public void stateChanged(ChangeEvent arg0) {

		IcyBufferedImage hue = (IcyBufferedImage) HSBsequence.getFirstImage();
		int t = slider.getValue();

		float[] h = hue.getDataXYAsFloat(2);

		boolean[] mask = new boolean[h.length];
		for (int i = 0; i < h.length; i++)
			if (h[i] > t / 255.0d)
				mask[i] = true;

		r.setAsBooleanMask(0, 0, hue.getWidth(), hue.getHeight(), mask);
		r.setColor(Color.red);
		r.setOpacity(0.5f);
		r.setName("mask");
		r.setReadOnly(true);
		sequence.addROI(r);

		histDisplayArea.setIcon(new ImageIcon(image));
	}

	private void measureQuadrants() {
		System.out.println("-----------------------");
		System.out.println(sequence.getName());
		// ArrayList<ROI> rois = sequence.getROIs();
		Histogram[] hists = new Histogram[4];

		int processedRoi = 0;
		double overallMax = 0;
		for (ROI roi : rois) {
			ArrayList<ROI> twoRois = new ArrayList<ROI>();
			twoRois.add(roi);
			ROI2DArea mask = getMask();
			twoRois.add(mask);
			ROI intersect = ROIUtil.getIntersection(twoRois);
			HSBsequence.addROI(intersect);

			System.out.println("Segmented Area "
					+ ROIUtil.getArea(HSBsequence, intersect));

			double mean = ROIUtil.getMeanIntensity(HSBsequence, intersect, 0,
					0, 0);
			System.out.println(roi.getName() + ":" + mean);

			hists[processedRoi] = getRoiHistogram(HSBsequence, intersect, 0, 0,
					0);
			sequence.removeAllROI();
			int[] hcounts = hists[processedRoi].getBins();
			double[] counts = new double[256];
			for (int i = 0; i < hcounts.length; i++) {
				counts[i] = hcounts[i];
			}
			double processedRoiMax = ArrayMath.max(counts);
			if (overallMax < processedRoiMax)
				overallMax = processedRoiMax;
			processedRoi++;
		}
		Plot p = new Plot("Color analysis", "hue", "count");
		p.setFrameSize(320, 120);
		p.setLimits(0d, 80d, 0d, overallMax);

		double[] bins = new double[256];
		double[] counts = new double[256];
		for (int h = 0; h < hists.length; h++) {
			for (int i = 0; i < bins.length; i++) {
				bins[i] = i;
				counts[i] = hists[h].getBins()[i];
			}
			p.setColor(colors [h]);
			p.addPoints(bins, counts, Plot.LINE);
		}

		ImageProcessor ip = p.getProcessor();
		ip.setRoi(Plot.LEFT_MARGIN, Plot.TOP_MARGIN, 321, 121);
		ip = ip.crop();
		BufferedImage img = ip.getBufferedImage();
		setGraph(img);

		sequence.addROI(getMask());

	}

	public Sequence computeHSBseq(Sequence sequence) {
		float[] hsbvals = new float[3];
		double[] red = Array1DUtil.arrayToDoubleArray(sequence.getFirstImage()
				.getDataXY(0), sequence.isSignedDataType());
		double[] green = Array1DUtil.arrayToDoubleArray(sequence
				.getFirstImage().getDataXY(1), sequence.isSignedDataType());
		double[] blue = Array1DUtil.arrayToDoubleArray(sequence.getFirstImage()
				.getDataXY(2), sequence.isSignedDataType());
		float[] hue = new float[red.length];
		float[] sat = new float[red.length];
		float[] bri = new float[red.length];
		for (int i = 0; i < red.length; i++) {
			hsbvals = Color.RGBtoHSB((int) red[i], (int) green[i],
					(int) blue[i], null);
			hue[i] = hsbvals[0];
			sat[i] = hsbvals[1];
			bri[i] = hsbvals[2];
		}
		Sequence outSequence = new Sequence();
		IcyBufferedImage image = new IcyBufferedImage(sequence.getWidth(),
				sequence.getHeight(), 3, DataType.FLOAT);
		image.setDataXY(0, hue);
		image.setDataXY(1, sat);
		image.setDataXY(2, bri);
		outSequence.addImage(image);
		return outSequence;

	}

	public Sequence getHSBseq() {
		return HSBsequence;
	}

	public ROI2DArea getMask() {
		return r;
	}

	public void setGraph(BufferedImage img) {
		histDisplayArea.setIcon(new ImageIcon(img));
	}

	public void setRois(ArrayList<ROI> rois) {
		this.rois = rois;
	}

	private Histogram getRoiHistogram(Sequence seq, ROI roi, int z, int t, int c) {
		Rectangle5D bounds = roi.getBounds5D();
		double bx = bounds.getX();
		double by = bounds.getY();
		double width = bounds.getSizeX();
		double height = bounds.getSizeY();
		Histogram h = new Histogram(0, 1, 256, false);
		for (int x = (int) bx; x < (int) bx + width; x++) {
			for (int y = (int) by; y < (int) by + height; y++) {
				if (roi.contains(x, y, z, t, c))
					h.addValue((double) seq.getData(t, z, c, y, x));
			}
		}
		return h;
	}
}

// public void windowClosing(WindowEvent e) {
// sequence.removeAllROI();
// for (Overlay o: sequence.getOverlays()) sequence.removeOverlay(o);
//
// }

