package plugins.nchenouard.particletracking.MHTracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

import icy.plugin.abstract_.PluginActionable;

public class HeuristicBinaryOptimizerPlug extends PluginActionable{

	@Override
	public void run() {
		int numVar = 3;
		boolean[] initSolution = new boolean[numVar]; // x0 = {0, 0, 0}
		int[] weights = new int[]{1, 1, 1}; // objective function = x1 + x2 + x3
		int numConstr = 2;
		int [][] constrWeights = new int[numConstr][numVar];
		int[] constrBounds = new int[numConstr];
		// x1 + x3 <= 1
		constrWeights[0][0] = 1;
		constrWeights[0][2] = 1;
		constrBounds[0] = 1;
		// x2 + x3 <= 1
		constrWeights[1][1] = 1;
		constrWeights[1][2] = 1;
		constrBounds[1] = 1;
		int Q = 1; // depth of search
		
		boolean[] solution = heuristicSearch(initSolution, weights, constrWeights, constrBounds, Q);
		for (int i = 0; i < solution.length; i++)
		{
			System.out.print(solution[i]+" ");
		}
		System.out.println();
		
		double[] weightsD = new double[weights.length];
		for (int i = 0; i < weightsD.length; i++)
			weightsD[i] = weights[i]/3d;
		HeuristicBinaryOptimizer optimizer = new HeuristicBinaryOptimizer(Q, weightsD, constrWeights, constrBounds);
		solution = optimizer.heuristicSearch(initSolution);
		for (int i = 0; i < solution.length; i++)
		{
			System.out.print(solution[i]+" ");
		}
		System.out.println();
	}

	public boolean[] heuristicSearch(boolean[] initSolution, int[] weights, int[][] constrWeights, int[] constrBounds, int Q) {
		boolean[] z = initSolution.clone(); // best current solution
		int zScore = computeScore(z, weights);
		int[] zConstraintValues = computeConstraintValues(z, constrWeights);
		boolean[] zBooleanTrace = computeBooleanTrace(z, zConstraintValues, constrBounds);
		HashMap<Integer, Integer> traceBox = new HashMap<Integer, Integer>(100);
		
		ArrayList<boolean[]> interestingSolutions = new ArrayList<boolean[]>(100);
		interestingSolutions.add(z);
		while (!interestingSolutions.isEmpty())
		{
			boolean[] x = interestingSolutions.remove(0); //TODO use a specialized structure for FIFO
			ArrayList<boolean[]> adjacentSolutions = getAdjacentSolutions(x);
			for (boolean[] y:adjacentSolutions)
			{
				int[] yConstraintValues = computeConstraintValues(y, constrWeights);
				if (isFeasible(yConstraintValues, constrBounds) && computeScore(y, weights) > zScore)
				{
					z = y;
					zScore = computeScore(y, weights);
					zConstraintValues = yConstraintValues;
					zBooleanTrace = computeBooleanTrace(y, yConstraintValues, constrBounds);
					interestingSolutions.clear();
					interestingSolutions.add(y);
					traceBox.clear();
					break;
				}
				else
				{
					int yScore = computeScore(y, weights);
					if (isInteresting(yScore, y, yConstraintValues, z, zConstraintValues, zBooleanTrace, constrBounds, Q, traceBox))
					{
						interestingSolutions.add(y);
						boolean[] yBooleanTrace = computeBooleanTrace(y, yConstraintValues, constrBounds);
						int key = computeKey(yBooleanTrace);
						traceBox.put(key, yScore);
					}
				}
			}
		}
		return z;
	}

	private int[] computeConstraintValues(boolean[] z, int[][] constrWeights)
	{
		int[] c = new int[constrWeights.length];
		for (int i = 0; i < constrWeights.length; i++)
			for (int j = 0; j < z.length; j++)
				if (z[j])
					c[i] += constrWeights[i][j];
		return c;
	}

	private boolean isInteresting(int sScore, boolean[] s, int[] sConstraintValues, boolean[] z, int[] zConstraintValues, boolean[] zBooleanTrace, int[] constrBounds, int Q, HashMap<Integer, Integer> traceBox)
	{//TODO
		// A1: test whether a constraint is violated by more than one unit
		for (int i = 0; i < sConstraintValues.length; i++)
		{
			if (sConstraintValues[i] > constrBounds[i] + 1)
				return false;
		}
		
		// A2: the total amount of violation in y plus the number of different loose constraints (as compared to z) is at most Q
		//int[][] traceS = computeTrace(s, sConstraintValues, constrBounds);
		//int[][] traceZ = computeTrace(z, zConstraintValues, constrBounds);
//		int sumTrace = 0;
//		for (int i = 0; i < traceS.length; i++)
//			for (int j = 0; j < traceS[i].length; j++)
//				sumTrace += Math.abs(traceS[i][j] - traceZ[i][j]);
//		if (sumTrace > Q)
//			return false;
		// use booleans since by virtue of A1 interesting solutions have trace values in {0, 1}		
		boolean[] sBooleanTrace = computeBooleanTrace(s, sConstraintValues, constrBounds);
		int sumDiffTrace = 0;
		for (int i = 0; i < sBooleanTrace.length; i++)
			if (sBooleanTrace[i] != zBooleanTrace[i])
				sumDiffTrace++;
		if (sumDiffTrace > Q)
			return false;
		
		// A3: the score of this solution is better than other solutions already examined and having the same hash for the trace
		int key = computeKey(sBooleanTrace);
		Integer prevScore = traceBox.get(new Integer(key));
		if (prevScore != null)
		{
			if (prevScore.intValue() >= sScore)
				return false;
		}
		return true;
	}
	
	private boolean[] computeBooleanTrace(boolean[] s, int[] sConstraintValues, int[] constrBounds) {
		boolean[] trace = new boolean[constrBounds.length*2];
		for (int i = 0; i < sConstraintValues.length; i++)
		{
			if (sConstraintValues[i] > constrBounds[i])
				trace[i] = true;
			else if (sConstraintValues[i] < constrBounds[i])
				trace[i + constrBounds.length] = true;
		}
		return trace;
	}

	private int computeKey(boolean[] traceTab) {
		return Arrays.hashCode(traceTab);
	}

	// amount of constraint violation
	private int[] getV(boolean[] s, int[] sConstraintValues, int[] constrBounds)
	{
		int[] v = new int[constrBounds.length];
		for(int i = 0; i < constrBounds.length; i++)
		{
			if (sConstraintValues[i] > constrBounds[i])
				v[i] = sConstraintValues[i] - constrBounds[i];
		}
		return v;
	}
	
	// amount of constraints looseness
	private int[] getU(boolean[] s, int[] sConstraintValues, int[] constrBounds)
	{
		int[] v = new int[constrBounds.length];
		for(int i = 0; i < constrBounds.length; i++)
		{
			if (sConstraintValues[i] < constrBounds[i])
				v[i] = constrBounds[i] - sConstraintValues[i];
		}
		return v;
	}
	
	private int[] getW(boolean[] s, int[] sConstraintValues, int[] constrBounds)
	{
		int[] u = getU(s, sConstraintValues, constrBounds);
		for (int i = 0; i < u.length; i++)
			if (u[i] < 1)
				u[i] = 1;
		return u;
	}
	
	private int[][] computeTrace(boolean[] s, int[] sConstraintValues, int[] constrBounds)
	{
		int[][] trace = new int[2][];
		trace[0] = getV(s, sConstraintValues, constrBounds);
		trace[1] = getW(s, sConstraintValues, constrBounds);
		return trace;
	}
			
			
	private boolean isFeasible(int[] sConstraintValues, int[] constrBounds) {
		for (int i = 0; i < constrBounds.length; i++)
			if (sConstraintValues[i] > constrBounds[i])
				return false;
		return true;
	}

	private int computeScore(boolean[] solution, int[] weights) {
		int d = 0;
		for (int i = 0; i < solution.length; i++)
			if (solution[i])
				d += weights[i];
		return d;
	}

	private ArrayList<boolean[]> getAdjacentSolutions(boolean[] z) {
		ArrayList<boolean[]> adjacentList = new ArrayList<boolean[]>(z.length);
		for (int i = 0; i < z.length; i++)
		{
			boolean[] a = z.clone();
			a[i] = !a[i];
			adjacentList.add(a);
		}
		return adjacentList;
	}

}
