package plugins.nchenouard.particletracking;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.gui.TrackingMainPanel;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

public class MHTracking extends PluginActionable {

	IcyFrame mainFrame;
	TrackingMainPanel panelTracking;
	TrackManager trackManager = null;

	@Override
	public void run() {
		JPanel mainPanel = new JPanel();
		mainFrame = new IcyFrame("Multiple Hypothesis Spot Tracking", false, true, true, true);
		mainFrame.getContentPane().add(mainPanel);

		// tracking Panel creation
		panelTracking = new TrackingMainPanel();
		mainPanel.add(panelTracking);
		panelTracking.startTrackingButton.addActionListener( new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				startTracking();
			}
		});
		mainFrame.pack();
		mainFrame.addToMainDesktopPane();
		mainFrame.center();
		mainFrame.setVisible(true);
		mainFrame.requestFocus();
	}

	public void startTracking()
	{
		DetectionResult dr = panelTracking.getSelectedDetectionResult();
		if (dr == null)
		{
			new AnnounceFrame("Tracking requires to specify a set of detections. You can use the Spot Detector plugin to create some.", 10);
			return;
		}
		if (dr.getNumberOfDetection() < 1)
		{
			new AnnounceFrame("A non empty set of detections needs to be used");
			return;
		}
		HMMMHTracker tracker = null;
		try{
			int dim = 2;
			double volume = 256*256;
			if (dr.getSequence()!=null)
			{
				if (dr.getSequence().getSizeZ() > 1)
					dim = 3;
				volume = dr.getSequence().getSizeX()*dr.getSequence().getSizeY()*dr.getSequence().getSizeZ();
			}
			else
			{
				// check detections to see if they all have the same z coordinate
				double minX = Double.MAX_VALUE;
				double minY = Double.MAX_VALUE;
				double minZ = Double.MAX_VALUE;
				double maxX = Double.MIN_VALUE;
				double maxY = Double.MIN_VALUE;
				double maxZ = Double.MIN_VALUE;
				
				for (int t = dr.getFirstFrameTime(); t <= dr.getLastFrameTime(); t++)
				{
					for (Spot s:dr.getDetectionsAtT(t))
					{
						minX = Math.min(minX, s.mass_center.x);
						minY = Math.min(minY, s.mass_center.y);
						minZ = Math.min(minZ, s.mass_center.z);
						maxX = Math.max(maxX, s.mass_center.x);
						maxY = Math.max(maxY, s.mass_center.y);
						maxZ = Math.max(maxZ, s.mass_center.z);					
					}
				}
				if (maxZ>minZ)
				{
					dim = 3;
					volume = (maxX - minX +1)*(maxY - minY +1)*(minZ - maxZ +1);
				}
				else
				{
					dim = 2;
					volume = (maxX - minX +1)*(maxY - minY +1);
				}
			}
			tracker = panelTracking.buildTracker(dim, volume);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			return;
		}
		if (tracker != null)
		{
			for (int t = dr.getFirstFrameTime(); t <= dr.getLastFrameTime(); t++)
				tracker.track(t, dr.getDetectionsAtT(t));
			ArrayList<TrackSegment> tracks = tracker.getCompleteTracks();
			TrackGroup tg = new TrackGroup(dr.getSequence());
			tg.setDescription(panelTracking.getTrackGroupName());
			for (TrackSegment ts:tracks)
				tg.addTrackSegment(ts);
			sendTracksToPool(tg, tg.getSequence());
		}
	}

	private void sendTracksToPool(final TrackGroup trackGroup,
			final Sequence sequence) {
		SwingUtilities.invokeLater(new Runnable()
		{
			public void run() {
				// Add the given trackGroup
				SwimmingObject result = new SwimmingObject(trackGroup);// should
				Icy.getMainInterface().getSwimmingPool().add(result);
			}
		});
	}
}
