package plugins.adufour.roi.mesh;

import icy.file.FileUtil;
import icy.gui.dialog.OpenDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;

import java.io.File;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

import plugins.adufour.roi.mesh.polygon.ROI3DPolygonalMesh;

public class ROI3DMeshImporter extends PluginActionable
{
    @Override
    public void run()
    {
        Sequence sequence = getActiveSequence();
        
        if (sequence == null) throw new IcyHandledException("Open a sequence before importing a mesh file");
        
        String filePath = OpenDialog.chooseFile("Import mesh...", null);
        
        if (filePath == null) return;
        
        Tuple3d pixelSize = new Point3d(sequence.getPixelSizeX(), sequence.getPixelSizeY(), sequence.getPixelSizeZ());
        
        String extension = FileUtil.getFileExtension(filePath, false);
        File vtkFile = new File(filePath);
        
        ROI3DMesh<?> mesh;
        
        if (extension.equals("vtp") || extension.equals("vtk"))
        {
            // PolyData => polygonal mesh
            mesh = new ROI3DPolygonalMesh();
        }
        else
        {
            throw new UnsupportedOperationException("Cannot import " + filePath + " (unsupported file format)");
        }
        
        try
        {
            mesh.setPixelSize(pixelSize);
            mesh.loadFromVTK(vtkFile);
        }
        catch (UnsupportedOperationException e)
        {
            throw new IcyHandledException("Cannot import " + filePath + ":\nReason: " + e.getMessage());
        }
        
        sequence.addROI(mesh);
        new AnnounceFrame("The mesh was successfully imported!", 5);
    }
}
