package plugins.ylemontag.complex;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Object used to control and interrupt complex conversion computation
 */
public class Controller
{
	/**
	 * Exception thrown when a computation have been interrupted
	 */
	public static class CanceledByUser extends Exception
	{
		private static final long serialVersionUID = 1L;
	}
	
	private boolean _cancelFlag;
	
	/**
	 * Constructor
	 */
	public Controller()
	{
		_cancelFlag = false;
	}
	
	/**
	 * Method to call to ask the convert function to stop the computation before it finishes
	 * @warning Calling this method does not mean the computation will actually be interrupted.
	 *          The computation is interrupted if a CanceledByUser exception is thrown.
	 */
	public void cancelComputation()
	{
		_cancelFlag = true;
	}
	
	/**
	 * Check-point function called by the computation function
	 */
	void checkPoint() throws CanceledByUser
	{
		if(_cancelFlag) {
			throw new CanceledByUser();
		}
	}
}
