/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 *     Daniel Schmitter (daniel.schmitter@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnake.core;

import icy.gui.frame.IcyFrame;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

import plugins.big.bigsnake.rsc.ResourceUtil;
import plugins.big.bigsnake.rsc.icon.SnakeIcons;
import plugins.big.bigsnake.snake.ESnakeEnergyType;
import plugins.big.bigsnake.snake.ESnakePriorShapeType;
import plugins.big.bigsnake.snake.ESnakeTargetType;
import plugins.big.bigsnake.snake.ShapeSpaceType;

/**
 * Offers global parameters (settings) and functions used by the plug-in.
 * 
 * Settings makes use of the Singleton design pattern: There is at most one
 * instance present, which can only be accessed through
 * <code>getInstance()</code>.
 * 
 * @version May 24, 2015
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 * @author Daniel Schmitter (daniel.schmitter@epfl.ch)
 */
public class Settings {

	/** The unique instance of <code>Settings</code> (Singleton design pattern). */
	private static Settings instance_ = null;

	// ----------------------------------------------------------------------------
	// PLUG-IN INFO

	/** Name of the application. */
	private final String appName_ = "Active Cells";
	/** Version of the application. */
	private final String appVersion_ = "2.7";
	/** Minimal version of Icy required to run the plug-in. */
	private final String icyRequiredVersion_ = "1.6.1.1";

	// ----------------------------------------------------------------------------
	// DEFAULT PLUG-IN PARAMETERS

	/** Default value of the type of features to detect (bright or dark). */
	public static final ESnakeTargetType TARGET_TYPE_DEFAULT = ESnakeTargetType.DARK;
	/** Default value of the energy function of the snake. */
	public static final ESnakeEnergyType ENERGY_TYPE_DEFAULT = ESnakeEnergyType.REGION;
	/** Default value of the prior-shape information. */
	public static final ESnakePriorShapeType PRIOR_SHAPE_DEFAULT = ESnakePriorShapeType.NONE;
	/** Default value of shape space information. */
	public static final ShapeSpaceType SHAPE_SPACE_DEFAULT = ShapeSpaceType.SIMILARITY;
	/**
	 * Default maximum number of iterations allowed when the snake is not
	 * immortal.
	 */
	public static final int MAX_LIFE_DEFAULT = 500;
	/** Default number of spline vector coefficients. */
	public static final int M_DEFAULT = 3;
	/** Default energy tradeoff factor. */
	public static final double ALPHA_DEFAULT = 0;
	/** Default prior-shape energy tradeoff factor. */
	public static final double BETA_DEFAULT = 0;
	/**
	 * Default value of the immortal flag. If <code>true</code> indicates that
	 * the snake will keep iterating till the optimizer decides so.
	 */
	public static final boolean IMMORTAL_DEFAULT = false;

	// ----------------------------------------------------------------------------
	// OTHER

	/** Set to true to enable DEBUG mode */
	public static final boolean DEBUG = false;

	// ============================================================================
	// PUBLIC METHODS

	/** Get <code>Settings</code> instance */
	static public Settings getInstance() {
		if (instance_ == null) {
			instance_ = new Settings();
		}
		return instance_;
	}

	// ----------------------------------------------------------------------------

	/** Set the window icon. */
	public void setWindowIcon(JDialog dialog) {
		ResourceUtil resourceUtil = ResourceUtil.getInstance();
		try {
			List<Image> icons = new ArrayList<Image>();
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS16));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS24));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS32));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS48));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS64));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS128));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS256));
			dialog.setIconImages(icons);
		} catch (Exception e) {
			System.err.println("Failed to set the window icon.");
			e.printStackTrace();
		}
	}

	// ----------------------------------------------------------------------------

	/** Set the window icon. */
	public void setWindowIcon(IcyFrame icyFrame) {
		ResourceUtil resourceUtil = ResourceUtil.getInstance();
		try {
			List<Image> icons = new ArrayList<Image>();
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS16));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS24));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS32));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS48));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS64));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS128));
			icons.add(resourceUtil.getIcon(SnakeIcons.OUROBOROS256));
			JFrame externalFrame = icyFrame.getExternalFrame();
			externalFrame.setIconImages(icons);
			JInternalFrame internalFrame = icyFrame.getInternalFrame();
			internalFrame.setFrameIcon(new ImageIcon(resourceUtil
					.getIcon(SnakeIcons.OUROBOROS16)));
		} catch (Exception e) {
			System.err.println("Failed to set the window icon.");
			e.printStackTrace();
		}
	}

	// ============================================================================
	// SETTERS AND GETTERS

	/** Returns the name of the plug-in. */
	public String getAppName() {
		return appName_;
	}

	// ----------------------------------------------------------------------------

	/** Returns the version of the plug-in. */
	public String getAppVersion() {
		return appVersion_;
	}

	// ----------------------------------------------------------------------------

	/** Returns the minimum version of Icy in which the plug-in works properly. */
	public String getIcyRequiredVersion() {
		return icyRequiredVersion_;
	}
}