/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 ******************************************************************************/
package plugins.big.shapedesigner.rsc;

import icy.image.ImageUtil;

import java.awt.Image;

import plugins.big.shapedesigner.rsc.icon.ShapeDesignerIcons;

/**
 * Manager the interaction with the resourced embedded in the jar.
 * 
 * @version May 3, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class ResourceUtil {

	/** The unique instance of ResourceUtil (Singleton design pattern). */
	private static ResourceUtil instance_ = null;

	// ============================================================================
	// PUBLIC METHODS

	/** Get Settings instance */
	static public ResourceUtil getInstance() {
		if (instance_ == null) {
			instance_ = new ResourceUtil();
		}
		return instance_;
	}

	// ----------------------------------------------------------------------------

	/** Returns an image with the banner of the plug-in. */
	public Image getAboutBanner() {
		return ImageUtil.load(this.getClass().getResourceAsStream("about.png"));
	}

	// ----------------------------------------------------------------------------

	/** Returns an image the icon of the plug-in. */
	public Image getIcon(ShapeDesignerIcons icon) {
		switch (icon) {
		case ICON16:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/icon16.png"));
		case ICON24:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/icon24.png"));
		case ICON32:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/icon32.png"));
		case ICON48:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/icon48.png"));
		case ICON64:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/icon64.png"));
		case ICON128:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/icon128.png"));
		case ICON256:
			return ImageUtil.load(this.getClass().getResourceAsStream(
					"icon/icon256.png"));
		default:
			return null;
		}
	}
}
