/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 ******************************************************************************/
package plugins.big.shapedesigner.splinecurve;

import icy.util.XMLUtil;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Class that wraps the parameters of the spline curve.
 * 
 * @version May 3, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class SplineCurveParameters {

	/** Number of spline vector coefficients. */
	private int M_ = 0;

	// ----------------------------------------------------------------------------
	// XML TAG FIELDS

	/**
	 * Label of the XML tag containing the number of control points of the
	 * spline curve.
	 */
	public static final String ID_M = "M";

	// ============================================================================
	// PUBLIC METHODS

	/** Default constructor. */
	public SplineCurveParameters() {
	}

	// ----------------------------------------------------------------------------

	/** Constructor. */
	public SplineCurveParameters(int M) {
		setM(M);
	}

	// ----------------------------------------------------------------------------

	@Override
	public String toString() {
		return new String("[Spline shape parameters: " + ID_M + " " + M_ + "]");
	}

	// ----------------------------------------------------------------------------

	public void loadFromToXML(Node node) {
		setM(XMLUtil.getElementIntValue(node, ID_M, 3));
	}

	// ----------------------------------------------------------------------------

	public void saveToXML(Element node) {
		XMLUtil.setElementIntValue(node, SplineCurveParameters.ID_M, M_);
	}

	// ============================================================================
	// GETTERS AND SETTERS

	public int getM() {
		return M_;
	}

	// ----------------------------------------------------------------------------

	public void setM(int M) {
		M_ = M;
	}
}
