/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.icy.gui.pair;

/**
 * Abstract class describing a pair of numbers.
 * 
 * @version May 3, 2014
 * 
 * @author Julien Jacquemot
 */
public abstract class Pair {
	/** Returns the first element of the pair. */
	public abstract double getFirst();

	/** Returns the second element of the pair. */
	public abstract double getSecond();

	/** Set the first element of the pair. */
	public abstract void setFirst(double first);

	/** Set the second element of the pair. */
	public abstract void setSecond(double second);

	/** Set the values of the pair. */
	public void setPair(double first, double second) {
		setFirst(first);
		setSecond(second);
	}

	/** Set the values of the pair. */
	public void setPair(final Pair other) {
		setPair(other.getFirst(), other.getSecond());
	}

	@Override
	public boolean equals(Object o) {
		if (o instanceof Pair) {
			Pair other = (Pair) o;
			return getFirst() == other.getFirst()
					&& getSecond() == other.getSecond();
		}
		return false;
	}

	@Override
	public abstract Pair clone();

	/**
	 * Integer Pair (convenient class)
	 * 
	 * @version October 17, 2013
	 * @author Julien Jacquemot
	 * 
	 */
	public static class Integer extends Pair {
		public int first;
		public int second;

		public Integer() {
			this(0, 0);
		}

		public Integer(int first, int second) {
			this.first = first;
			this.second = second;
		}

		public Integer(Integer other) {
			this(other.first, other.second);
		}

		@Override
		public double getFirst() {
			return first;
		}

		@Override
		public double getSecond() {
			return second;
		}

		@Override
		public void setFirst(double first) {
			this.first = (int) first;
		}

		@Override
		public void setSecond(double second) {
			this.second = (int) second;
		}

		@Override
		public Pair clone() {
			return new Integer(this);
		}
	}

	/**
	 * Float Pair (convenient class)
	 * 
	 * @version October 17, 2013
	 * @author Julien Jacquemot
	 * 
	 */
	public static class Float extends Pair {
		public float first;
		public float second;

		public Float() {
			this(0, 0);
		}

		public Float(float first, float second) {
			this.first = first;
			this.second = second;
		}

		public Float(Float other) {
			this(other.first, other.second);
		}

		@Override
		public double getFirst() {
			return first;
		}

		@Override
		public double getSecond() {
			return second;
		}

		@Override
		public void setFirst(double first) {
			this.first = (float) first;
		}

		@Override
		public void setSecond(double second) {
			this.second = (float) second;
		}

		@Override
		public Pair clone() {
			return new Float(this);
		}
	}

	/**
	 * Double Pair (convenient class)
	 * 
	 * @version October 17, 2013
	 * @author Julien Jacquemot
	 * 
	 */
	public static class Double extends Pair {
		public double first;
		public double second;

		public Double() {
			this(0, 0);
		}

		public Double(double first, double second) {
			this.first = first;
			this.second = second;
		}

		public Double(Double other) {
			this(other.first, other.second);
		}

		@Override
		public double getFirst() {
			return first;
		}

		@Override
		public double getSecond() {
			return second;
		}

		@Override
		public void setFirst(double first) {
			this.first = first;
		}

		@Override
		public void setSecond(double second) {
			this.second = second;
		}

		@Override
		public Pair clone() {
			return new Double(this);
		}
	}
}
