/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 *     Daniel Schmitter (daniel.schmitter@epfl.ch)
 ******************************************************************************/

package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;

/**
 * Shape prior budding yeast.
 * 
 * @version December 14, 2014
 * 
 * @author Daniel Schmitter (daniel.schmitter@epfl.ch)
 */

public class BuddingYeast extends PriorShape {
	
	public BuddingYeast() {
		name_ = new String("Budding Yeast");
		minNumberNodes_ = 9;
		coef_ = new Snake2DNode[minNumberNodes_];
		coef_[0] = new Snake2DNode(369.4064527156191, 109.32067583497272);
		
		coef_[1] = new Snake2DNode(196.21254079690092, 340.77563416599156);
		
		coef_[2] = new Snake2DNode(319.57951219896756, 526.2567096696299);
		
		coef_[3] = new Snake2DNode(515.866843136302, 438.4744883604629);
		
		coef_[4] = new Snake2DNode(631.4238356445984, 524.0463434348566);
		
		coef_[5] = new Snake2DNode(779.4695048314256, 454.3516635561523);
		
		coef_[6] = new Snake2DNode(816.4989269523805, 283.6062555153785);
		
		coef_[7] = new Snake2DNode(679.3684110952871, 137.15450645224698);
		
		coef_[8] = new Snake2DNode(519.7120527210299, 202.17344392731985);
	}

}
