package plugins.ylemontag.sequencecomparator.blocks;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.BlockInfo;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.util.VarException;
import plugins.ylemontag.sequencecomparator.ComparatorPair;
import plugins.ylemontag.sequencecomparator.GlobalComparatorFactory;
import plugins.ylemontag.sequencecomparator.LocalComparatorFactory;
import plugins.ylemontag.sequencecomparator.ParameterProvider;
import plugins.ylemontag.sequencecomparator.comparators.GlobalPSNR;
import plugins.ylemontag.sequencecomparator.gui.SequenceComparator;
import plugins.ylemontag.ssim.SSIMCalculator;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Comparator pair input block
 */
public class ComparatorPairBlock extends Plugin implements Block, BlockInfo, PluginBundled
{
	private VarGlobalComparator _globalComparator = new VarGlobalComparator("Error measure mode", GlobalComparatorFactory.MSE);
	private VarLocalComparator  _localComparator  = new VarLocalComparator ("Error map mode"    , LocalComparatorFactory.ABS_DIFF);
	private VarDouble           _psnrDynamicRange = new VarDouble          ("PSNR dynamic range", GlobalPSNR.DEFAULT_DYNAMIC_RANGE);
	private Var<SSIMCalculator> _ssimCalculator   = new Var<SSIMCalculator>("SSIM calculator"   , SSIMCalculator.class, null);
	private Var<ComparatorPair> _out              = new Var<ComparatorPair>("Comparators"       , ComparatorPair.class, null);
	
	private BlockParameterProvider _parameterProvider = new BlockParameterProvider();
	
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add(_globalComparator);
		inputMap.add(_localComparator );
		inputMap.add(_psnrDynamicRange);
		inputMap.add(_ssimCalculator  );
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_out);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return SequenceComparator.class.getName();
	}
	
	@Override
	public String getName()
	{
		return "Comparators";
	}

	@Override
	public String getDescription()
	{
		return "Define the comparison metrics to use to compare two sequences";
	}

	@Override
	public void run()
	{
		// Input arguments
		GlobalComparatorFactory globalComparator = _globalComparator.getValue();
		LocalComparatorFactory  localComparator  = _localComparator .getValue();
		if(globalComparator==null) {
			throw new VarException("No error measure mode selected");
		}
		if(localComparator==null) {
			throw new VarException("No error map mode selected");
		}
		
		// Allocate the result
		ComparatorPair retVal = new ComparatorPair();
		retVal.global = globalComparator.createInstance(_parameterProvider);
		retVal.local  = localComparator .createInstance(_parameterProvider);
		_out.setValue(retVal);
	}
	
	/**
	 * Provide comparator parameters from input variables
	 */
	private class BlockParameterProvider implements ParameterProvider
	{
		@Override
		public double getPSNRDynamicRange()
		{
			double retVal = _psnrDynamicRange.getValue();
			if(retVal<=0) {
				throw new VarException("The PSNR dynamic range must be positive (>0).");
			}
			return retVal;
		}
		
		@Override
		public SSIMCalculator getSSIMCalculator()
		{
			SSIMCalculator retVal = _ssimCalculator.getValue();
			if(retVal==null) {
				throw new VarException(
					"You must provide a SSIM calculator in order to use the SSIM-related modes. " +
					"Please have a look to the SSIMCalculatorBlock."
				);
			}
			return retVal;
		}
	}
}
