package plugins.ylemontag.sequencecomparator.comparators;

import icy.sequence.Sequence;
import plugins.ylemontag.sequencecomparator.ErrorMeasure;

/**
 * 
 * @author Yoann Le Montagner
 * 
 */
public class GlobalPSNR extends GlobalSquaredErrorBased
{
	public static final double DEFAULT_DYNAMIC_RANGE = 255.0;
	
	private double _dynamicRange;
	
	/**
	 * Constructor
	 * @param distanceName Name of the distance
	 * @param dynamicRange Dynamic range of the data (255 for 8-bit images,
	 *        1 for double-valued images clamped between 0 and 1, etc)
	 */
	public GlobalPSNR(String distanceName, double dynamicRange)
	{
		super(distanceName);
		if(dynamicRange<=0) {
			throw new IllegalArgumentException("The parameter L (dynamic range) must be >0 .");
		}
		_dynamicRange = dynamicRange;
	}
	
	@Override
	protected void normalizeErrorMeasure(ErrorMeasure retVal, Sequence seq)
	{
		int sizeXY = seq.getSizeX() * seq.getSizeY();
		int sizeZ = seq.getSizeZ();
		int sizeT = seq.getSizeT();
		int sizeC = seq.getSizeC();
		retVal.errorAll = scalarNormalization(retVal.errorAll, sizeC*sizeT*sizeZ*sizeXY);
		arrayNormalization(retVal.errorZ, sizeC*sizeT*sizeXY);
		arrayNormalization(retVal.errorT, sizeC*sizeZ*sizeXY);
		arrayNormalization(retVal.errorC, sizeT*sizeZ*sizeXY);
	}
	
	/**
	 * Divide all the elements in the array by 'divisor', and take the square root
	 */
	private void arrayNormalization(double[] array, double divisor)
	{
		for(int k=0; k<array.length; ++k) {
			array[k] = scalarNormalization(array[k], divisor);
		}
	}
	
	/**
	 * Atomic normalization function
	 */
	private double scalarNormalization(double value, double divisor)
	{
		return 10.0 * Math.log10(_dynamicRange * _dynamicRange / (value / divisor));
	}
}
