package plugins.ylemontag.sequencecomparator.comparators;


/**
 * 
 * @author Yoann Le Montagner
 *
 * Error map generator for distances for which the error at a given pixel
 * depends only on the value of the 2 compared sequences at this pixel
 */
public abstract class PixelSeparableLocalComparator extends PlaneSeparableLocalComparator
{
	/**
	 * Constructor
	 */
	public PixelSeparableLocalComparator(String distanceName)
	{
		super(distanceName);
	}
	
	/**
	 * Function to override to compute the error at a given point
	 */
	protected abstract double computePixelError(double refPixel, double seqPixel);
	
	@Override
	protected void computePlaneError(int sizeX, int sizeY, double[] refPlane, double[] seqPlane, double[] outPlane)
	{
		int sizeXY = sizeX*sizeY;
		for(int xy=0; xy<sizeXY; ++xy) {
			outPlane[xy] = computePixelError(refPlane[xy], seqPlane[xy]);
		}
	}
}
