package plugins.tprovoost.chronometer;

import java.awt.Component;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class InfinitePanel extends JPanel {

	private ArrayList<JPanel> _list_panels = new ArrayList<JPanel>();
	
	/**
	 * Generated serialVersionUID.
	 */
	private static final long serialVersionUID = 3730416047480042752L;
		
	public InfinitePanel() {
		super();		
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
	}
	
	public void setLayout(int orientation) {
		setLayout(new BoxLayout(this, orientation));
		revalidate();
		repaint();
	}
	
	public void addPanel(JPanel panel) {
		_list_panels.add(panel);
		add(panel);
		validate();
		repaint();
	}
	
	public void removeLastPanel() {
		_list_panels.remove(_list_panels.size()-1);
		remove(getComponentCount()-1);
		validate();
		repaint();
	}
	
	public void removePanel(Component p) {
		_list_panels.remove(p);
		remove(p);
		validate();
		repaint();
	}
	
	public void removePanel(int i) {
		_list_panels.remove(i);
		remove(i);
		validate();
		repaint();
	}
	
	public JPanel getPanelAt(int i) {
		return _list_panels.get(i);
	}

	public ArrayList<JPanel> getPanels() {
		return _list_panels;
	}
}
