/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.NewImage;
import ij.plugin.CanvasResizer;
import ij.plugin.Resizer;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom.IntCoord3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;
import mcib3d.geom.Voxel3DComparable;
import mcib3d.image3d.BlankMask;
import mcib3d.image3d.Coordinate3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.ImageStats;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.Chrono;
import mcib3d.utils.Logger.AbstractLog;
import mcib3d.utils.ThreadUtil;

public class ImageFloat
extends ImageHandler {
    public float[][] pixels;

    public ImageFloat(ImagePlus img) {
        super(img);
        this.buildPixels();
    }

    public ImageFloat(ImageStack img) {
        super(img);
        this.buildPixels();
    }

    public ImageFloat(float[][] pixels, String title, int sizeX) {
        super(title, sizeX, pixels[0].length / sizeX, pixels.length, 0, 0, 0);
        this.pixels = pixels;
        ImageStack st = new ImageStack(sizeX, this.sizeY, this.sizeZ);
        for (int z = 0; z < this.sizeZ; ++z) {
            st.setPixels((Object)pixels[z], z + 1);
        }
        this.img = new ImagePlus(title, st);
    }

    public ImageFloat(String title, int sizeX, int sizeY, int sizeZ) {
        super(title, sizeX, sizeY, sizeZ);
        this.img = NewImage.createFloatImage((String)title, (int)sizeX, (int)sizeY, (int)sizeZ, (int)1);
        this.pixels = new float[sizeZ][];
        for (int i = 0; i < sizeZ; ++i) {
            this.pixels[i] = (float[])this.img.getImageStack().getPixels(i + 1);
        }
    }

    public ImageFloat(ImageHandler im) {
        super(im.title, im.sizeX, im.sizeY, im.sizeZ, im.offsetX, im.offsetY, im.offsetZ);
        ImageStats s = this.getImageStats(null);
        if (im instanceof ImageShort) {
            if (im.img != null) {
                ImageFloat f = ((ImageShort)im).convertToFloat(false);
                this.pixels = f.pixels;
                this.img = f.img;
                s.setMinAndMax(this.img.getProcessor().getMin(), this.img.getProcessor().getMax());
            }
        } else if (im instanceof ImageByte) {
            if (im.img != null) {
                ImageFloat f = ((ImageByte)im).convertToFloat(false);
                this.pixels = f.pixels;
                this.img = f.img;
                s.setMinAndMax(this.img.getProcessor().getMin(), this.img.getProcessor().getMax());
            }
        } else {
            this.img = im.img;
            this.pixels = ((ImageFloat)im).pixels;
        }
    }

    public ImageFloat(float[][] matrix) {
        super("matrix", matrix[0].length, matrix.length, 1);
        this.img = NewImage.createFloatImage((String)this.title, (int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)1);
        this.pixels = new float[1][];
        this.pixels[0] = (float[])this.img.getImageStack().getPixels(1);
        int offset = 0;
        for (float[] f : matrix) {
            System.arraycopy(f, 0, this.pixels[0], offset, f.length);
            offset += this.sizeX;
        }
    }

    public static ImageFloat newBlankImageFloat(String title, ImageHandler ih) {
        ImageFloat res = new ImageFloat(title, ih.sizeX, ih.sizeY, ih.sizeZ);
        res.setScale(ih);
        res.setOffset(ih);
        return res;
    }

    public static float[] getArray1DFloat(ImagePlus img) {
        float[] res = new float[img.getNSlices() * img.getWidth() * img.getHeight()];
        int offZ = 0;
        int sizeXY = img.getWidth() * img.getHeight();
        for (int slice = 0; slice < img.getNSlices(); ++slice) {
            System.arraycopy((float[])img.getImageStack().getPixels(slice + 1), 0, res, offZ, sizeXY);
            offZ += sizeXY;
        }
        return res;
    }

    public static ImagePlus getImagePlus(float[] pixels, int sizeX, int sizeY, int sizeZ, boolean setMinAndMax) {
        if (pixels == null) {
            return null;
        }
        ImagePlus res = NewImage.createFloatImage((String)"", (int)sizeX, (int)sizeY, (int)sizeZ, (int)1);
        int offZ = 0;
        int sizeXY = sizeX * sizeY;
        for (int z = 0; z < sizeZ; ++z) {
            System.arraycopy(pixels, offZ, (float[])res.getImageStack().getPixels(z + 1), 0, sizeXY);
            offZ += sizeXY;
        }
        if (setMinAndMax) {
            float max = 0.0f;
            float min = 0.0f;
            for (float pixel : pixels) {
                if (pixel > max) {
                    max = pixel;
                }
                if (!(pixel < min)) continue;
                min = pixel;
            }
            res.getProcessor().setMinAndMax((double)min, (double)max);
        }
        return res;
    }

    public static ImagePlus getImagePlus(int[] pixels, int sizeX, int sizeY, int sizeZ, boolean setMinAndMax) {
        if (pixels == null) {
            return null;
        }
        ImagePlus res = NewImage.createFloatImage((String)"", (int)sizeX, (int)sizeY, (int)sizeZ, (int)1);
        int offZ = 0;
        int sizeXY = sizeX * sizeY;
        for (int z = 0; z < sizeZ; ++z) {
            float[] output = (float[])res.getImageStack().getPixels(z + 1);
            for (int i = 0; i < sizeXY; ++i) {
                output[i] = pixels[offZ + i];
            }
            offZ += sizeXY;
        }
        if (setMinAndMax) {
            float max = 0.0f;
            float min = 0.0f;
            for (int pixel : pixels) {
                if ((float)pixel > max) {
                    max = pixel;
                }
                if (!((float)pixel < min)) continue;
                min = pixel;
            }
            res.getProcessor().setMinAndMax((double)min, (double)max);
        }
        return res;
    }

    public static float[] convert(short[] input) {
        float[] res = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            res[i] = (float)input[i] + 0.5f;
        }
        return res;
    }

    public static float[] convert(byte[] input) {
        float[] res = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            res[i] = input[i];
        }
        return res;
    }

    private void buildPixels() {
        this.pixels = new float[this.sizeZ][];
        if (this.img.getImageStack() != null) {
            for (int i = 0; i < this.sizeZ; ++i) {
                this.pixels[i] = (float[])this.img.getImageStack().getPixels(i + 1);
            }
        } else {
            ImageStack st = new ImageStack(this.sizeX, this.sizeY);
            st.addSlice(this.img.getProcessor());
            this.pixels[0] = (float[])this.img.getProcessor().getPixels();
            this.img.setStack(null, st);
        }
    }

    @Override
    public Object getArray1D() {
        float[] res = new float[this.sizeXYZ];
        int offZ = 0;
        for (int slice = 0; slice < this.img.getNSlices(); ++slice) {
            System.arraycopy((float[])this.img.getImageStack().getPixels(slice + 1), 0, res, offZ, this.sizeXY);
            offZ += this.sizeXY;
        }
        return res;
    }

    @Override
    public Object getArray1D(int z) {
        float[] res = new float[this.sizeXY];
        System.arraycopy((float[])this.img.getImageStack().getPixels(z + 1), 0, res, 0, this.sizeXY);
        return res;
    }

    public ImageShort convertToShort(boolean scaling) {
        if (scaling) {
            this.setMinAndMax(null);
        }
        ImageStats s = this.getImageStats(null);
        int currentSlice = this.img.getCurrentSlice();
        ImageStack stack2 = new ImageStack(this.sizeX, this.sizeY);
        ImageStack stack1 = this.img.getImageStack();
        for (int i = 1; i <= this.sizeZ; ++i) {
            String label = stack1.getSliceLabel(i);
            ImageProcessor ip = stack1.getProcessor(i);
            if (scaling) {
                ip.setMinAndMax(s.getMin(), s.getMax());
            }
            stack2.addSlice(label, ip.convertToShort(scaling));
        }
        ImagePlus imp2 = new ImagePlus(this.img.getTitle(), stack2);
        imp2.setCalibration(this.img.getCalibration());
        imp2.setSlice(currentSlice);
        return (ImageShort)ImageHandler.wrap(imp2);
    }

    public ImageByte convertToByte(boolean scaling) {
        this.getMinAndMax(null);
        ImageStats s = this.getImageStats(null);
        ImageByte res = new ImageByte(this.title, this.sizeX, this.sizeY, this.sizeZ);
        if (scaling) {
            double coeff = 255.0 / (s.getMax() - s.getMin());
            double min = s.getMin();
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    int value = (int)(((double)this.pixels[z][xy] - min) * coeff + 0.5);
                    if (value < 0 || value > 255) {
                        System.out.println(this.pixels[z][xy] + " to " + value);
                    }
                    res.pixels[z][xy] = (byte)(((double)this.pixels[z][xy] - min) * coeff + 0.5);
                }
            }
            res.setMinAndMax(0.0f, 255.0f);
        } else {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    res.pixels[z][xy] = (byte)this.pixels[z][xy];
                }
            }
        }
        res.setScale(this);
        res.setOffset(this);
        return res;
    }

    @Override
    public void erase() {
        for (int xy = 0; xy < this.sizeXY; ++xy) {
            this.pixels[0][xy] = 0.0f;
        }
        for (int z = 1; z < this.sizeZ; ++z) {
            System.arraycopy(this.pixels[0], 0, this.pixels[z], 0, this.sizeXY);
        }
    }

    @Override
    public void fill(double value, int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max >= this.sizeZ) {
            max = this.sizeZ - 1;
        }
        for (int xy = 0; xy < this.sizeXY; ++xy) {
            this.pixels[min][xy] = (float)value;
        }
        for (int z = min + 1; z <= max; ++z) {
            System.arraycopy(this.pixels[min], 0, this.pixels[z], 0, this.sizeXY);
        }
    }

    @Override
    public ImageFloat duplicate() {
        ImageFloat res = new ImageFloat(this.img.duplicate());
        res.offsetX = this.offsetX;
        res.offsetY = this.offsetY;
        res.offsetZ = this.offsetZ;
        if (this.title != null) {
            res.title = this.title;
        }
        return res;
    }

    public void copy(ImageFloat destination) {
        for (int z = 0; z < this.sizeZ; ++z) {
            System.arraycopy(this.pixels[z], 0, destination.pixels[z], 0, this.sizeXY);
        }
    }

    @Override
    public float getPixel(int coord) {
        return this.pixels[coord / this.sizeXY][coord % this.sizeXY];
    }

    public float getPixel(IntCoord3D vox) {
        return this.pixels[vox.z][vox.x + vox.y * this.sizeX];
    }

    public float getPixel(Coordinate3D coord) {
        return this.pixels[coord.z][coord.x + coord.y * this.sizeX];
    }

    @Override
    public float getPixel(int x, int y, int z) {
        return this.pixels[z][x + y * this.sizeX];
    }

    @Override
    public float getPixel(int xy, int z) {
        return this.pixels[z][xy];
    }

    @Override
    public void setPixel(int coord, float value) {
        this.pixels[coord / this.sizeXY][coord % this.sizeXY] = value;
    }

    @Override
    public void setPixel(Point3D point, float value) {
        this.pixels[point.getRoundZ()][point.getRoundX() + point.getRoundY() * this.sizeX] = value;
    }

    @Override
    public void setPixel(int x, int y, int z, float value) {
        this.pixels[z][x + y * this.sizeX] = value;
    }

    @Override
    public void setPixel(int xy, int z, float value) {
        this.pixels[z][xy] = value;
    }

    @Override
    protected synchronized void getMinAndMax(ImageInt mask) {
        ImageStats s = this.getImageStats(mask);
        if (s.minAndMaxSet()) {
            return;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        if (mask == null) {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    if ((double)this.pixels[z][xy] > max) {
                        max = this.pixels[z][xy];
                    }
                    if (!((double)this.pixels[z][xy] < min)) continue;
                    min = this.pixels[z][xy];
                }
            }
        } else {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    if (mask.getPixel(xy, z) == 0.0f) continue;
                    if ((double)this.pixels[z][xy] > max) {
                        max = this.pixels[z][xy];
                    }
                    if (!((double)this.pixels[z][xy] < min)) continue;
                    min = this.pixels[z][xy];
                }
            }
        }
        s.setMinAndMax(min, max);
    }

    @Override
    protected int[] getHisto(ImageInt mask) {
        if (mask == null) {
            mask = new BlankMask(this);
        }
        this.getMinAndMax(mask);
        ImageStats s = this.getImageStats(mask);
        double coeff = 256.0 / (s.getMax() - s.getMin());
        double min = s.getMin();
        int[] histo = new int[256];
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) == 0.0f) continue;
                int idx = (int)(((double)this.pixels[z][xy] - min) * coeff);
                if (idx >= 256) {
                    histo[255] = histo[255] + 1;
                    continue;
                }
                int n = idx;
                histo[n] = histo[n] + 1;
            }
        }
        s.setHisto256(histo, 1.0 / coeff);
        return histo;
    }

    @Override
    protected int[] getHisto(ImageInt mask, int nBins, double min, double max) {
        if (mask == null) {
            mask = new BlankMask(this);
        }
        double coeff = (double)nBins / (max - min + 1.0);
        int[] hist = new int[nBins];
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) == 0.0f) continue;
                int idx = (int)(((double)this.pixels[z][xy] - min) * coeff);
                if (idx >= nBins) {
                    int n = nBins - 1;
                    hist[n] = hist[n] + 1;
                    continue;
                }
                int n = idx;
                hist[n] = hist[n] + 1;
            }
        }
        return hist;
    }

    @Override
    public void draw(Object3D o, float value) {
        Object3DVoxels ov = !(o instanceof Object3DVoxels) ? o.getObject3DVoxels() : (Object3DVoxels)o;
        for (Voxel3D v : ov.getVoxels()) {
            this.pixels[v.getRoundZ()][v.getRoundX() + v.getRoundY() * this.sizeX] = value;
        }
    }

    @Override
    public ImageByte thresholdRangeInclusive(float min, float max) {
        ImageByte res = new ImageByte(this.title + "thld", this.sizeX, this.sizeY, this.sizeZ);
        res.offsetX = this.offsetX;
        res.offsetY = this.offsetY;
        res.offsetZ = this.offsetZ;
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (!(this.pixels[z][xy] >= min) || !(this.pixels[z][xy] <= max)) continue;
                res.pixels[z][xy] = -1;
            }
        }
        return res;
    }

    @Override
    public ImageByte thresholdRangeExclusive(float min, float max) {
        ImageByte res = new ImageByte(this.title + "thld", this.sizeX, this.sizeY, this.sizeZ);
        res.offsetX = this.offsetX;
        res.offsetY = this.offsetY;
        res.offsetZ = this.offsetZ;
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (!(this.pixels[z][xy] > min) || !(this.pixels[z][xy] < max)) continue;
                res.pixels[z][xy] = -1;
            }
        }
        return res;
    }

    @Override
    public ImageByte threshold(float thld, boolean keepUnderThld, boolean strict) {
        ImageByte res;
        block9: {
            block11: {
                block10: {
                    block8: {
                        res = new ImageByte(this.title + "thld", this.sizeX, this.sizeY, this.sizeZ);
                        res.offsetX = this.offsetX;
                        res.offsetY = this.offsetY;
                        res.offsetZ = this.offsetZ;
                        if (keepUnderThld || strict) break block8;
                        for (int z = 0; z < this.sizeZ; ++z) {
                            for (int xy = 0; xy < this.sizeXY; ++xy) {
                                if (!(this.pixels[z][xy] >= thld)) continue;
                                res.pixels[z][xy] = -1;
                            }
                        }
                        break block9;
                    }
                    if (keepUnderThld || !strict) break block10;
                    for (int z = 0; z < this.sizeZ; ++z) {
                        for (int xy = 0; xy < this.sizeXY; ++xy) {
                            if (!(this.pixels[z][xy] > thld)) continue;
                            res.pixels[z][xy] = -1;
                        }
                    }
                    break block9;
                }
                if (!keepUnderThld || strict) break block11;
                for (int z = 0; z < this.sizeZ; ++z) {
                    for (int xy = 0; xy < this.sizeXY; ++xy) {
                        if (!(this.pixels[z][xy] <= thld)) continue;
                        res.pixels[z][xy] = -1;
                    }
                }
                break block9;
            }
            if (!keepUnderThld || !strict) break block9;
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    if (!(this.pixels[z][xy] < thld)) continue;
                    res.pixels[z][xy] = -1;
                }
            }
        }
        return res;
    }

    @Override
    public void thresholdCut(float thld, boolean keepUnderThld, boolean strict) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (keepUnderThld || strict) break block8;
                        for (int z = 0; z < this.sizeZ; ++z) {
                            for (int xy = 0; xy < this.sizeXY; ++xy) {
                                if (!(this.pixels[z][xy] < thld)) continue;
                                this.pixels[z][xy] = 0.0f;
                            }
                        }
                        break block9;
                    }
                    if (keepUnderThld || !strict) break block10;
                    for (int z = 0; z < this.sizeZ; ++z) {
                        for (int xy = 0; xy < this.sizeXY; ++xy) {
                            if (!(this.pixels[z][xy] <= thld)) continue;
                            this.pixels[z][xy] = 0.0f;
                        }
                    }
                    break block9;
                }
                if (!keepUnderThld || strict) break block11;
                for (int z = 0; z < this.sizeZ; ++z) {
                    for (int xy = 0; xy < this.sizeXY; ++xy) {
                        if (!(this.pixels[z][xy] > thld)) continue;
                        this.pixels[z][xy] = 0.0f;
                    }
                }
                break block9;
            }
            if (!keepUnderThld || !strict) break block9;
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    if (!(this.pixels[z][xy] >= thld)) continue;
                    this.pixels[z][xy] = 0.0f;
                }
            }
        }
    }

    @Override
    public ImageFloat crop3D(String title, int x_min_, int x_max_, int y_min_, int y_max_, int z_min_, int z_max_) {
        int x_min = x_min_;
        int z_min = z_min_;
        int y_min = y_min_;
        int x_max = x_max_;
        int y_max = y_max_;
        int z_max = z_max_;
        int sX = x_max - x_min + 1;
        int sY = y_max - y_min + 1;
        int sZ = z_max - z_min + 1;
        ImageFloat res = new ImageFloat(title, sX, sY, sZ);
        res.offsetX = x_min;
        res.offsetY = y_min;
        res.offsetZ = z_min;
        res.setScale(this);
        int oZ = -z_min;
        int oY_i = 0;
        int oX = 0;
        if (x_min <= -1) {
            x_min = 0;
        }
        if (x_max >= this.sizeX) {
            x_max = this.sizeX - 1;
        }
        if (y_min <= -1) {
            oY_i = -sX * y_min;
            y_min = 0;
        }
        if (y_max >= this.sizeY) {
            y_max = this.sizeY - 1;
        }
        if (z_min <= -1) {
            z_min = 0;
        }
        if (z_max >= this.sizeZ) {
            z_max = this.sizeZ - 1;
        }
        int sXo = x_max - x_min + 1;
        for (int z = z_min; z <= z_max; ++z) {
            int offY = y_min * this.sizeX;
            int oY = oY_i;
            for (int y = y_min; y <= y_max; ++y) {
                System.arraycopy(this.pixels[z], offY + x_min, res.pixels[z + oZ], oY + oX, sXo);
                oY += sX;
                offY += this.sizeX;
            }
        }
        return res;
    }

    public ImageFloat[] crop3D(TreeMap<Integer, int[]> bounds) {
        ImageFloat[] ihs = new ImageFloat[bounds.size()];
        ArrayList<Integer> keys = new ArrayList<Integer>(bounds.keySet());
        for (int idx = 0; idx < ihs.length; ++idx) {
            int label = keys.get(idx);
            int[] bds = bounds.get(label);
            ihs[idx] = this.crop3D(this.title + ":" + label, bds[0], bds[1], bds[2], bds[3], bds[4], bds[5]);
        }
        return ihs;
    }

    @Override
    public ImageFloat crop3DMask(String title, ImageInt mask, int label, int x_min_, int x_max_, int y_min_, int y_max_, int z_min_, int z_max_) {
        ImageFloat res;
        block13: {
            int oY_i;
            int sX;
            int z_max;
            int y_max;
            int x_max;
            int y_min;
            block12: {
                int x_min = x_min_;
                int z_min = z_min_;
                y_min = y_min_;
                x_max = x_max_;
                y_max = y_max_;
                z_max = z_max_;
                sX = x_max - x_min + 1;
                int sY = y_max - y_min + 1;
                int sZ = z_max - z_min + 1;
                res = new ImageFloat(title, sX, sY, sZ);
                res.offsetX = x_min;
                res.offsetY = y_min;
                res.offsetZ = z_min;
                res.setScale(this);
                int oZ = -z_min;
                oY_i = 0;
                int oX = -x_min;
                if (x_min <= -1) {
                    x_min = 0;
                }
                if (x_max >= this.sizeX) {
                    x_max = this.sizeX - 1;
                }
                if (y_min <= -1) {
                    oY_i = -sX * y_min;
                    y_min = 0;
                }
                if (y_max >= this.sizeY) {
                    y_max = this.sizeY - 1;
                }
                if (z_min <= -1) {
                    z_min = 0;
                }
                if (z_max >= this.sizeZ) {
                    z_max = this.sizeZ - 1;
                }
                if (!(mask instanceof ImageShort)) break block12;
                ImageShort m = (ImageShort)mask;
                for (int z = z_min; z <= z_max; ++z) {
                    int offY = y_min * this.sizeX;
                    int oY = oY_i;
                    for (int y = y_min; y <= y_max; ++y) {
                        for (int x = x_min; x <= x_max; ++x) {
                            if ((m.pixels[z][offY + x] & 0xFFFF) != label) continue;
                            res.pixels[z + oZ][oY + x + oX] = this.pixels[z][offY + x];
                        }
                        oY += sX;
                        offY += this.sizeX;
                    }
                }
                break block13;
            }
            if (!(mask instanceof ImageByte)) break block13;
            ImageByte m = (ImageByte)mask;
            for (int z = z_min; z <= z_max; ++z) {
                int offY = y_min * this.sizeX;
                int oY = oY_i;
                for (int y = y_min; y <= y_max; ++y) {
                    for (int x = x_min; x <= x_max; ++x) {
                        if ((m.pixels[z][offY + x] & 0xFF) != label) continue;
                        res.pixels[z + oZ][oY + x + oX] = this.pixels[z][offY + x];
                    }
                    oY += sX;
                    offY += this.sizeX;
                }
            }
        }
        return res;
    }

    @Override
    public ImageHandler resize(int dX, int dY, int dZ) {
        int i;
        int newX = Math.max(1, this.sizeX + 2 * dX);
        int newY = Math.max(1, this.sizeY + 2 * dY);
        boolean bck = Prefs.get((String)"resizer.zero", (boolean)true);
        Prefs.set((String)"resizer.zero", (boolean)true);
        CanvasResizer cr = new CanvasResizer();
        ImageStack res = cr.expandStack(this.img.getStack(), newX, newY, dX, dY);
        if (!bck) {
            // empty if block
        }
        if (dZ > 0) {
            for (i = 0; i < dZ; ++i) {
                res.addSlice("", (ImageProcessor)new FloatProcessor(newX, newY), 0);
                res.addSlice("", (ImageProcessor)new FloatProcessor(newX, newY));
            }
        } else {
            for (i = 0; i < -dZ && res.getSize() > 2; ++i) {
                res.deleteLastSlice();
                res.deleteSlice(1);
            }
        }
        ImageFloat r = new ImageFloat(new ImagePlus(this.title + "::resized", res));
        r.offsetX = this.offsetX - dX;
        r.offsetY = this.offsetY - dY;
        r.offsetZ = this.offsetZ - dZ;
        return r;
    }

    @Override
    public ImageHandler resample(int newX, int newY, int newZ, int method) {
        ImagePlus ip;
        if (method == -1) {
            method = 2;
        }
        if (newX == this.sizeX && newY == this.sizeY && newZ == this.sizeZ || newX == 0 && newY == 0 && newZ == 0) {
            return new ImageFloat(this.img.duplicate());
        }
        if (newX != 0 && newY != 0 && newX != this.sizeX && newY != this.sizeY) {
            StackProcessor sp = new StackProcessor(this.img.getImageStack(), this.img.getProcessor());
            ip = new ImagePlus(this.title + "::resampled", sp.resize(newX, newY, true));
        } else {
            ip = this.img;
        }
        if (newZ != 0 && newZ != this.sizeZ) {
            Resizer r = new Resizer();
            ip = r.zScale(ip, newZ, method);
        }
        return new ImageFloat(ip);
    }

    @Override
    public ImageHandler resample(int newZ, int method) {
        if (method == -1) {
            method = 2;
        }
        Resizer r = new Resizer();
        return new ImageFloat(r.zScale(this.img, newZ, method));
    }

    @Override
    protected ImageFloat normalize_(ImageInt mask, double saturation) {
        this.getMinAndMax(mask);
        ImageStats s = this.getImageStats(mask);
        double max_ = s.getMax();
        if (saturation > 0.0 && saturation < 1.0) {
            max_ = this.getPercentile(saturation, mask);
        }
        if (max_ <= s.getMin()) {
            max_ = s.getMin();
        }
        double scale = 1.0 / (max_ - s.getMin());
        double offset = -s.getMin() * scale;
        ImageFloat res = new ImageFloat(this.title + "::normalized", this.sizeX, this.sizeY, this.sizeZ);
        if (saturation > 0.0 && saturation < 1.0) {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    res.pixels[z][xy] = (float)((double)this.pixels[z][xy] >= max_ ? 1.0 : (double)this.pixels[z][xy] * scale + offset);
                }
            }
        } else {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int xy = 0; xy < this.sizeXY; ++xy) {
                    res.pixels[z][xy] = (float)((double)this.pixels[z][xy] * scale + offset);
                }
            }
        }
        return res;
    }

    @Override
    public ImageFloat normalize(double min, double max) {
        double scale = 1.0 / (max - min);
        double offset = -min * scale;
        ImageFloat res = new ImageFloat(this.title + "::normalized", this.sizeX, this.sizeY, this.sizeZ);
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                res.pixels[z][xy] = (double)this.pixels[z][xy] >= max ? 1.0f : ((double)this.pixels[z][xy] <= min ? 0.0f : (float)((double)this.pixels[z][xy] * scale + offset));
            }
        }
        return res;
    }

    @Override
    public void intersectMask(ImageInt mask) {
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) != 0.0f) continue;
                this.pixels[z][xy] = 0.0f;
            }
        }
    }

    @Override
    public void intersectMask2D(ImageInt mask, int z) {
        for (int xy = 0; xy < this.sizeXY; ++xy) {
            if (mask.getPixel(xy, 0) != 0.0f) continue;
            this.pixels[z][xy] = 0.0f;
        }
    }

    public void intersectMask(ImageFloat mask) {
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) != 0.0f) continue;
                this.pixels[z][xy] = 0.0f;
            }
        }
    }

    @Override
    public void invert(ImageInt mask) {
        this.getMinAndMax(mask);
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                this.pixels[z][xy] = -this.pixels[z][xy];
            }
        }
    }

    public void opposite() {
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                this.pixels[z][xy] = -this.pixels[z][xy];
            }
        }
    }

    public void subtract(ImageFloat other) {
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                float[] fArray = this.pixels[z];
                int n = xy;
                fArray[n] = fArray[n] - other.pixels[z][xy];
            }
        }
    }

    @Override
    protected void flushPixels() {
        if (this.pixels != null) {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = null;
            }
            this.pixels = null;
        }
    }

    @Override
    public boolean isOpened() {
        return this.pixels != null && this.img != null && this.img.getProcessor() != null;
    }

    @Override
    public float getPixel(Point3D P) {
        return this.pixels[P.getRoundZ()][P.getRoundX() + P.getRoundY() * this.sizeX];
    }

    @Override
    public float getPixelInterpolated(Point3D P) {
        return this.getPixel((float)P.x, (float)P.y, (float)P.z);
    }

    @Override
    public ImageHandler cropRadius(int xc, int yc, int zc, int rx, int ry, int rz, boolean mean, boolean sphere) {
        int x0 = Math.max(0, xc - rx);
        int y0 = Math.max(0, yc - ry);
        int z0 = Math.max(0, zc - rz);
        int x1 = Math.min(this.sizeX, xc + rx);
        int y1 = Math.min(this.sizeY, yc + ry);
        int z1 = Math.min(this.sizeZ, zc + rz);
        double rx2 = rx * rx;
        double ry2 = ry * ry;
        double rz2 = rz * rz;
        float moy = 0.0f;
        if (mean) {
            ImageStats s = this.getImageStats(null);
            moy = (int)s.getMean();
        }
        ImageFloat res = new ImageFloat("crop_" + this.title, x1 - x0 + 1, y1 - y0 + 1, z1 - z0 + 1);
        for (int z = zc - rz; z <= z1; ++z) {
            for (int x = xc - rx; x <= x1; ++x) {
                for (int y = yc - ry; y <= y1; ++y) {
                    if (sphere) {
                        double r = (double)((x - xc) * (x - xc)) / rx2 + (double)((y - yc) * (y - yc)) / ry2 + (double)((z - zc) * (z - zc)) / rz2;
                        if (r <= 1.0) {
                            res.setPixel(x - xc + rx, y - yc + ry, z - zc + rz, this.getPixel(x, y, z));
                            continue;
                        }
                        res.setPixel(x - xc + rx, y - yc + ry, z - zc + rz, moy);
                        continue;
                    }
                    res.setPixel(x - xc + rx, y - yc + ry, z - zc + rz, this.getPixel(x, y, z));
                }
            }
        }
        return res;
    }

    public void filterGeneric(ImageFloat out, float radx, float rady, float radz, int zmin, int zmax, int filter) {
        this.filterGeneric(out, radx, rady, radz, zmin, zmax, filter, null, null);
    }

    public void filterGeneric(ImageFloat out, float radx, float rady, float radz, int zmin, int zmax, int filter, Chrono timer, AbstractLog log) {
        int[] ker = FastFilters3D.createKernelEllipsoid(radx, rady, radz);
        int nb = 0;
        for (int aKer : ker) {
            nb += aKer;
        }
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > this.sizeZ) {
            zmax = this.sizeZ;
        }
        for (int k = zmin; k < zmax; ++k) {
            String ti;
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    ArrayUtil tab = this.getNeighborhoodKernel(ker, nb, i, j, k, radx, rady, radz);
                    if (filter == 0) {
                        out.setPixel(i, j, k, (float)tab.getMean());
                    } else if (filter == 1) {
                        out.setPixel(i, j, k, (float)tab.medianSort());
                    }
                    if (filter == 2) {
                        out.setPixel(i, j, k, (float)tab.getMinimum());
                    }
                    if (filter == 3) {
                        out.setPixel(i, j, k, (float)tab.getMaximum());
                    }
                    if (filter == 8) {
                        out.setPixel(i, j, k, (float)tab.getVariance2());
                    }
                    if (filter != 4) continue;
                    float value = this.getPixel(i, j, k);
                    if (tab.isMaximum(value)) {
                        out.setPixel(i, j, k, value);
                        continue;
                    }
                    out.setPixel(i, j, k, 0.0f);
                }
            }
            if (timer == null || (ti = timer.getFullInfo(1)) == null) continue;
            log.log("3D filtering : " + ti);
        }
    }

    public void filterGeneric(ImageFloat out, Object3DVoxels obj, int zmin, int zmax, int filter) {
        this.filterGeneric(out, obj, zmin, zmax, filter, null, null);
    }

    public void filterGeneric(ImageFloat out, Object3DVoxels obj, int zmin, int zmax, int filter, Chrono timer, AbstractLog log) {
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > this.sizeZ) {
            zmax = this.sizeZ;
        }
        int[] ker = FastFilters3D.createKernelFromObject(obj);
        int nb = FastFilters3D.getNbFromKernel(ker);
        float[] rad = FastFilters3D.getRadiiFromObject(obj);
        for (int k = zmin; k < zmax; ++k) {
            String ti;
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    ArrayUtil tab = this.getNeighborhoodKernel(ker, nb, i, j, k, rad[0], rad[1], rad[2]);
                    if (filter == 0) {
                        out.setPixel(i, j, k, (float)(tab.getMean() + 0.5));
                    } else if (filter == 1) {
                        out.setPixel(i, j, k, (float)tab.medianSort());
                    }
                    if (filter == 2) {
                        out.setPixel(i, j, k, (float)tab.getMinimum());
                    }
                    if (filter == 3) {
                        out.setPixel(i, j, k, (float)tab.getMaximum());
                    }
                    if (filter == 8) {
                        out.setPixel(i, j, k, (float)(tab.getVariance2() + 0.5));
                    }
                    if (filter != 4) continue;
                    float value = this.getPixel(i, j, k);
                    if (tab.isMaximum(value)) {
                        out.setPixel(i, j, k, value);
                        continue;
                    }
                    out.setPixel(i, j, k, 0.0f);
                }
            }
            if (timer == null || (ti = timer.getFullInfo(1)) == null) continue;
            log.log("3D filtering : " + ti);
        }
    }

    public ImageFloat sobelFilter() {
        ImageFloat res = (ImageFloat)this.createSameDimensions();
        double[] edgeX = new double[]{-1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -4.0, 0.0, 4.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0, -2.0, 0.0, 2.0, -1.0, 0.0, 1.0};
        double[] edgeY = new double[]{-1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, -2.0, -4.0, -2.0, 0.0, 0.0, 0.0, 2.0, 4.0, 2.0, -1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0};
        double[] edgeZ = new double[]{-1.0, -2.0, -1.0, -2.0, -4.0, -2.0, -1.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, 2.0, 4.0, 2.0, 1.0, 2.0, 1.0};
        for (int k = 0; k < this.sizeZ; ++k) {
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    ArrayUtil nei = this.getNeighborhood3x3x3(i, j, k);
                    double ex = nei.convolve(edgeX, 1.0);
                    double ey = nei.convolve(edgeY, 1.0);
                    double ez = nei.convolve(edgeZ, 1.0);
                    double edge = Math.sqrt(ex * ex + ey * ey + ez * ez);
                    res.setPixel(i, j, k, (float)edge);
                }
            }
        }
        return res;
    }

    public void adaptiveFilter(ImageFloat filtered, float radx, float rady, float radz, int zmin, int zmax, Chrono timer, AbstractLog show) {
        int[] ker = FastFilters3D.createKernelEllipsoid(radx, rady, radz);
        int nb = 0;
        for (int i = 0; i < ker.length; ++i) {
            nb += ker[i];
        }
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > this.sizeZ) {
            zmax = this.sizeZ;
        }
        int nb2 = nb;
        float radX2 = radx;
        float radY2 = rady;
        float radZ2 = radz;
        ArrayUtil[] tab = new ArrayUtil[7];
        int dep = 1;
        for (int k = zmin; k < zmax; ++k) {
            String ti;
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    tab[0] = this.getNeighborhoodKernel(ker, nb2, i, j, k, radX2, radY2, radZ2);
                    tab[1] = this.getNeighborhoodKernel(ker, nb2, i + dep, j, k, radX2, radY2, radZ2);
                    tab[2] = this.getNeighborhoodKernel(ker, nb2, i - dep, j, k, radX2, radY2, radZ2);
                    tab[3] = this.getNeighborhoodKernel(ker, nb2, i, j + dep, k, radX2, radY2, radZ2);
                    tab[4] = this.getNeighborhoodKernel(ker, nb2, i, j - dep, k, radX2, radY2, radZ2);
                    tab[5] = this.getNeighborhoodKernel(ker, nb2, i, j, k + dep, radX2, radY2, radZ2);
                    tab[6] = this.getNeighborhoodKernel(ker, nb2, i, j, k - dep, radX2, radY2, radZ2);
                    double mes = 0.0;
                    double mins = 3.4028234663852886E38;
                    for (int c = 0; c < 7; ++c) {
                        double me = tab[c].getMean();
                        double si = tab[c].getStdDev();
                        if (!(si < mins)) continue;
                        mins = si;
                        mes = me;
                    }
                    filtered.setPixel(i, j, k, (int)mes);
                }
            }
            if (timer == null || (ti = timer.getFullInfo(1)) == null) continue;
            show.log("3D filtering : " + ti);
        }
    }

    @Deprecated
    public ImageFloat adaptiveFilter(float radx, float rady, float radz, int nbcpus) {
        final ImageFloat adaptimg2 = (ImageFloat)this.createSameDimensions();
        final int[] ker = FastFilters3D.createKernelEllipsoid(radx, rady, radz);
        int nb = 0;
        for (int aKer : ker) {
            nb += aKer;
        }
        final int nb2 = nb;
        final float radX2 = radx;
        final float radY2 = rady;
        final float radZ2 = radz;
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = ThreadUtil.createThreadArray(nbcpus);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    ArrayUtil[] tab = new ArrayUtil[7];
                    int dep = 1;
                    double me = 0.0;
                    int k = ai.getAndIncrement();
                    while (k < ImageFloat.this.sizeZ) {
                        for (int j = 0; j < ImageFloat.this.sizeY; ++j) {
                            for (int i = 0; i < ImageFloat.this.sizeX; ++i) {
                                tab[0] = ImageFloat.this.getNeighborhoodKernel(ker, nb2, i, j, k, radX2, radY2, radZ2);
                                tab[1] = ImageFloat.this.getNeighborhoodKernel(ker, nb2, i + dep, j, k, radX2, radY2, radZ2);
                                tab[2] = ImageFloat.this.getNeighborhoodKernel(ker, nb2, i - dep, j, k, radX2, radY2, radZ2);
                                tab[3] = ImageFloat.this.getNeighborhoodKernel(ker, nb2, i, j + dep, k, radX2, radY2, radZ2);
                                tab[4] = ImageFloat.this.getNeighborhoodKernel(ker, nb2, i, j - dep, k, radX2, radY2, radZ2);
                                tab[5] = ImageFloat.this.getNeighborhoodKernel(ker, nb2, i, j, k + dep, radX2, radY2, radZ2);
                                tab[6] = ImageFloat.this.getNeighborhoodKernel(ker, nb2, i, j, k - dep, radX2, radY2, radZ2);
                                double mes = 0.0;
                                double mins = 3.4028234663852886E38;
                                for (int c = 0; c < 7; ++c) {
                                    me = tab[c].getMean();
                                    double si = tab[c].getStdDev();
                                    if (!(si < mins)) continue;
                                    mins = si;
                                    mes = me;
                                }
                                adaptimg2.setPixel(i, j, k, (int)mes);
                            }
                        }
                        k = ai.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin(threads);
        return adaptimg2;
    }

    @Override
    public ImageHandler deleteSlices(int zmin, int zmax) {
        int z;
        int z0 = Math.min(zmin, zmax);
        int z1 = Math.max(zmin, zmax);
        int diff = z1 - z0 + 1;
        int newSz = this.sizeZ - diff;
        ImageFloat res = new ImageFloat("deleted slices", this.sizeX, this.sizeY, newSz);
        for (z = 0; z < z0; ++z) {
            System.arraycopy(this.pixels[z], 0, res.pixels[z], 0, this.sizeXY);
        }
        for (z = z1 + 1; z < this.sizeZ; ++z) {
            System.arraycopy(this.pixels[z], 0, res.pixels[z - diff], 0, this.sizeXY);
        }
        return res;
    }

    @Override
    public void trimSlices(int zmin, int zmax) {
        int z0 = Math.max(1, Math.min(zmin, zmax));
        int z1 = Math.min(this.sizeZ, Math.max(zmin, zmax));
        int newSize = z1 - z0 + 1;
        float[][] newPixels = new float[newSize][];
        System.arraycopy(this.pixels, 0 + z0 - 1, newPixels, 0, newSize);
        if (this.img != null) {
            int i;
            ImageStack stack = this.img.getImageStack();
            for (i = 1; i < z0; ++i) {
                stack.deleteSlice(1);
            }
            for (i = z1 + 1; i <= this.sizeZ; ++i) {
                stack.deleteLastSlice();
            }
        }
        this.sizeZ = newSize;
        this.sizeXYZ = this.sizeXY * this.sizeZ;
        this.offsetZ += z0 - 1;
        this.stats = new HashMap(2);
    }

    @Override
    public double getSizeInMb() {
        return (double)(4 * this.sizeX * this.sizeY * this.sizeZ) / 1048576.0;
    }

    @Override
    public int getType() {
        return 2;
    }

    public ArrayList<Voxel3DComparable> getListMaxima(float radx, float rady, float radz, int zmin, int zmax) {
        return this.getListMaxima(radx, rady, radz, zmin, zmax, null, null);
    }

    public ArrayList<Voxel3DComparable> getListMaxima(float radx, float rady, float radz, int zmin, int zmax, Chrono timer, AbstractLog log) {
        ArrayList<Voxel3DComparable> res = new ArrayList<Voxel3DComparable>();
        int[] ker = FastFilters3D.createKernelEllipsoid(radx, rady, radz);
        int nb = FastFilters3D.getNbFromKernel(ker);
        if (zmin < 0) {
            zmin = 0;
        }
        if (zmax > this.sizeZ) {
            zmax = this.sizeZ;
        }
        for (int k = zmin; k < zmax; ++k) {
            String ti;
            for (int j = 0; j < this.sizeY; ++j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    float value;
                    ArrayUtil tab = this.getNeighborhoodKernel(ker, nb, i, j, k, radx, rady, radz);
                    if (!tab.isMaximum(value = this.getPixel(i, j, k))) continue;
                    res.add(new Voxel3DComparable(i, j, k, value, 1.0));
                }
            }
            if (timer == null || (ti = timer.getFullInfo(1)) == null) continue;
            log.log("3D maxima : " + ti);
        }
        return res;
    }
}

