/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.base.Shape;
import mitiv.deconv.ConvolutionDouble;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.DoubleFFT_1D;

class ConvolutionDouble1D
extends ConvolutionDouble {
    private DoubleFFT_1D fft = null;
    private final PushPullOperator R;
    private final PushPullOperator S;
    private final int dim1;

    public ConvolutionDouble1D(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        super(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
        if (this.getRank() != 1) {
            throw new IllegalArgumentException("Input and output spaces must be 1D");
        }
        this.dim1 = this.workShape.dimension(0);
        this.R = new PushPullOperator(this.workShape, shapedVectorSpace2.getShape(), this.outputOffsets, this.fastOutput);
        this.S = new PushPullOperator(this.workShape, shapedVectorSpace.getShape(), this.inputOffsets, this.fastInput);
    }

    private final void createFFT() {
        if (this.fft == null) {
            this.fft = new DoubleFFT_1D(this.dim1);
        }
    }

    @Override
    public final void forwardFFT(double[] dArray) {
        if (dArray.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexForward(dArray);
        this.timerForFFT.stop();
    }

    @Override
    public final void backwardFFT(double[] dArray) {
        if (dArray.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexInverse(dArray, false);
        this.timerForFFT.stop();
    }

    @Override
    public void push(double[] dArray, double[] dArray2, boolean bl) {
        if (bl) {
            this.R.push(dArray, dArray2);
        } else {
            this.S.push(dArray, dArray2);
        }
    }

    @Override
    public void pull(double[] dArray, double[] dArray2, boolean bl) {
        if (bl) {
            this.S.pull(dArray, dArray2);
        } else {
            this.R.pull(dArray, dArray2);
        }
    }

    private class PushPullOperator {
        private final boolean fast;
        private final int off1;
        private final int end1;

        private PushPullOperator(Shape shape, Shape shape2, int[] nArray, boolean bl) {
            this.fast = bl;
            this.off1 = nArray[0];
            this.end1 = this.off1 + shape2.dimension(0);
        }

        private void push(double[] dArray, double[] dArray2) {
            if (this.fast) {
                int n = 0;
                int n2 = 0;
                while (n < dArray2.length) {
                    dArray[n2] = dArray2[n];
                    dArray[n2 + 1] = 0.0;
                    ++n;
                    n2 += 2;
                }
            } else {
                int n = 0;
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.off1) {
                    dArray[n3] = 0.0;
                    dArray[n3 + 1] = 0.0;
                    ++n4;
                    n3 += 2;
                }
                n4 = this.off1;
                while (n4 < this.end1) {
                    dArray[n3] = dArray2[n];
                    dArray[n3 + 1] = 0.0;
                    ++n4;
                    ++n;
                    n3 += 2;
                }
                n4 = this.end1;
                while (n4 < ConvolutionDouble1D.this.dim1) {
                    dArray[n3] = 0.0;
                    dArray[n3 + 1] = 0.0;
                    ++n4;
                    n3 += 2;
                }
            }
        }

        private void pull(double[] dArray, double[] dArray2) {
            if (this.fast) {
                int n = 0;
                int n2 = 0;
                while (n < dArray.length) {
                    dArray[n] = dArray2[n2];
                    ++n;
                    n2 += 2;
                }
            } else {
                int n = 0;
                int n3 = this.off1 * 2;
                int n4 = this.off1;
                while (n4 < this.end1) {
                    dArray[n] = dArray2[n3];
                    ++n4;
                    ++n;
                    n3 += 2;
                }
            }
        }
    }
}

