/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array5D;
import mitiv.array.Byte5D;
import mitiv.array.Double5D;
import mitiv.array.Float5D;
import mitiv.array.Int5D;
import mitiv.array.Long5D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short4D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort5D;
import mitiv.array.impl.StriddenShort5D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short5D
extends Array5D
implements ShortArray {
    protected Short5D(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
    }

    protected Short5D(int[] nArray) {
        super(nArray);
    }

    protected Short5D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2, int var3, int var4, int var5);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, short var6);

    @Override
    public void fill(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, s);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, s);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, (short)(this.get(i, j, k, i2, i3) + s));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (short)(this.get(i5, i4, k, j, i) + s));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, (short)(this.get(i, j, k, i2, i3) - s));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (short)(this.get(i5, i4, k, j, i) - s));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, (short)(this.get(i, j, k, i2, i3) * s));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (short)(this.get(i5, i4, k, j, i) * s));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, shortFunction.apply(this.get(i, j, k, i2, i3)));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, shortFunction.apply(this.get(i5, i4, k, j, i)));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, shortGenerator.nextShort());
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, shortGenerator.nextShort());
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    shortScanner.update(this.get(i, j, k, i2, i3));
                                    continue;
                                }
                                shortScanner.initialize(this.get(i, j, k, i2, i3));
                                bl = true;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    shortScanner.update(this.get(i5, i4, k, j, i));
                                    continue;
                                }
                                shortScanner.initialize(this.get(i5, i4, k, j, i));
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short s = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                short s2 = this.get(i, j, k, i2, i3);
                                if (s2 >= s) continue;
                                s = s2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                short s3 = this.get(i5, i4, k, j, i);
                                if (s3 >= s) continue;
                                s = s3;
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short max() {
        short s = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                short s2 = this.get(i, j, k, i2, i3);
                                if (s2 <= s) continue;
                                s = s2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                short s3 = this.get(i5, i4, k, j, i);
                                if (s3 <= s) continue;
                                s = s3;
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short[] getMinAndMax() {
        short[] sArray = new short[2];
        this.getMinAndMax(sArray);
        return sArray;
    }

    @Override
    public void getMinAndMax(short[] sArray) {
        short s;
        short s2 = s = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                short s3 = this.get(i, j, k, i2, i3);
                                if (s3 < s) {
                                    s = s3;
                                }
                                if (s3 <= s2) continue;
                                s2 = s3;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                short s4 = this.get(i5, i4, k, j, i);
                                if (s4 < s) {
                                    s = s4;
                                }
                                if (s4 <= s2) continue;
                                s2 = s4;
                            }
                        }
                    }
                }
            }
        }
        sArray[0] = s;
        sArray[1] = s2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                n += this.get(i, j, k, i2, i3);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                n += this.get(i5, i4, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte5D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                byArray[++n] = (byte)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Byte5D.wrap(byArray, this.getShape());
    }

    @Override
    public Short5D toShort() {
        return this;
    }

    @Override
    public Int5D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                nArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Int5D.wrap(nArray, this.getShape());
    }

    @Override
    public Long5D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                lArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Long5D.wrap(lArray, this.getShape());
    }

    @Override
    public Float5D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                fArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Float5D.wrap(fArray, this.getShape());
    }

    @Override
    public Double5D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                dArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Double5D.wrap(dArray, this.getShape());
    }

    @Override
    public Short5D copy() {
        return new FlatShort5D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Short5D short5D = shapedArray.getType() == 1 ? (Short5D)shapedArray : (Short5D)shapedArray.toShort();
        if (this.getOrder() == 2 && short5D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, short5D.get(i, j, k, i2, i3));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, short5D.get(i5, i4, k, j, i));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                this.set(i3, i2, k, j, i, (short)doubleShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (short)floatShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short5D create() {
        return new FlatShort5D(this.getShape());
    }

    public static Short5D create(int n, int n2, int n3, int n4, int n5) {
        return new FlatShort5D(n, n2, n3, n4, n5);
    }

    public static Short5D create(int[] nArray) {
        return new FlatShort5D(nArray);
    }

    public static Short5D create(Shape shape) {
        return new FlatShort5D(shape);
    }

    public static Short5D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        return new FlatShort5D(sArray, n, n2, n3, n4, n5);
    }

    public static Short5D wrap(short[] sArray, int[] nArray) {
        return new FlatShort5D(sArray, nArray);
    }

    public static Short5D wrap(short[] sArray, Shape shape) {
        return new FlatShort5D(sArray, shape);
    }

    public static Short5D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        return new StriddenShort5D(sArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    @Override
    public abstract Short4D slice(int var1);

    @Override
    public abstract Short4D slice(int var1, int var2);

    @Override
    public abstract Short5D view(Range var1, Range var2, Range var3, Range var4, Range var5);

    @Override
    public abstract Short5D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    @Override
    public abstract Short1D as1D();
}

