/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.Short3D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort1D;
import mitiv.array.impl.SelectedShort2D;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.random.ShortGenerator;

public class SelectedShort3D
extends Short3D {
    static final int order = 0;
    final short[] data;
    final int[] idx1;
    final int[] idx2;
    final int[] idx3;

    public SelectedShort3D(short[] sArray, int[] nArray, int[] nArray2, int[] nArray3) {
        super(nArray.length, nArray2.length, nArray3.length);
        this.data = sArray;
        this.idx1 = nArray;
        this.idx2 = nArray2;
        this.idx3 = nArray3;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 = this.idx1[0];
        for (n2 = 1; n2 < this.dim1; ++n2) {
            n = this.idx1[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        n4 += n6;
        n5 += n3;
        n6 = n3 = this.idx2[0];
        for (n2 = 1; n2 < this.dim2; ++n2) {
            n = this.idx2[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        n4 += n6;
        n5 += n3;
        n6 = n3 = this.idx3[0];
        for (n2 = 1; n2 < this.dim3; ++n2) {
            n = this.idx3[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        if ((n4 += n6) < 0 || (n5 += n3) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n, int n2, int n3) {
        return this.idx3[n3] + this.idx2[n2] + this.idx1[n];
    }

    @Override
    public final short get(int n, int n2, int n3) {
        return this.data[this.idx3[n3] + this.idx2[n2] + this.idx1[n]];
    }

    @Override
    public final void set(int n, int n2, int n3, short s) {
        this.data[this.idx3[n3] + this.idx2[n2] + this.idx1[n]] = s;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(short s) {
        for (int i = 0; i < this.dim3; ++i) {
            int n = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n2 = this.idx2[j] + n;
                for (int k = 0; k < this.dim1; ++k) {
                    int n3 = this.idx1[k] + n2;
                    this.data[n3] = s;
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        for (int i = 0; i < this.dim3; ++i) {
            int n = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n2 = this.idx2[j] + n;
                for (int k = 0; k < this.dim1; ++k) {
                    int n3 = this.idx1[k] + n2;
                    this.data[n3] = shortGenerator.nextShort();
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        for (int i = 0; i < this.dim3; ++i) {
            int n = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n2 = this.idx2[j] + n;
                for (int k = 0; k < this.dim1; ++k) {
                    int n3;
                    int n4 = n3 = this.idx1[k] + n2;
                    this.data[n4] = (short)(this.data[n4] + s);
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        for (int i = 0; i < this.dim3; ++i) {
            int n = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n2 = this.idx2[j] + n;
                for (int k = 0; k < this.dim1; ++k) {
                    int n3;
                    int n4 = n3 = this.idx1[k] + n2;
                    this.data[n4] = (short)(this.data[n4] - s);
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        for (int i = 0; i < this.dim3; ++i) {
            int n = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n2 = this.idx2[j] + n;
                for (int k = 0; k < this.dim1; ++k) {
                    int n3;
                    int n4 = n3 = this.idx1[k] + n2;
                    this.data[n4] = (short)(this.data[n4] * s);
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        for (int i = 0; i < this.dim3; ++i) {
            int n = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n2 = this.idx2[j] + n;
                for (int k = 0; k < this.dim1; ++k) {
                    int n3 = this.idx1[k] + n2;
                    this.data[n3] = shortFunction.apply(this.data[n3]);
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim3; ++i) {
            int n = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n2 = this.idx2[j] + n;
                for (int k = 0; k < this.dim1; ++k) {
                    int n3 = this.idx1[k] + n2;
                    if (bl) {
                        shortScanner.update(this.data[n3]);
                        continue;
                    }
                    shortScanner.initialize(this.data[n3]);
                    bl = true;
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public short[] flatten(boolean bl) {
        short[] sArray = new short[this.number];
        int n = -1;
        for (int i = 0; i < this.dim3; ++i) {
            int n2 = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n3 = this.idx2[j] + n2;
                for (int k = 0; k < this.dim1; ++k) {
                    int n4 = this.idx1[k] + n3;
                    sArray[++n] = this.data[n4];
                }
            }
        }
        return sArray;
    }

    @Override
    public short[] getData() {
        return null;
    }

    @Override
    public Short2D slice(int n) {
        int[] nArray;
        int n2 = this.idx3[Helper.fixIndex(n, this.dim3)];
        if (n2 == 0) {
            nArray = this.idx1;
        } else {
            nArray = new int[this.dim1];
            for (int i = 0; i < this.dim1; ++i) {
                nArray[i] = this.idx1[i] + n2;
            }
        }
        return new SelectedShort2D(this.data, nArray, this.idx2);
    }

    @Override
    public Short2D slice(int n, int n2) {
        int[] nArray;
        int[] nArray2;
        int n3;
        if ((n2 = Helper.fixSliceIndex(n2, 3)) == 0) {
            n3 = this.idx1[Helper.fixIndex(n, this.dim1)];
            nArray2 = this.idx2;
            nArray = this.idx3;
        } else if (n2 == 1) {
            nArray2 = this.idx1;
            n3 = this.idx2[Helper.fixIndex(n, this.dim2)];
            nArray = this.idx3;
        } else {
            nArray2 = this.idx1;
            nArray = this.idx2;
            n3 = this.idx3[Helper.fixIndex(n, this.dim3)];
        }
        if (n3 != 0) {
            int n4 = nArray2.length;
            int[] nArray3 = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray3[i] = n3 + nArray2[i];
            }
            nArray2 = nArray3;
        }
        return new SelectedShort2D(this.data, nArray2, nArray);
    }

    @Override
    public Short3D view(Range range, Range range2, Range range3) {
        int[] nArray = Helper.select(this.idx1, range);
        int[] nArray2 = Helper.select(this.idx2, range2);
        int[] nArray3 = Helper.select(this.idx3, range3);
        if (nArray == this.idx1 && nArray2 == this.idx2 && nArray3 == this.idx3) {
            return this;
        }
        return new SelectedShort3D(this.data, nArray, nArray2, nArray3);
    }

    @Override
    public Short3D view(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Helper.select(this.idx1, nArray);
        int[] nArray5 = Helper.select(this.idx2, nArray2);
        int[] nArray6 = Helper.select(this.idx3, nArray3);
        if (nArray4 == this.idx1 && nArray5 == this.idx2 && nArray6 == this.idx3) {
            return this;
        }
        return new SelectedShort3D(this.data, nArray4, nArray5, nArray6);
    }

    @Override
    public Short1D as1D() {
        int[] nArray = new int[this.number];
        int n = -1;
        for (int i = 0; i < this.dim3; ++i) {
            int n2 = this.idx3[i];
            for (int j = 0; j < this.dim2; ++j) {
                int n3 = this.idx2[j] + n2;
                for (int k = 0; k < this.dim1; ++k) {
                    int n4 = this.idx1[k] + n3;
                    nArray[++n] = n4;
                }
            }
        }
        return new SelectedShort1D(this.data, nArray);
    }
}

