/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.tool;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Arrow;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.plugin.tool.PlugInTool;
import java.awt.event.MouseEvent;

public class ArrowTool
extends PlugInTool {
    Roi arrow;

    public void mousePressed(ImagePlus imp, MouseEvent e) {
        int handle;
        ImageCanvas ic = imp.getCanvas();
        int sx = e.getX();
        int sy = e.getY();
        int ox = ic.offScreenX(sx);
        int oy = ic.offScreenY(sy);
        Roi roi = imp.getRoi();
        int n = handle = roi != null ? roi.isHandle(ox, oy) : -1;
        if (roi == null || !(roi instanceof Arrow) || handle < 0 && !roi.contains(ox, oy)) {
            this.arrow = new Arrow(sx, sy, imp);
            imp.setRoi(this.arrow, false);
            e.consume();
        }
    }

    public void mouseDragged(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        int sx = e.getX();
        int sy = e.getY();
        int ox = ic.offScreenX(sx);
        int oy = ic.offScreenY(sy);
        Roi roi = imp.getRoi();
        if (roi != null && roi instanceof Arrow && roi.contains(ox, oy)) {
            roi.mouseDragged(e);
        } else if (this.arrow != null) {
            this.arrow.mouseDragged(e);
        }
        e.consume();
    }

    public void mouseReleased(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        int sx = e.getX();
        int sy = e.getY();
        int ox = ic.offScreenX(sx);
        int oy = ic.offScreenY(sy);
        Roi roi = imp.getRoi();
        if (!(this.arrow == null || roi != null && roi instanceof Arrow && roi.contains(ox, oy))) {
            this.arrow.mouseReleased(e);
            e.consume();
        }
    }

    public void showOptionsDialog() {
        IJ.doCommand("Arrow Tool...");
    }

    public String getToolIcon() {
        return "B10C037L0fe1L65e1La9e1L65a9C123L8586L9497La4a7Lb3b6Lc3c4";
    }

    public String getToolName() {
        return "Arrow Tool";
    }
}

