/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;

public abstract class VectorSpace {
    protected final int number;

    protected VectorSpace(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Bad vector space size.");
        }
        this.number = n;
    }

    public final int getNumber() {
        return this.number;
    }

    public abstract Vector create();

    public Vector create(double d) {
        Vector vector = this.create();
        this._fill(vector, d);
        return vector;
    }

    public Vector one() {
        return this.create(1.0);
    }

    public Vector zero() {
        return this.create(0.0);
    }

    public final boolean owns(Vector vector) {
        return vector != null && vector.belongsTo(this);
    }

    public final void check(Vector vector) throws IncorrectSpaceException {
        if (!this.owns(vector)) {
            throw new IncorrectSpaceException();
        }
    }

    protected abstract double _dot(Vector var1, Vector var2);

    protected abstract double _dot(Vector var1, Vector var2, Vector var3);

    protected double _norm2(Vector vector) {
        return Math.sqrt(this._dot(vector, vector));
    }

    protected abstract double _norm1(Vector var1);

    protected abstract double _normInf(Vector var1);

    protected abstract void _scale(Vector var1, double var2, Vector var4);

    protected void _scale(Vector vector, double d) {
        this._scale(vector, d, vector);
    }

    protected abstract void _combine(Vector var1, double var2, Vector var4, double var5, Vector var7);

    protected abstract void _combine(Vector var1, double var2, Vector var4, double var5, Vector var7, double var8, Vector var10);

    protected void _add(Vector vector, double d, Vector vector2) {
        this._combine(vector, 1.0, vector, d, vector2);
    }

    protected abstract void _multiply(Vector var1, Vector var2, Vector var3);

    protected void _copy(Vector vector, Vector vector2) {
        this._combine(vector, 1.0, vector2, 0.0, vector2);
    }

    protected abstract void _swap(Vector var1, Vector var2);

    protected Vector _clone(Vector vector) {
        Vector vector2 = this.create();
        this._copy(vector2, vector);
        return vector2;
    }

    protected void _zero(Vector vector) {
        this._fill(vector, 0.0);
    }

    protected abstract void _fill(Vector var1, double var2);
}

