/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.strategies;

import java.util.ArrayList;
import net.phys2d.raw.Body;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.BroadCollisionStrategy;
import net.phys2d.raw.CollisionContext;
import net.phys2d.raw.shapes.AABox;

public class QuadSpaceStrategy
implements BroadCollisionStrategy {
    private ArrayList spaces = new ArrayList();
    private int maxLevels;
    private int maxInSpace;

    public QuadSpaceStrategy(int maxInSpace, int maxLevels) {
        this.maxInSpace = maxInSpace;
        this.maxLevels = maxLevels;
    }

    public void collideBodies(CollisionContext context, BodyList bodies, float dt) {
        int i;
        this.spaces.clear();
        Space space = new Space(0.0f, 0.0f, 0.0f, 0.0f);
        for (i = 0; i < bodies.size(); ++i) {
            Body body = bodies.get(i);
            space.addAABox(body.getShape().getBounds(), body.getPosition().getX(), body.getPosition().getY());
            space.addBody(body);
        }
        this.splitSpace(space, 0, this.maxInSpace, this.spaces);
        for (i = 0; i < this.spaces.size(); ++i) {
            context.resolve((Space)this.spaces.get(i), dt);
        }
    }

    public ArrayList getSpaces() {
        return this.spaces;
    }

    private boolean splitSpace(Space space, int level, int target, ArrayList spaceList) {
        if (space.size() <= target) {
            spaceList.add(space);
            return true;
        }
        if (level > this.maxLevels) {
            spaceList.add(space);
            return true;
        }
        Space[] spaces = space.getQuadSpaces();
        for (int j = 0; j < 4; ++j) {
            this.splitSpace(spaces[j], level + 1, target, spaceList);
        }
        return false;
    }

    public class Space
    extends BodyList {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public Space(float x, float y, float width, float height) {
            this.x1 = x;
            this.y1 = y;
            this.x2 = x + width;
            this.y2 = y + height;
        }

        public void addBody(Body body) {
            this.add(body);
        }

        public Space[] getQuadSpaces() {
            Space[] spaces = new Space[4];
            float width = (this.x2 - this.x1) / 2.0f;
            float height = (this.y2 - this.y1) / 2.0f;
            spaces[0] = new Space(this.x1, this.y1, width, height);
            spaces[1] = new Space(this.x1, this.y1 + height, width, height);
            spaces[2] = new Space(this.x1 + width, this.y1, width, height);
            spaces[3] = new Space(this.x1 + width, this.y1 + height, width, height);
            for (int i = 0; i < this.size(); ++i) {
                Body body = this.get(i);
                for (int j = 0; j < 4; ++j) {
                    if (!spaces[j].touches(body.getShape().getBounds(), body.getPosition().getX(), body.getPosition().getY())) continue;
                    spaces[j].add(body);
                }
            }
            return spaces;
        }

        public void addAABox(AABox box, float xp, float yp) {
            float x1 = xp - box.getWidth();
            float x2 = xp + box.getWidth();
            float y1 = yp - box.getHeight();
            float y2 = yp + box.getHeight();
            this.x1 = Math.min(x1, this.x1);
            this.y1 = Math.min(y1, this.y1);
            this.x2 = Math.max(x2, this.x2);
            this.y2 = Math.max(y2, this.y2);
        }

        public boolean touches(AABox box, float xp, float yp) {
            float thisWidth = (this.x2 - this.x1) / 2.0f;
            float thisHeight = (this.y2 - this.y1) / 2.0f;
            float thisCx = this.x1 + thisWidth;
            float thisCy = this.y1 + thisHeight;
            float x1 = xp - box.getWidth() / 2.0f;
            float x2 = xp + box.getWidth() / 2.0f;
            float y1 = yp - box.getHeight() / 2.0f;
            float y2 = yp + box.getHeight() / 2.0f;
            float otherWidth = (x2 - x1) / 2.0f;
            float otherHeight = (y2 - y1) / 2.0f;
            float otherCx = xp;
            float otherCy = yp;
            float dx = Math.abs(thisCx - otherCx);
            float dy = Math.abs(thisCy - otherCy);
            float totalWidth = thisWidth + otherWidth;
            float totalHeight = thisHeight + otherHeight;
            return totalWidth > dx && totalHeight > dy;
        }

        public float getX1() {
            return this.x1;
        }

        public float getX2() {
            return this.x2;
        }

        public float getY1() {
            return this.y1;
        }

        public float getY2() {
            return this.y2;
        }

        public String toString() {
            return "[Space " + this.x1 + "," + this.y1 + " " + this.x2 + "," + this.y2 + " " + this.size() + " bodies]";
        }
    }
}

