/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.io;

import icy.file.Saver;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.io.File;
import mitiv.array.ShapedArray;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.utils.Imager;
import plugins.mitiv.io.Icy2TiPi;

public class IcyImager
implements Imager {
    protected boolean headless = false;
    protected String title;
    private Sequence sequence;

    public IcyImager(Sequence sequence, boolean bl) {
        this.sequence = sequence;
        this.headless = bl;
    }

    public IcyImager(Sequence sequence) {
        this.sequence = sequence;
    }

    public IcyImager(boolean bl) {
        this.headless = bl;
    }

    public static void show(ShapedArray shapedArray, Sequence sequence, String string, boolean bl) {
        if (sequence == null) {
            sequence = new Sequence();
            if (bl) {
                Icy.getMainInterface().addSequence(sequence);
            }
        }
        sequence.beginUpdate();
        sequence = Icy2TiPi.arrayToSequence(shapedArray, sequence);
        if (sequence.getFirstViewer() == null && !bl) {
            Icy.getMainInterface().addSequence(sequence);
        }
        sequence.endUpdate();
        sequence.setName(string);
    }

    public void show(ShapedArray shapedArray) {
        IcyImager.show(shapedArray, this.sequence, this.title, this.headless);
    }

    public void show(ShapedVector shapedVector) {
        this.show(shapedVector.asShapedArray());
    }

    public void show(ShapedArray shapedArray, String string) {
        this.title = string;
        IcyImager.show(shapedArray, this.sequence, string, this.headless);
    }

    public void show(ShapedVector shapedVector, String string) {
        this.show(shapedVector.asShapedArray(), string);
    }

    protected void show(ShapedVector shapedVector, Sequence sequence, String string) {
        this.title = string;
        this.sequence = sequence;
        this.show(shapedVector.asShapedArray());
    }

    public void save(String string) {
        this.save((ShapedArray)null, string);
    }

    public void save(ShapedVector shapedVector, String string) {
        this.save(shapedVector.asShapedArray(), string);
    }

    public void save(ShapedArray shapedArray, String string) {
        IcyImager.save(shapedArray, this.sequence, string);
    }

    public static void save(ShapedArray shapedArray, Sequence sequence, String string) {
        if (sequence == null) {
            if (shapedArray == null) {
                return;
            }
            sequence = new Sequence();
        }
        if (shapedArray != null) {
            sequence = Icy2TiPi.arrayToSequence(shapedArray, sequence);
        }
        if (string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                file = new File(file.getAbsolutePath() + File.separator + sequence + ".tif");
            }
            Saver.save((Sequence)sequence, (File)file, (boolean)false, (boolean)false);
        }
    }

    public static void save(Sequence sequence, String string) {
        if (sequence == null) {
            return;
        }
        if (string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                file = new File(file.getAbsolutePath() + File.separator + sequence + ".tif");
            }
            Saver.save((Sequence)sequence, (File)file, (boolean)false, (boolean)false);
        }
    }
}

