/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.meta.MetadataStore;
import loci.formats.services.NetCDFService;

public class VeecoReader
extends FormatReader {
    private NetCDFService netcdf;
    private Object image;
    private boolean unpackEndian = true;

    public VeecoReader() {
        super("Veeco", "hdf");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        block4: {
            block3: {
                FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
                if (!(this.image instanceof byte[][])) break block3;
                byte[][] byteImage = (byte[][])this.image;
                for (int row = h + y - 1; row >= y; --row) {
                    System.arraycopy(byteImage[row], x, buf, (row - y) * w, w);
                }
                break block4;
            }
            if (!(this.image instanceof short[][])) break block4;
            short[][] shortImage = (short[][])this.image;
            int output = 0;
            for (int row = h + y - 1; row >= y; --row) {
                for (int col = x; col < x + w; ++col) {
                    DataTools.unpackBytes(shortImage[row][col], buf, output, 2, this.unpackEndian);
                    output += 2;
                }
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.netcdf != null) {
                this.netcdf.close();
            }
            this.image = null;
            this.unpackEndian = true;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.netcdf = factory.getInstance(NetCDFService.class);
            this.netcdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(e);
        }
        Vector<String> variableList = this.netcdf.getVariableList();
        if (variableList.size() == 0) {
            throw new FormatException("No image data found");
        }
        String imageName = variableList.get(0);
        try {
            this.image = this.netcdf.getVariableValue(imageName);
        }
        catch (ServiceException e) {
            throw new FormatException("Could not retrieve image data", e);
        }
        Hashtable<String, Object> attributes = this.netcdf.getVariableAttributes(imageName);
        for (String attr : attributes.keySet()) {
            this.addGlobalMeta(attr, attributes.get(attr));
        }
        if (this.image instanceof byte[][]) {
            byte[][] byteImage = (byte[][])this.image;
            m.sizeX = byteImage[0].length;
            m.sizeY = byteImage.length;
            m.pixelType = 0;
        } else if (this.image instanceof short[][]) {
            short[][] shortImage = (short[][])this.image;
            m.sizeX = shortImage[0].length;
            m.sizeY = shortImage.length;
            m.pixelType = 2;
            short nativeMin = 0;
            short nativeMax = 0;
            short swappedMin = 0;
            short swappedMax = 0;
            for (int y = 0; y < shortImage.length; ++y) {
                for (int x = 0; x < shortImage[y].length; ++x) {
                    short swapped;
                    if (shortImage[y][x] < nativeMin) {
                        nativeMin = shortImage[y][x];
                    }
                    if (shortImage[y][x] > nativeMax) {
                        nativeMax = shortImage[y][x];
                    }
                    if ((swapped = DataTools.swap(shortImage[y][x])) < swappedMin) {
                        swappedMin = swapped;
                    }
                    if (swapped <= swappedMax) continue;
                    swappedMax = swapped;
                }
            }
            this.unpackEndian = nativeMin <= swappedMin && nativeMax >= swappedMax;
        }
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = m.sizeZ * m.sizeC * m.sizeT;
        m.dimensionOrder = "XYCZT";
        m.littleEndian = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

