/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.LBFGSOperator;
import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.QuasiNewton;

public class LBFGS
extends QuasiNewton {
    protected LBFGSOperator H = null;
    private final boolean saveMemory = true;
    protected Vector x0 = null;
    protected double f0 = 0.0;
    protected Vector g0 = null;
    protected Vector p = null;
    protected double alpha;
    protected double dg0 = 0.0;
    protected double gnorm = 0.0;

    public LBFGS(VectorSpace vectorSpace, int n) {
        this(new LBFGSOperator(vectorSpace, n), (LineSearch)new MoreThuenteLineSearch(1.0E-4, 0.9, SXTOL));
    }

    public LBFGS(VectorSpace vectorSpace, int n, LineSearch lineSearch) {
        this(new LBFGSOperator(vectorSpace, n), lineSearch);
    }

    public LBFGS(LinearEndomorphism linearEndomorphism, int n, LineSearch lineSearch) {
        this(new LBFGSOperator(linearEndomorphism, n), lineSearch);
    }

    private LBFGS(LBFGSOperator lBFGSOperator, LineSearch lineSearch) {
        super(lBFGSOperator.getSpace(), lineSearch);
        this.H = lBFGSOperator;
        this.p = lBFGSOperator.getSpace().create();
        this.getClass();
    }

    @Override
    public OptimTask start() {
        this.evaluations = 0;
        this.iterations = 0;
        this.restarts = 0;
        return this.begin();
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.begin();
    }

    private OptimTask begin() {
        this.H.reset();
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector vector, double d, Vector vector2) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                double d2;
                ++this.evaluations;
                if (this.evaluations > 1) {
                    LineSearchTask lineSearchTask = this.lnsrch.iterate(d, -this.p.dot(vector2));
                    if (lineSearchTask == LineSearchTask.SEARCH) {
                        return this.nextStep(vector);
                    }
                    if (lineSearchTask != LineSearchTask.CONVERGENCE) {
                        OptimStatus optimStatus = this.lnsrch.getStatus();
                        if (lineSearchTask != LineSearchTask.WARNING || optimStatus != OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS) {
                            return this.failure(optimStatus);
                        }
                    }
                    ++this.iterations;
                }
                this.gnorm = vector2.norm2();
                if (this.evaluations == 1) {
                    this.ginit = this.gnorm;
                }
                return this.success(this.gnorm <= (d2 = this.getGradientThreshold(this.ginit)) ? OptimTask.FINAL_X : OptimTask.NEW_X);
            }
            case NEW_X: 
            case FINAL_X: {
                if (this.iterations >= 1) {
                    this.H.update(vector, this.x0, vector2, this.g0);
                }
                while (true) {
                    this.H.apply(this.p, vector2);
                    this.dg0 = -this.p.dot(vector2);
                    if (this.checkSufficientDescent(this.dg0, this.gnorm, this.p)) break;
                    if (this.H.mp < 1) {
                        return this.failure(OptimStatus.BAD_PRECONDITIONER);
                    }
                    this.H.reset();
                    ++this.restarts;
                }
                this.alpha = this.initialStep(vector, this.gnorm);
                this.x0 = this.H.s(0);
                this.g0 = this.H.y(0);
                if (this.H.mp == this.H.m) {
                    --this.H.mp;
                }
                this.x0.copy(vector);
                this.g0.copy(vector2);
                this.f0 = d;
                LineSearchTask lineSearchTask = this.lnsrch.start(this.f0, this.dg0, this.alpha, this.stpmin * this.alpha, this.stpmax * this.alpha);
                if (lineSearchTask != LineSearchTask.SEARCH) {
                    return this.failure(this.lnsrch.getStatus());
                }
                return this.nextStep(vector);
            }
        }
        return this.getTask();
    }

    protected double initialStep(Vector vector, double d) {
        double d2;
        if (this.H.mp >= 1 || this.H.rule == 0) {
            return 1.0;
        }
        if (0.0 < this.delta && this.delta < 1.0 && (d2 = vector.norm2()) > 0.0) {
            return d2 / d * this.delta;
        }
        return 1.0 / d;
    }

    private OptimTask nextStep(Vector vector) {
        this.alpha = this.lnsrch.getStep();
        vector.combine(1.0, this.x0, -this.alpha, this.p);
        return this.success(OptimTask.COMPUTE_FG);
    }
}

