/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.string;

import java.util.ArrayList;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionHelper;
import net.sourceforge.jeval.function.FunctionResult;

public class StartsWith
implements Function {
    public String getName() {
        return "startsWith";
    }

    public FunctionResult execute(Evaluator evaluator, String arguments) throws FunctionException {
        String result = null;
        String exceptionMessage = "Two string arguments and one integer argument are required.";
        ArrayList values = FunctionHelper.getTwoStringsAndOneInteger(arguments, ',');
        if (values.size() != 3) {
            throw new FunctionException(exceptionMessage);
        }
        try {
            String argumentOne = FunctionHelper.trimAndRemoveQuoteChars((String)values.get(0), evaluator.getQuoteCharacter());
            String argumentTwo = FunctionHelper.trimAndRemoveQuoteChars((String)values.get(1), evaluator.getQuoteCharacter());
            int index = (Integer)values.get(2);
            result = argumentOne.startsWith(argumentTwo, index) ? "1.0" : "0.0";
        }
        catch (FunctionException fe) {
            throw new FunctionException(fe.getMessage(), fe);
        }
        catch (Exception e) {
            throw new FunctionException(exceptionMessage, e);
        }
        return new FunctionResult(result, 0);
    }
}

