/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceRibbonBandBorder
implements Border {
    @Override
    public Insets getBorderInsets(Component c) {
        return SubstanceSizeUtils.getDefaultBorderInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)c));
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        float radius = this.getCornerRadius(c);
        float alpha = SubstanceColorSchemeUtilities.getAlpha((Component)c, (ComponentState)ComponentState.ENABLED);
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)c, (float)alpha, (Graphics)g));
        AbstractRibbonBand band = (AbstractRibbonBand)c;
        int titleHeight = band.getUI().getBandTitleHeight();
        SubstanceColorScheme borderColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)c, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED);
        SubstanceImageCreator.paintBorder((Component)c, (Graphics2D)graphics, (int)x, (int)y, (int)width, (int)height, (float)radius, (SubstanceColorScheme)borderColorScheme);
        if (!(band.getCurrentResizePolicy() instanceof IconRibbonBandResizePolicy)) {
            graphics.clipRect(0, c.getHeight() - titleHeight, c.getWidth(), titleHeight);
            SubstanceColorScheme bottomColorScheme = SubstanceLookAndFeel.getCurrentSkin((Component)c).getColorScheme(DecorationAreaType.HEADER, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
            graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)c, (float)0.75f, (Graphics)g));
            SubstanceImageCreator.paintBorder((Component)c, (Graphics2D)graphics, (int)x, (int)y, (int)width, (int)height, (float)radius, (SubstanceColorScheme)bottomColorScheme);
        }
        graphics.dispose();
    }

    public float getCornerRadius(Component c) {
        return SubstanceSizeUtils.getClassicButtonCornerRadius((int)SubstanceSizeUtils.getComponentFontSize((Component)c));
    }
}

