/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.LongScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong1D;
import mitiv.array.impl.StriddenLong1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.LongGenerator;

public class FlatLong1D
extends Long1D {
    static final int order = 1;
    final long[] data;

    public FlatLong1D(int n) {
        super(n);
        this.data = new long[this.number];
    }

    public FlatLong1D(int[] nArray) {
        super(nArray);
        this.data = new long[this.number];
    }

    public FlatLong1D(Shape shape) {
        super(shape);
        this.data = new long[this.number];
    }

    public FlatLong1D(long[] lArray, int n) {
        super(n);
        this.checkSize(lArray);
        this.data = lArray;
    }

    public FlatLong1D(long[] lArray, int[] nArray) {
        super(nArray);
        this.checkSize(lArray);
        this.data = lArray;
    }

    public FlatLong1D(long[] lArray, Shape shape) {
        super(shape);
        this.checkSize(lArray);
        this.data = lArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(long[] lArray) {
        if (lArray == null || lArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n) {
        return n;
    }

    @Override
    public final long get(int n) {
        return this.data[n];
    }

    @Override
    public final void set(int n, long l) {
        this.data[n] = l;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(long l) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = l;
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = longGenerator.nextLong();
        }
    }

    @Override
    public void increment(long l) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + l;
        }
    }

    @Override
    public void decrement(long l) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - l;
        }
    }

    @Override
    public void scale(long l) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * l;
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = longFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        longScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            longScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public long[] flatten(boolean bl) {
        if (bl) {
            long[] lArray = new long[this.number];
            System.arraycopy(this.data, 0, lArray, 0, this.number);
            return lArray;
        }
        return this.data;
    }

    @Override
    public long[] getData() {
        return this.data;
    }

    @Override
    public LongScalar slice(int n) {
        n = Helper.fixIndex(n, this.dim1);
        return new LongScalar(this.data, n);
    }

    @Override
    public LongScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new LongScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Long1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenLong1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Long1D view(int[] nArray) {
        int[] nArray2 = Helper.select(0, 1, this.dim1, nArray);
        return new SelectedLong1D(this.data, nArray2);
    }

    @Override
    public Long1D as1D() {
        return this;
    }
}

