/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.util.Locale;

public class Timer {
    private long integrated = 0L;
    private long marked = 0L;
    private boolean running = false;
    private static final double NANOSECOND = 1.0E-9;

    public final void start() {
        this.integrated = 0L;
        this.running = true;
        this.marked = System.nanoTime();
    }

    public final void reset() {
        this.integrated = 0L;
    }

    public final void stop() {
        if (this.running) {
            long l = System.nanoTime();
            this.integrated += l - this.marked;
            this.marked = l;
            this.running = false;
        }
    }

    public void resume() {
        if (!this.running) {
            this.marked = System.nanoTime();
            this.running = true;
        }
    }

    public double getElapsedTime() {
        long l = this.integrated;
        if (this.running) {
            l += System.nanoTime() - this.marked;
        }
        return (double)l * 1.0E-9;
    }

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.US);
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        long l = 0L;
        timer.start();
        timer2.start();
        for (int i = 0; i < 1000; ++i) {
            l += (long)(i * i);
            timer2.stop();
            for (int j = 0; j < i; ++j) {
                l += (long)(j * j * j);
            }
            timer2.resume();
        }
        timer2.stop();
        System.out.format("elapsed time 1 = %.9f s\n", timer.getElapsedTime());
        System.out.format("elapsed time 2 = %.9f s\n", timer2.getElapsedTime());
        System.out.format("result = %d\n", l);
        System.out.format("elapsed time 1 = %.9f s\n", timer.getElapsedTime());
        System.out.format("elapsed time 2 = %.9f s\n", timer2.getElapsedTime());
        System.out.format("result = %d\n", l);
        System.out.format("elapsed time 1 = %.9f s\n", timer.getElapsedTime());
    }
}

