/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.Appearance;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.Background;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.CompressedGeometryRetained;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.DepthComponentFloatRetained;
import javax.media.j3d.DepthComponentIntRetained;
import javax.media.j3d.DepthComponentNativeRetained;
import javax.media.j3d.DepthComponentRetained;
import javax.media.j3d.DirectionalLightRetained;
import javax.media.j3d.Fog;
import javax.media.j3d.FogRetained;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.Light;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LightSet;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.ModelClip;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.Raster;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.Shader;
import javax.media.j3d.ShaderAppearance;
import javax.media.j3d.ShaderAppearanceRetained;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeRetained;
import javax.media.j3d.ShaderAttributeSetRetained;
import javax.media.j3d.ShaderProgramRetained;
import javax.media.j3d.ShaderRetained;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Sound;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundScheduler;
import javax.media.j3d.SpotLightRetained;
import javax.media.j3d.Text3DRetained;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.TextureUnitStateRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class GraphicsContext3D {
    public static final int STEREO_LEFT = 0;
    public static final int STEREO_RIGHT = 1;
    public static final int STEREO_BOTH = 2;
    Canvas3D canvas3d = null;
    private Background uBackground = null;
    private Fog uFog = null;
    private Appearance uAppearance = null;
    private Vector uLights = new Vector();
    private HiResCoord uHiRes = new HiResCoord();
    private Vector uSounds = new Vector();
    private AuralAttributes uAuralAttributes = null;
    private boolean uBufferOverride = false;
    private boolean uFrontBufferRendering = false;
    private int uStereoMode = 2;
    private ModelClip uModelClip = null;
    Background background = null;
    BackgroundRetained black = new BackgroundRetained();
    Fog fog = null;
    ModelClip modelClip = null;
    Appearance appearance = null;
    AppearanceRetained defaultAppearanceRetained = new AppearanceRetained();
    Vector lights = new Vector();
    HiResCoord hiRes = new HiResCoord();
    Transform3D modelTransform = new Transform3D();
    Transform3D identityTransform = new Transform3D();
    Transform3D modelClipTransform = null;
    Transform3D normalTransform = null;
    boolean normalTransformNeedToUpdate = true;
    Vector sounds = new Vector();
    AuralAttributes auralAttributes = null;
    LightSet ls = null;
    LightRetained[] lightlist = null;
    Color3f sceneAmbient = new Color3f(0.0f, 0.0f, 0.0f);
    int numLights = 0;
    Transform3D compTransform = new Transform3D();
    Transform3D drawTransform = new Transform3D();
    Transform3D vpcToEc;
    boolean lightsChanged = false;
    boolean soundsChanged = false;
    boolean bufferOverride = false;
    boolean frontBufferRendering = false;
    int stereoMode = 2;
    byte[] byteBuffer = new byte[1];
    float[] floatBuffer = new float[1];
    int[] intBuffer = new int[1];
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    float dRed = 1.0f;
    float dGreen = 1.0f;
    float dBlue = 1.0f;
    float alpha = 0.0f;
    boolean visible = true;
    int polygonMode = 2;
    boolean lineAA = false;
    boolean pointAA = false;
    boolean enableLighting = false;
    private Appearance defaultAppearance = null;
    private boolean geometryIsLocked = false;
    private boolean ignoreVertexColors = false;
    static final int CLEAR = 0;
    static final int DRAW = 1;
    static final int SWAP = 2;
    static final int READ_RASTER = 3;
    static final int SET_APPEARANCE = 4;
    static final int SET_BACKGROUND = 5;
    static final int SET_FOG = 6;
    static final int SET_LIGHT = 7;
    static final int INSERT_LIGHT = 8;
    static final int REMOVE_LIGHT = 9;
    static final int ADD_LIGHT = 10;
    static final int SET_HI_RES = 11;
    static final int SET_MODEL_TRANSFORM = 12;
    static final int MULTIPLY_MODEL_TRANSFORM = 13;
    static final int SET_SOUND = 14;
    static final int INSERT_SOUND = 15;
    static final int REMOVE_SOUND = 16;
    static final int ADD_SOUND = 17;
    static final int SET_AURAL_ATTRIBUTES = 18;
    static final int SET_BUFFER_OVERRIDE = 19;
    static final int SET_FRONT_BUFFER_RENDERING = 20;
    static final int SET_STEREO_MODE = 21;
    static final int FLUSH = 22;
    static final int FLUSH2D = 23;
    static final int DRAWANDFLUSH2D = 24;
    static final int SET_MODELCLIP = 25;
    static final int DISPOSE2D = 26;
    static final int NCOMMANDS = 27;
    private static Integer[] commands = new Integer[27];
    private static Integer[] stereoModes = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    private static final int BUFFER_MODE = 1;
    private int dirtyMask = 0;
    private int numActiveTexUnit = 0;
    private int lastActiveTexUnitIndex = 0;
    private volatile boolean readRasterReady = false;
    private boolean gcReady = false;
    private int waiting = 0;

    GraphicsContext3D(Canvas3D canvas3D) {
        this.canvas3d = canvas3D;
    }

    public Canvas3D getCanvas3D() {
        return this.canvas3d;
    }

    public void setAppearance(Appearance appearance) {
        if (appearance == null) {
            if (this.defaultAppearance == null) {
                this.defaultAppearance = new Appearance();
            }
            appearance = this.defaultAppearance;
        } else {
            AppearanceRetained appearanceRetained = (AppearanceRetained)appearance.retained;
            if (appearanceRetained.texture != null) {
                assert (appearanceRetained.texUnitState == null);
                TextureRetained textureRetained = appearanceRetained.texture;
                ImageComponent[] imageComponentArray = textureRetained.getImages();
                if (imageComponentArray != null) {
                    for (int i = 0; i < imageComponentArray.length; ++i) {
                        ImageComponentRetained imageComponentRetained;
                        if (imageComponentArray[i] == null || !(imageComponentRetained = (ImageComponentRetained)imageComponentArray[i].retained).getUsedByOffScreen()) continue;
                        throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D30"));
                    }
                }
            } else if (appearanceRetained.texUnitState != null) {
                for (int i = 0; i < appearanceRetained.texUnitState.length; ++i) {
                    TextureRetained textureRetained = appearanceRetained.texUnitState[i].texture;
                    ImageComponent[] imageComponentArray = textureRetained.getImages();
                    if (imageComponentArray == null) continue;
                    for (int j = 0; j < imageComponentArray.length; ++j) {
                        ImageComponentRetained imageComponentRetained;
                        if (imageComponentArray[j] == null || !(imageComponentRetained = (ImageComponentRetained)imageComponentArray[j].retained).getUsedByOffScreen()) continue;
                        throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D30"));
                    }
                }
            }
        }
        this.uAppearance = appearance;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetAppearance(appearance);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 4, appearance, null);
        } else {
            this.sendRenderMessage(true, 4, appearance, null);
        }
    }

    void doSetAppearance(Appearance appearance) {
        int n;
        Object object;
        assert (appearance != null);
        NodeComponentRetained nodeComponentRetained = ((AppearanceRetained)appearance.retained).material;
        if (nodeComponentRetained != null) {
            nodeComponentRetained.setInImmCtx(true);
            this.enableLighting = ((MaterialRetained)nodeComponentRetained).lightingEnable;
            this.dRed = ((MaterialRetained)nodeComponentRetained).diffuseColor.x;
            this.dGreen = ((MaterialRetained)nodeComponentRetained).diffuseColor.y;
            this.dBlue = ((MaterialRetained)nodeComponentRetained).diffuseColor.z;
        } else {
            this.enableLighting = false;
        }
        if (appearance instanceof ShaderAppearance) {
            Shader[] shaderArray;
            object = ((ShaderAppearanceRetained)appearance.retained).shaderProgram;
            if (object != null) {
                ((NodeComponentRetained)object).setInImmCtx(true);
                shaderArray = ((ShaderProgramRetained)object).getShaders();
                if (shaderArray != null) {
                    for (int i = 0; i < shaderArray.length; ++i) {
                        if (shaderArray[i] == null) continue;
                        ((ShaderRetained)shaderArray[i].retained).setInImmCtx(true);
                    }
                }
            }
            if ((shaderArray = ((ShaderAppearanceRetained)appearance.retained).shaderAttributeSet) != null) {
                shaderArray.setInImmCtx(true);
                ShaderAttribute[] shaderAttributeArray = shaderArray.getAll();
                if (shaderAttributeArray != null) {
                    for (n = 0; n < shaderAttributeArray.length; ++n) {
                        if (shaderAttributeArray[n] == null) continue;
                        ((ShaderAttributeRetained)shaderAttributeArray[n].retained).setInImmCtx(true);
                    }
                }
            }
        }
        if (((AppearanceRetained)appearance.retained).texUnitState != null) {
            object = ((AppearanceRetained)appearance.retained).texUnitState;
            for (int i = 0; i < ((TextureUnitStateRetained[])object).length; ++i) {
                if (object[i] == null) continue;
                object[i].setInImmCtx(true);
            }
        }
        if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).texture) != null) {
            nodeComponentRetained.setInImmCtx(true);
        }
        if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).texCoordGeneration) != null) {
            nodeComponentRetained.setInImmCtx(true);
        }
        if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).textureAttributes) != null) {
            nodeComponentRetained.setInImmCtx(true);
        }
        if ((nodeComponentRetained = ((AppearanceRetained)appearance.retained).coloringAttributes) != null) {
            nodeComponentRetained.setInImmCtx(true);
            this.red = ((ColoringAttributesRetained)nodeComponentRetained).color.x;
            this.green = ((ColoringAttributesRetained)nodeComponentRetained).color.y;
            this.blue = ((ColoringAttributesRetained)nodeComponentRetained).color.z;
        } else {
            this.red = 1.0f;
            this.green = 1.0f;
            this.blue = 1.0f;
        }
        nodeComponentRetained = ((AppearanceRetained)appearance.retained).transparencyAttributes;
        if (nodeComponentRetained != null) {
            nodeComponentRetained.setInImmCtx(true);
            this.alpha = 1.0f - ((TransparencyAttributesRetained)nodeComponentRetained).transparency;
        } else {
            this.alpha = 1.0f;
        }
        nodeComponentRetained = ((AppearanceRetained)appearance.retained).renderingAttributes;
        if (nodeComponentRetained != null) {
            nodeComponentRetained.setInImmCtx(true);
            this.visible = ((RenderingAttributesRetained)nodeComponentRetained).visible;
        } else {
            this.visible = true;
        }
        nodeComponentRetained = ((AppearanceRetained)appearance.retained).polygonAttributes;
        if (nodeComponentRetained != null) {
            nodeComponentRetained.setInImmCtx(true);
            this.polygonMode = ((PolygonAttributesRetained)nodeComponentRetained).polygonMode;
        } else {
            this.polygonMode = 2;
        }
        nodeComponentRetained = ((AppearanceRetained)appearance.retained).lineAttributes;
        if (nodeComponentRetained != null) {
            nodeComponentRetained.setInImmCtx(true);
            this.lineAA = ((LineAttributesRetained)nodeComponentRetained).lineAntialiasing;
        } else {
            this.lineAA = false;
        }
        nodeComponentRetained = ((AppearanceRetained)appearance.retained).pointAttributes;
        if (nodeComponentRetained != null) {
            if (nodeComponentRetained.source.isLive()) {
                nodeComponentRetained.setInImmCtx(true);
            }
            this.pointAA = ((PointAttributesRetained)nodeComponentRetained).pointAntialiasing;
        } else {
            this.pointAA = false;
        }
        if (this.appearance != null) {
            object = (AppearanceRetained)this.appearance.retained;
            ((NodeComponentRetained)object).setInImmCtx(false);
            if (((AppearanceRetained)object).material != null) {
                ((AppearanceRetained)object).material.setInImmCtx(false);
            }
            if (object instanceof ShaderAppearanceRetained) {
                ShaderAttributeSetRetained shaderAttributeSetRetained;
                ShaderProgramRetained shaderProgramRetained = ((ShaderAppearanceRetained)object).shaderProgram;
                if (shaderProgramRetained != null) {
                    shaderProgramRetained.setInImmCtx(false);
                    Shader[] shaderArray = shaderProgramRetained.getShaders();
                    if (shaderArray != null) {
                        for (n = 0; n < shaderArray.length; ++n) {
                            if (shaderArray[n] == null) continue;
                            ((ShaderRetained)shaderArray[n].retained).setInImmCtx(false);
                        }
                    }
                }
                if ((shaderAttributeSetRetained = ((ShaderAppearanceRetained)object).shaderAttributeSet) != null) {
                    shaderAttributeSetRetained.setInImmCtx(false);
                    ShaderAttribute[] shaderAttributeArray = shaderAttributeSetRetained.getAll();
                    if (shaderAttributeArray != null) {
                        for (int i = 0; i < shaderAttributeArray.length; ++i) {
                            if (shaderAttributeArray[i] == null) continue;
                            ((ShaderAttributeRetained)shaderAttributeArray[i].retained).setInImmCtx(false);
                        }
                    }
                }
            }
            if (((AppearanceRetained)object).texUnitState != null) {
                for (int i = 0; i < ((AppearanceRetained)object).texUnitState.length; ++i) {
                    if (((AppearanceRetained)object).texUnitState[0] == null) continue;
                    ((AppearanceRetained)object).texUnitState[0].setInImmCtx(false);
                }
            }
            if (((AppearanceRetained)object).texture != null) {
                ((AppearanceRetained)object).texture.setInImmCtx(false);
            }
            if (((AppearanceRetained)object).texCoordGeneration != null) {
                ((AppearanceRetained)object).texCoordGeneration.setInImmCtx(false);
            }
            if (((AppearanceRetained)object).textureAttributes != null) {
                ((AppearanceRetained)object).textureAttributes.setInImmCtx(false);
            }
            if (((AppearanceRetained)object).coloringAttributes != null) {
                ((AppearanceRetained)object).coloringAttributes.setInImmCtx(false);
            }
            if (((AppearanceRetained)object).transparencyAttributes != null) {
                ((AppearanceRetained)object).transparencyAttributes.setInImmCtx(false);
            }
            if (((AppearanceRetained)object).renderingAttributes != null) {
                ((AppearanceRetained)object).renderingAttributes.setInImmCtx(false);
            }
            if (((AppearanceRetained)object).polygonAttributes != null) {
                ((AppearanceRetained)object).polygonAttributes.setInImmCtx(false);
            }
            if (((AppearanceRetained)object).lineAttributes != null) {
                ((AppearanceRetained)object).lineAttributes.setInImmCtx(false);
            }
            if (((AppearanceRetained)object).pointAttributes != null) {
                ((AppearanceRetained)object).pointAttributes.setInImmCtx(false);
            }
        }
        ((AppearanceRetained)appearance.retained).setInImmCtx(true);
        this.appearance = appearance;
    }

    public Appearance getAppearance() {
        return this.uAppearance;
    }

    public void setBackground(Background background) {
        ImageComponent2DRetained imageComponent2DRetained;
        if (background.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D11"));
        }
        BackgroundRetained backgroundRetained = (BackgroundRetained)background.retained;
        ImageComponent2D imageComponent2D = backgroundRetained.getImage();
        if (imageComponent2D != null && (imageComponent2DRetained = (ImageComponent2DRetained)imageComponent2D.retained).getUsedByOffScreen()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D31"));
        }
        if (((BackgroundRetained)background.retained).geometryBranch != null) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D22"));
        }
        this.uBackground = background;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetBackground(background);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 5, background, null);
        } else {
            this.sendRenderMessage(true, 5, background, null);
        }
    }

    void doSetBackground(Background background) {
        BackgroundRetained backgroundRetained;
        if (this.background != null) {
            backgroundRetained = (BackgroundRetained)this.background.retained;
            backgroundRetained.setInImmCtx(false);
        }
        backgroundRetained = (BackgroundRetained)background.retained;
        backgroundRetained.setInImmCtx(true);
        this.background = background;
    }

    public Background getBackground() {
        return this.uBackground;
    }

    public void setFog(Fog fog) {
        if (fog != null && fog.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D12"));
        }
        this.uFog = fog;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetFog(fog);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 6, fog, null);
        } else {
            this.sendRenderMessage(true, 6, fog, null);
        }
    }

    void doSetFog(Fog fog) {
        if (this.fog != null) {
            ((FogRetained)this.fog.retained).setInImmCtx(false);
        }
        this.fog = fog;
        if (fog != null) {
            ((FogRetained)fog.retained).setInImmCtx(true);
            this.updateFogState((FogRetained)fog.retained);
        }
    }

    public Fog getFog() {
        return this.uFog;
    }

    public void setModelClip(ModelClip modelClip) {
        if (modelClip != null && modelClip.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D25"));
        }
        this.uModelClip = modelClip;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetModelClip(modelClip);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 25, modelClip, null);
        } else {
            this.sendRenderMessage(true, 25, modelClip, null);
        }
    }

    void doSetModelClip(ModelClip modelClip) {
        ModelClipRetained modelClipRetained = null;
        this.modelClip = modelClip;
        if (this.modelClip != null) {
            modelClipRetained = (ModelClipRetained)this.modelClip.retained;
            modelClipRetained.setInImmCtx(true);
            if (this.modelClipTransform == null) {
                this.modelClipTransform = new Transform3D();
            }
            this.modelClipTransform.set(this.compTransform);
        }
    }

    public ModelClip getModelClip() {
        return this.uModelClip;
    }

    public void setLight(Light light, int n) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.setElementAt(light, n);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetLight(light, n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 7, light, new Integer(n));
        } else {
            this.sendRenderMessage(true, 7, light, new Integer(n));
        }
    }

    void doSetLight(Light light, int n) {
        Light light2 = (Light)this.lights.elementAt(n);
        if (light2 != null) {
            ((LightRetained)light2.retained).setInImmCtx(false);
        }
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.setElementAt(light, n);
        this.lightsChanged = true;
    }

    public void insertLight(Light light, int n) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.insertElementAt(light, n);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doInsertLight(light, n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 8, light, new Integer(n));
        } else {
            this.sendRenderMessage(true, 8, light, new Integer(n));
        }
    }

    void doInsertLight(Light light, int n) {
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.insertElementAt(light, n);
        this.lightsChanged = true;
    }

    public void removeLight(int n) {
        this.uLights.removeElementAt(n);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doRemoveLight(n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 9, new Integer(n), null);
        } else {
            this.sendRenderMessage(true, 9, new Integer(n), null);
        }
    }

    void doRemoveLight(int n) {
        Light light = (Light)this.lights.elementAt(n);
        ((LightRetained)light.retained).setInImmCtx(false);
        this.lights.removeElementAt(n);
        this.lightsChanged = true;
    }

    public Light getLight(int n) {
        return (Light)this.uLights.elementAt(n);
    }

    public Enumeration getAllLights() {
        return this.uLights.elements();
    }

    public void addLight(Light light) {
        if (light == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D13"));
        }
        if (light.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D14"));
        }
        this.uLights.addElement(light);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doAddLight(light);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 10, light, null);
        } else {
            this.sendRenderMessage(true, 10, light, null);
        }
    }

    void doAddLight(Light light) {
        ((LightRetained)light.retained).setInImmCtx(true);
        this.updateLightState((LightRetained)light.retained);
        this.lights.addElement(light);
        this.lightsChanged = true;
    }

    public int numLights() {
        return this.uLights.size();
    }

    private Transform3D getNormalTransform() {
        if (this.compTransform.isRigid()) {
            return this.compTransform;
        }
        if (this.normalTransform == null) {
            this.normalTransform = new Transform3D();
        }
        if (this.normalTransformNeedToUpdate) {
            this.normalTransform.invert(this.compTransform);
            this.normalTransform.transpose();
            this.normalTransformNeedToUpdate = false;
        }
        return this.normalTransform;
    }

    void updateFogState(FogRetained fogRetained) {
        fogRetained.setLocalToVworldScale(this.modelTransform.getDistanceScale());
    }

    void updateLightState(LightRetained lightRetained) {
        if (lightRetained instanceof DirectionalLightRetained) {
            DirectionalLightRetained directionalLightRetained = (DirectionalLightRetained)lightRetained;
            Transform3D transform3D = this.getNormalTransform();
            transform3D.transform(directionalLightRetained.direction, directionalLightRetained.xformDirection);
            directionalLightRetained.xformDirection.normalize();
        } else if (lightRetained instanceof SpotLightRetained) {
            SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetained;
            Transform3D transform3D = this.getNormalTransform();
            transform3D.transform(spotLightRetained.direction, spotLightRetained.xformDirection);
            spotLightRetained.xformDirection.normalize();
            this.modelTransform.transform(spotLightRetained.position, spotLightRetained.xformPosition);
        } else if (lightRetained instanceof PointLightRetained) {
            PointLightRetained pointLightRetained = (PointLightRetained)lightRetained;
            this.modelTransform.transform(pointLightRetained.position, pointLightRetained.xformPosition);
            pointLightRetained.localToVworldScale = this.modelTransform.getDistanceScale();
        }
    }

    public void setHiRes(int[] nArray, int[] nArray2, int[] nArray3) {
        HiResCoord hiResCoord = new HiResCoord(nArray, nArray2, nArray3);
        this.setHiRes(hiResCoord);
    }

    public void setHiRes(HiResCoord hiResCoord) {
        this.uHiRes.setHiResCoord(hiResCoord);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetHiRes(hiResCoord);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 11, hiResCoord, null);
        } else {
            this.sendRenderMessage(true, 11, hiResCoord, null);
        }
    }

    void doSetHiRes(HiResCoord hiResCoord) {
        this.hiRes.setHiResCoord(hiResCoord);
        this.computeCompositeTransform();
    }

    public void getHiRes(HiResCoord hiResCoord) {
        this.uHiRes.getHiResCoord(hiResCoord);
    }

    public void setModelTransform(Transform3D transform3D) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetModelTransform(transform3D);
        } else {
            Transform3D transform3D2 = new Transform3D(transform3D);
            if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
                this.sendRenderMessage(false, 12, transform3D2, null);
            } else {
                this.sendRenderMessage(true, 12, transform3D2, null);
            }
        }
    }

    void doSetModelTransform(Transform3D transform3D) {
        this.modelTransform.set(transform3D);
        this.computeCompositeTransform();
        this.normalTransformNeedToUpdate = true;
    }

    public void multiplyModelTransform(Transform3D transform3D) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doMultiplyModelTransform(transform3D);
        } else {
            Transform3D transform3D2 = new Transform3D(transform3D);
            if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
                this.sendRenderMessage(false, 13, transform3D2, null);
            } else {
                this.sendRenderMessage(true, 13, transform3D2, null);
            }
        }
    }

    void doMultiplyModelTransform(Transform3D transform3D) {
        this.modelTransform.mul(transform3D);
        this.computeCompositeTransform();
        this.normalTransformNeedToUpdate = true;
    }

    public void getModelTransform(Transform3D transform3D) {
        transform3D.set(this.modelTransform);
    }

    public void setSound(Sound sound, int n) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.setElementAt(sound, n);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetSound(sound, n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 14, sound, new Integer(n));
        } else {
            this.sendRenderMessage(true, 14, sound, new Integer(n));
        }
    }

    void doSetSound(Sound sound, int n) {
        Sound sound2 = (Sound)this.sounds.elementAt(n);
        ((SoundRetained)sound.retained).setInImmCtx(true);
        if (sound2 != null) {
            ((SoundRetained)sound2.retained).setInImmCtx(false);
        }
        ((SoundRetained)sound.retained).setInImmCtx(true);
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.setElementAt(sound, n);
        this.soundsChanged = true;
        this.sendSoundMessage(14, sound, sound2);
    }

    public void insertSound(Sound sound, int n) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.insertElementAt(sound, n);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doInsertSound(sound, n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 15, sound, new Integer(n));
        } else {
            this.sendRenderMessage(true, 15, sound, new Integer(n));
        }
    }

    void doInsertSound(Sound sound, int n) {
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.insertElementAt(sound, n);
        this.soundsChanged = true;
        this.sendSoundMessage(15, sound, null);
    }

    public void removeSound(int n) {
        this.uSounds.removeElementAt(n);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doRemoveSound(n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 16, new Integer(n), null);
        } else {
            this.sendRenderMessage(true, 16, new Integer(n), null);
        }
    }

    void doRemoveSound(int n) {
        Sound sound = (Sound)this.sounds.elementAt(n);
        SoundScheduler soundScheduler = this.getSoundScheduler();
        ((SoundRetained)sound.retained).setInImmCtx(false);
        this.sounds.removeElementAt(n);
        this.soundsChanged = true;
        this.sendSoundMessage(16, null, sound);
    }

    public Sound getSound(int n) {
        Sound sound = (Sound)this.uSounds.elementAt(n);
        return sound;
    }

    public Enumeration getAllSounds() {
        return this.uSounds.elements();
    }

    public void addSound(Sound sound) {
        if (sound == null) {
            throw new NullPointerException(J3dI18N.getString("GraphicsContext3D17"));
        }
        if (sound.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D23"));
        }
        this.uSounds.addElement(sound);
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doAddSound(sound);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 17, sound, null);
        } else {
            this.sendRenderMessage(true, 17, sound, null);
        }
    }

    void doAddSound(Sound sound) {
        ((SoundRetained)sound.retained).setInImmCtx(true);
        this.updateSoundState((SoundRetained)sound.retained);
        this.sounds.addElement(sound);
        this.soundsChanged = true;
        this.sendSoundMessage(17, sound, null);
    }

    public int numSounds() {
        return this.uSounds.size();
    }

    SoundScheduler getSoundScheduler() {
        if (this.canvas3d != null && this.canvas3d.view != null) {
            return this.canvas3d.view.soundScheduler;
        }
        return null;
    }

    void updateSoundState(SoundRetained soundRetained) {
        Object object;
        View view = null;
        if (this.canvas3d != null) {
            view = this.canvas3d.view;
        }
        if (view == null || (object = this.getSoundScheduler()) == null) {
            // empty if block
        }
        if (soundRetained instanceof ConeSoundRetained) {
            object = (ConeSoundRetained)soundRetained;
            this.modelTransform.transform(((ConeSoundRetained)object).direction, ((ConeSoundRetained)object).xformDirection);
            ((ConeSoundRetained)object).xformDirection.normalize();
            this.modelTransform.transform(((ConeSoundRetained)object).position, ((ConeSoundRetained)object).xformPosition);
            ((ConeSoundRetained)object).trans.setWithLock(this.drawTransform);
        } else if (soundRetained instanceof PointSoundRetained) {
            object = (PointSoundRetained)soundRetained;
            this.modelTransform.transform(((PointSoundRetained)object).position, ((PointSoundRetained)object).xformPosition);
            ((PointSoundRetained)object).trans.setWithLock(this.drawTransform);
        }
    }

    public boolean isSoundPlaying(int n) {
        Sound sound = (Sound)this.sounds.elementAt(n);
        return sound.isPlaying();
    }

    public void setAuralAttributes(AuralAttributes auralAttributes) {
        this.uAuralAttributes = auralAttributes;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetAuralAttributes(auralAttributes);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 18, auralAttributes, null);
        } else {
            this.sendRenderMessage(true, 18, auralAttributes, null);
        }
    }

    void doSetAuralAttributes(AuralAttributes auralAttributes) {
        this.auralAttributes = auralAttributes;
        this.sendSoundMessage(18, auralAttributes, null);
    }

    public AuralAttributes getAuralAttributes() {
        return this.uAuralAttributes;
    }

    public void setBufferOverride(boolean bl) {
        this.uBufferOverride = bl;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetBufferOverride(bl);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 19, new Boolean(bl), null);
        } else {
            this.sendRenderMessage(true, 19, new Boolean(bl), null);
        }
    }

    void doSetBufferOverride(boolean bl) {
        if (bl != this.bufferOverride) {
            this.bufferOverride = bl;
            this.dirtyMask |= 1;
        }
    }

    public boolean getBufferOverride() {
        return this.uBufferOverride;
    }

    public void setFrontBufferRendering(boolean bl) {
        this.uFrontBufferRendering = bl;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetFrontBufferRendering(bl);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 20, new Boolean(bl), null);
        } else {
            this.sendRenderMessage(true, 20, new Boolean(bl), null);
        }
    }

    void doSetFrontBufferRendering(boolean bl) {
        if (bl != this.frontBufferRendering) {
            this.frontBufferRendering = bl;
            this.dirtyMask |= 1;
        }
    }

    public boolean getFrontBufferRendering() {
        return this.uFrontBufferRendering;
    }

    public void setStereoMode(int n) {
        this.uStereoMode = n;
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doSetStereoMode(n);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 21, stereoModes[n], null);
        } else {
            this.sendRenderMessage(true, 21, stereoModes[n], null);
        }
    }

    void doSetStereoMode(int n) {
        if (n != this.stereoMode) {
            this.stereoMode = n;
            this.dirtyMask |= 1;
        }
    }

    public int getStereoMode() {
        return this.uStereoMode;
    }

    public void clear() {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active) {
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doClear();
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 0, null, null);
        } else {
            this.sendRenderMessage(true, 0, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClear() {
        block23: {
            if (!this.canvas3d.firstPaintCalled) {
                return;
            }
            RenderBin renderBin = this.canvas3d.view.renderBin;
            BackgroundRetained backgroundRetained = null;
            backgroundRetained = this.background != null ? (BackgroundRetained)this.background.retained : this.black;
            if (!this.canvas3d.isRunning) {
                this.updateViewCache(renderBin);
            }
            try {
                if (!this.canvas3d.offScreen) {
                    this.canvas3d.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
                }
                if (!this.canvas3d.drawingSurfaceObject.renderLock()) break block23;
                if (this.canvas3d.ctx == null) {
                    Object object = VirtualUniverse.mc.contextCreationLock;
                    synchronized (object) {
                        this.canvas3d.ctx = this.canvas3d.createNewContext(null, false);
                        if (this.canvas3d.ctx == null) {
                            this.canvas3d.drawingSurfaceObject.unLock();
                            return;
                        }
                        this.canvas3d.ctxTimeStamp = VirtualUniverse.mc.getContextTimeStamp();
                        this.canvas3d.screen.renderer.listOfCtxs.add(this.canvas3d.ctx);
                        this.canvas3d.screen.renderer.listOfCanvases.add(this.canvas3d);
                        this.canvas3d.beginScene();
                        if (this.canvas3d.graphics2D != null) {
                            this.canvas3d.graphics2D.init();
                        }
                        this.canvas3d.enableSeparateSpecularColor();
                    }
                    if (this.canvas3d.texUnitState == null) {
                        this.canvas3d.createTexUnitState();
                    }
                    this.canvas3d.drawingSurfaceObject.contextValidated();
                    this.canvas3d.screen.renderer.currentCtx = this.canvas3d.ctx;
                    this.canvas3d.screen.renderer.currentDrawable = this.canvas3d.drawable;
                    this.initializeState();
                    this.canvas3d.ctxChanged = true;
                    this.canvas3d.canvasDirty = 65535;
                    this.updateState(renderBin, 4);
                    this.canvas3d.currentLights = new LightRetained[this.canvas3d.getNumCtxLights(this.canvas3d.ctx)];
                    for (int i = 0; i < this.canvas3d.currentLights.length; ++i) {
                        this.canvas3d.currentLights[i] = null;
                    }
                }
                this.canvas3d.makeCtxCurrent();
                if ((this.dirtyMask & 1) != 0) {
                    if (this.bufferOverride) {
                        this.canvas3d.setRenderMode(this.canvas3d.ctx, this.stereoMode, this.canvas3d.useDoubleBuffer && !this.frontBufferRendering);
                    } else if (!this.canvas3d.isRunning) {
                        this.canvas3d.setRenderMode(this.canvas3d.ctx, 2, this.canvas3d.useDoubleBuffer);
                    }
                    this.dirtyMask &= 0xFFFFFFFE;
                }
                Dimension dimension = this.canvas3d.getSize();
                int n = dimension.width;
                int n2 = dimension.height;
                boolean bl = false;
                if (backgroundRetained.image != null) {
                    if (backgroundRetained.image.isByReference()) {
                        backgroundRetained.image.geomLock.getLock();
                        bl = true;
                    }
                    backgroundRetained.image.evaluateExtensions(this.canvas3d);
                }
                this.canvas3d.clear(backgroundRetained, n, n2);
                if (bl) {
                    backgroundRetained.image.geomLock.unLock();
                }
                if (!this.canvas3d.isRunning) {
                    CanvasViewCache canvasViewCache = this.canvas3d.canvasViewCache;
                    this.canvas3d.setViewport(this.canvas3d.ctx, 0, 0, canvasViewCache.getCanvasWidth(), canvasViewCache.getCanvasHeight());
                    if (this.bufferOverride && this.stereoMode == 1) {
                        this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, canvasViewCache.getRightProjection());
                        this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, canvasViewCache.getRightVpcToEc().mat, renderBin.vworldToVpc);
                    } else {
                        this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, canvasViewCache.getLeftProjection());
                        this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, canvasViewCache.getLeftVpcToEc().mat, renderBin.vworldToVpc);
                    }
                }
                this.canvas3d.drawingSurfaceObject.unLock();
            }
            catch (NullPointerException nullPointerException) {
                this.canvas3d.drawingSurfaceObject.unLock();
                throw nullPointerException;
            }
        }
    }

    private void computeCompositeTransform() {
        ViewPlatform viewPlatform;
        if (this.canvas3d == null || this.canvas3d.view == null || (viewPlatform = this.canvas3d.view.getViewPlatform()) == null || (ViewPlatformRetained)viewPlatform.retained == null) {
            this.compTransform.set(this.modelTransform);
            return;
        }
        ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)viewPlatform.retained;
        if (viewPlatformRetained == null || viewPlatformRetained.locale == null) {
            this.compTransform.set(this.modelTransform);
            return;
        }
        HiResCoord hiResCoord = viewPlatformRetained.locale.hiRes;
        if (hiResCoord.equals(this.hiRes)) {
            this.compTransform.set(this.modelTransform);
        } else {
            Transform3D transform3D = new Transform3D();
            Vector3d vector3d = new Vector3d();
            hiResCoord.difference(this.hiRes, vector3d);
            transform3D.setTranslation(vector3d);
            this.compTransform.mul(transform3D, this.modelTransform);
        }
    }

    private void updateViewCache(RenderBin renderBin) {
        ViewPlatform viewPlatform = this.canvas3d.view.getViewPlatform();
        if (viewPlatform == null) {
            return;
        }
        ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)viewPlatform.retained;
        if (!this.canvas3d.isRunning) {
            viewPlatformRetained.evaluateInitViewPlatformTransform();
        }
        renderBin.vpcToVworld = viewPlatformRetained.getVpcToVworld();
        renderBin.vworldToVpc = viewPlatformRetained.getVworldToVpc();
        this.canvas3d.updateViewCache(true, null, null, false);
    }

    void doDraw(Geometry geometry) {
        GeometryArrayRetained geometryArrayRetained = null;
        if (!this.canvas3d.firstPaintCalled || !this.visible) {
            return;
        }
        RenderBin renderBin = this.canvas3d.view.renderBin;
        boolean bl = true;
        if (this.canvas3d.ctx == null) {
            this.doClear();
        }
        if (J3dDebug.debug) {
            J3dDebug.doAssert(this.canvas3d.ctx != null, "canvas3d.ctx != null");
        }
        try {
            if (this.canvas3d.drawingSurfaceObject.renderLock()) {
                GeometryRetained geometryRetained;
                this.canvas3d.makeCtxCurrent();
                if ((this.dirtyMask & 1) != 0) {
                    if (this.bufferOverride) {
                        this.canvas3d.setRenderMode(this.canvas3d.ctx, this.stereoMode, this.canvas3d.useDoubleBuffer && !this.frontBufferRendering);
                    } else {
                        this.canvas3d.setRenderMode(this.canvas3d.ctx, 2, this.canvas3d.useDoubleBuffer);
                    }
                    this.dirtyMask &= 0xFFFFFFFE;
                }
                CanvasViewCache canvasViewCache = this.canvas3d.canvasViewCache;
                if (this.bufferOverride) {
                    switch (this.stereoMode) {
                        case 1: {
                            this.vpcToEc = canvasViewCache.getRightVpcToEc();
                            this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, canvasViewCache.getRightProjection());
                            break;
                        }
                        default: {
                            this.vpcToEc = canvasViewCache.getLeftVpcToEc();
                            this.canvas3d.setProjectionMatrix(this.canvas3d.ctx, canvasViewCache.getLeftProjection());
                            break;
                        }
                    }
                } else {
                    this.vpcToEc = !this.canvas3d.isRunning || this.canvas3d.vpcToEc == null ? canvasViewCache.getLeftVpcToEc() : this.canvas3d.vpcToEc;
                }
                boolean bl2 = !this.drawTransform.isCongruent();
                int n = 0;
                block4 : switch (((GeometryRetained)geometry.retained).geoType) {
                    case 3: 
                    case 10: {
                        n = 1;
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 11: 
                    case 14: {
                        n = 2;
                        break;
                    }
                    case 15: {
                        n = 8;
                        break;
                    }
                    case 17: {
                        n = 16;
                        switch (((CompressedGeometryRetained)geometry.retained).getBufferType()) {
                            case 0: {
                                n |= 1;
                                break block4;
                            }
                            case 1: {
                                n |= 2;
                                break block4;
                            }
                        }
                        n |= 4;
                        break;
                    }
                    default: {
                        n = 4;
                    }
                }
                boolean bl3 = this.updateState(renderBin, n);
                this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, this.vpcToEc.mat, renderBin.vworldToVpc);
                this.updateLightAndFog();
                this.updateModelClip(renderBin.vworldToVpc);
                this.drawTransform.mul(renderBin.vworldToVpc, this.compTransform);
                this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, this.vpcToEc.mat, this.drawTransform);
                if (geometry.retained instanceof GeometryArrayRetained) {
                    geometryArrayRetained = (GeometryArrayRetained)geometry.retained;
                    geometryArrayRetained.geomLock.getLock();
                    if ((geometryArrayRetained.vertexFormat & 0x80) != 0 && geometryArrayRetained.c4fAllocated == 0 && (geometryArrayRetained.vertexFormat & 4) != 0 && bl3 && (this.canvas3d.extensionsSupported & 1) == 0) {
                        if ((geometryArrayRetained.vertexFormat & 0x100) != 0) {
                            geometryArrayRetained.setupMirrorInterleavedColorPointer(true);
                        } else {
                            geometryArrayRetained.setupMirrorColorPointer(geometryArrayRetained.vertexType & 0x3F0, true);
                        }
                    }
                    if (geometry.retained instanceof IndexedGeometryArrayRetained && (((GeometryArrayRetained)geometry.retained).vertexFormat & 0x200) == 0) {
                        if (geometryArrayRetained.dirtyFlag != 0) {
                            geometryArrayRetained.mirrorGeometry = ((IndexedGeometryArrayRetained)geometryArrayRetained).cloneNonIndexedGeometry();
                            geometryArrayRetained.dirtyFlag = 0;
                        }
                        geometryRetained = geometryArrayRetained.mirrorGeometry;
                    } else {
                        geometryRetained = geometryArrayRetained;
                    }
                    geometryArrayRetained.setVertexFormat(false, this.ignoreVertexColors, this.canvas3d.ctx);
                } else if (geometry.retained instanceof Text3DRetained) {
                    ((Text3DRetained)geometry.retained).setModelViewMatrix(this.vpcToEc, this.drawTransform);
                    geometryRetained = (GeometryRetained)geometry.retained;
                } else if (geometry.retained instanceof RasterRetained) {
                    ImageComponent2DRetained imageComponent2DRetained = ((RasterRetained)geometry.retained).image;
                    if (imageComponent2DRetained != null) {
                        if (imageComponent2DRetained.isByReference()) {
                            imageComponent2DRetained.geomLock.getLock();
                            imageComponent2DRetained.evaluateExtensions(this.canvas3d);
                            imageComponent2DRetained.geomLock.unLock();
                        } else {
                            imageComponent2DRetained.evaluateExtensions(this.canvas3d);
                        }
                    }
                    geometryRetained = (GeometryRetained)geometry.retained;
                } else {
                    geometryRetained = (GeometryRetained)geometry.retained;
                }
                geometryRetained.execute(this.canvas3d, null, bl2, false, this.alpha, this.canvas3d.screen.screen, this.ignoreVertexColors);
                if (geometryArrayRetained != null) {
                    if (geometryArrayRetained.pVertexBuffers != 0L) {
                        geometryArrayRetained.freeD3DArray(true);
                    }
                    geometryArrayRetained.geomLock.unLock();
                }
                this.canvas3d.drawingSurfaceObject.unLock();
            }
        }
        catch (NullPointerException nullPointerException) {
            this.canvas3d.drawingSurfaceObject.unLock();
            throw nullPointerException;
        }
    }

    public void draw(Geometry geometry) {
        ImageComponentRetained imageComponentRetained;
        RasterRetained rasterRetained;
        ImageComponent2D imageComponent2D;
        if (geometry != null && geometry instanceof Raster && (imageComponent2D = (rasterRetained = (RasterRetained)geometry.retained).getImage()) != null && (imageComponentRetained = (ImageComponentRetained)imageComponent2D.retained).getUsedByOffScreen()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D32"));
        }
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active) {
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doDraw(geometry);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.sendRenderMessage(false, 1, geometry, null);
        } else {
            this.sendRenderMessage(true, 1, geometry, null);
        }
    }

    public void draw(Shape3D shape3D) {
        if (shape3D.isLive()) {
            throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D26"));
        }
        ((Shape3DRetained)shape3D.retained).setInImmCtx(true);
        this.setAppearance(shape3D.getAppearance());
        this.draw(shape3D.getGeometry());
    }

    public void readRaster(Raster raster) {
        ImageComponent2D imageComponent2D;
        if (raster != null && raster.isLive() && (imageComponent2D = raster.getImage()) != null) {
            ImageComponent2DRetained imageComponent2DRetained = (ImageComponent2DRetained)imageComponent2D.retained;
            if (imageComponent2D.getImageClass() != ImageComponent.ImageClass.BUFFERED_IMAGE) {
                throw new IllegalArgumentException(J3dI18N.getString("GraphicsContext3D33"));
            }
            if (imageComponent2D.isByReference() && imageComponent2D.getImage() == null) {
                throw new IllegalArgumentException(J3dI18N.getString("GraphicsContext3D34"));
            }
            if (imageComponent2DRetained.getNumberOfComponents() < 3) {
                throw new IllegalArgumentException(J3dI18N.getString("GraphicsContext3D35"));
            }
            if (imageComponent2D.isLive()) {
                throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D36"));
            }
            if (imageComponent2DRetained.getInImmCtx() || imageComponent2DRetained.getUsedByOffScreen()) {
                throw new IllegalSharingException(J3dI18N.getString("GraphicsContext3D37"));
            }
        }
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active) {
            return;
        }
        if (Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doReadRaster(raster);
        } else if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
            this.readRasterReady = false;
            this.sendRenderMessage(false, 3, raster, null);
            while (!this.readRasterReady) {
                MasterControl.threadYield();
            }
        } else {
            this.readRasterReady = false;
            this.sendRenderMessage(true, 3, raster, null);
            while (!this.readRasterReady) {
                MasterControl.threadYield();
            }
        }
    }

    void doReadRaster(Raster raster) {
        if (!this.canvas3d.firstPaintCalled) {
            this.readRasterReady = true;
            return;
        }
        RasterRetained rasterRetained = (RasterRetained)raster.retained;
        Dimension dimension = this.canvas3d.getSize();
        Dimension dimension2 = new Dimension();
        ImageComponent2DRetained imageComponent2DRetained = rasterRetained.image;
        boolean bl = false;
        if (this.canvas3d.ctx == null) {
            this.doClear();
        }
        if (J3dDebug.debug) {
            J3dDebug.doAssert(this.canvas3d.ctx != null, "canvas3d.ctx != null");
        }
        rasterRetained.getSize(dimension2);
        if ((rasterRetained.type & 1) != 0 && (dimension2.width > rasterRetained.image.width || dimension2.height > rasterRetained.image.height)) {
            throw new RuntimeException(J3dI18N.getString("GraphicsContext3D27"));
        }
        if ((rasterRetained.type & 2) != 0) {
            int n = rasterRetained.depthComponent.height * rasterRetained.depthComponent.width;
            if (rasterRetained.depthComponent.type == 2) {
                if (this.floatBuffer.length < n) {
                    this.floatBuffer = new float[n];
                }
            } else if (this.intBuffer.length < n) {
                this.intBuffer = new int[n];
            }
            if (dimension2.width > rasterRetained.depthComponent.width || dimension2.height > rasterRetained.depthComponent.height) {
                throw new RuntimeException(J3dI18N.getString("GraphicsContext3D28"));
            }
        }
        if ((rasterRetained.type & 1) != 0) {
            if (imageComponent2DRetained.isByReference()) {
                imageComponent2DRetained.geomLock.getLock();
                imageComponent2DRetained.evaluateExtensions(this.canvas3d);
                imageComponent2DRetained.geomLock.unLock();
            } else if (imageComponent2DRetained.imageData == null) {
                imageComponent2DRetained.createBlankImageData();
            } else {
                imageComponent2DRetained.evaluateExtensions(this.canvas3d);
            }
        }
        try {
            if (this.canvas3d.drawingSurfaceObject.renderLock()) {
                this.canvas3d.makeCtxCurrent();
                this.canvas3d.syncRender(this.canvas3d.ctx, true);
                Point point = new Point();
                rasterRetained.getDstOffset(point);
                DepthComponentRetained depthComponentRetained = rasterRetained.depthComponent;
                int n = 0;
                if (depthComponentRetained != null) {
                    n = depthComponentRetained.type;
                }
                Pipeline.getPipeline().readRaster(this.canvas3d.ctx, rasterRetained.type, point.x, point.y, dimension2.width, dimension2.height, dimension.height, imageComponent2DRetained.getImageDataTypeIntValue(), imageComponent2DRetained.getImageFormatTypeIntValue(false), imageComponent2DRetained.imageData.get(), n, depthComponentRetained);
                this.canvas3d.drawingSurfaceObject.unLock();
            }
        }
        catch (NullPointerException nullPointerException) {
            this.canvas3d.drawingSurfaceObject.unLock();
            throw nullPointerException;
        }
        if ((rasterRetained.type & 2) != 0) {
            if (rasterRetained.depthComponent.type == 2) {
                ((DepthComponentFloatRetained)rasterRetained.depthComponent).retrieveDepth(this.floatBuffer, dimension2.width, dimension2.height);
            } else if (rasterRetained.depthComponent.type == 1) {
                ((DepthComponentIntRetained)rasterRetained.depthComponent).retrieveDepth(this.intBuffer, dimension2.width, dimension2.height);
            } else if (rasterRetained.depthComponent.type == 1) {
                ((DepthComponentNativeRetained)rasterRetained.depthComponent).retrieveDepth(this.intBuffer, dimension2.width, dimension2.height);
            }
        }
        this.readRasterReady = true;
    }

    public void flush(boolean bl) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null || !this.canvas3d.view.active || Thread.currentThread() == this.canvas3d.screen.renderer) {
            this.doFlush(bl);
        } else {
            Boolean bl2;
            Boolean bl3 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            if (Thread.currentThread() == this.canvas3d.view.universe.behaviorScheduler) {
                this.sendRenderMessage(false, 22, bl2, null);
            } else {
                this.sendRenderMessage(true, 22, bl2, null);
            }
            if (bl && this.canvas3d.active && this.canvas3d.isRunningStatus && !this.canvas3d.manualRendering) {
                this.runMonitor(0);
            }
        }
    }

    void doFlush(boolean bl) {
        try {
            if (this.canvas3d.drawingSurfaceObject.renderLock()) {
                this.canvas3d.syncRender(this.canvas3d.ctx, bl);
                this.canvas3d.drawingSurfaceObject.unLock();
                if (bl) {
                    this.runMonitor(2);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.canvas3d.drawingSurfaceObject.unLock();
            throw nullPointerException;
        }
    }

    void updateLightAndFog() {
        int n = 0;
        this.sceneAmbient.x = 0.0f;
        this.sceneAmbient.y = 0.0f;
        this.sceneAmbient.z = 0.0f;
        int n2 = 0;
        int n3 = this.lights.size();
        for (int i = 0; i < n3; ++i) {
            LightRetained lightRetained = (LightRetained)((Light)this.lights.get((int)i)).retained;
            if (lightRetained instanceof AmbientLightRetained) {
                this.sceneAmbient.x += lightRetained.color.x;
                this.sceneAmbient.y += lightRetained.color.y;
                this.sceneAmbient.z += lightRetained.color.z;
                continue;
            }
            lightRetained.update(this.canvas3d.ctx, n2, this.canvas3d.canvasViewCache.getVworldToCoexistenceScale());
            if (lightRetained.lightOn) {
                n |= 1 << n2;
            }
            ++n2;
        }
        if (this.sceneAmbient.x > 1.0f) {
            this.sceneAmbient.x = 1.0f;
        }
        if (this.sceneAmbient.y > 1.0f) {
            this.sceneAmbient.y = 1.0f;
        }
        if (this.sceneAmbient.z > 1.0f) {
            this.sceneAmbient.z = 1.0f;
        }
        this.canvas3d.setSceneAmbient(this.canvas3d.ctx, this.sceneAmbient.x, this.sceneAmbient.y, this.sceneAmbient.z);
        this.canvas3d.canvasDirty |= 0x100;
        this.canvas3d.sceneAmbient.set((Tuple3f)this.sceneAmbient);
        if (this.canvas3d.enableMask != (long)n) {
            this.canvas3d.canvasDirty |= 0x80;
            this.canvas3d.setLightEnables(this.canvas3d.ctx, n, 32);
            this.canvas3d.enableMask = n;
        }
        this.canvas3d.lightBin = null;
        this.canvas3d.environmentSet = null;
        if (this.fog != null) {
            if (this.fog.retained != this.canvas3d.fog) {
                ((FogRetained)this.fog.retained).update(this.canvas3d.ctx, this.canvas3d.canvasViewCache.getVworldToCoexistenceScale());
                this.canvas3d.fog = (FogRetained)this.fog.retained;
                this.canvas3d.canvasDirty |= 0x2000;
            }
        } else if (this.canvas3d.fog != null) {
            this.canvas3d.setFogEnableFlag(this.canvas3d.ctx, false);
            this.canvas3d.fog = null;
            this.canvas3d.canvasDirty |= 0x2000;
        }
    }

    void updateModelClip(Transform3D transform3D) {
        if (this.modelClip != null) {
            int n = 0;
            for (int i = 0; i < 6; ++i) {
                if (!((ModelClipRetained)this.modelClip.retained).enables[i]) continue;
                n |= 1 << i;
            }
            if (n != 0) {
                this.drawTransform.mul(transform3D, this.modelClipTransform);
                this.canvas3d.setModelViewMatrix(this.canvas3d.ctx, this.vpcToEc.mat, this.drawTransform);
            }
            ((ModelClipRetained)this.modelClip.retained).update(this.canvas3d.ctx, n, this.drawTransform);
            this.canvas3d.canvasDirty |= 0x4000;
            this.canvas3d.modelClip = (ModelClipRetained)this.modelClip.retained;
        } else if (this.canvas3d.modelClip != null) {
            this.canvas3d.disableModelClip(this.canvas3d.ctx);
            this.canvas3d.modelClip = null;
            this.canvas3d.canvasDirty |= 0x4000;
        }
        this.canvas3d.environmentSet = null;
    }

    boolean updateState(RenderBin renderBin, int n) {
        boolean bl = false;
        this.numActiveTexUnit = 0;
        this.lastActiveTexUnitIndex = 0;
        if (this.appearance != null) {
            AppearanceRetained appearanceRetained = (AppearanceRetained)this.appearance.retained;
            if (appearanceRetained.material != null) {
                appearanceRetained.material.updateNative(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                this.canvas3d.material = appearanceRetained.material;
                this.canvas3d.canvasDirty |= 8;
            } else if (this.canvas3d.material != null) {
                this.canvas3d.updateMaterial(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha);
                this.canvas3d.material = null;
                this.canvas3d.canvasDirty |= 8;
            }
            boolean bl2 = false;
            if (appearanceRetained instanceof ShaderAppearanceRetained) {
                ShaderProgramRetained shaderProgramRetained = ((ShaderAppearanceRetained)appearanceRetained).shaderProgram;
                if (shaderProgramRetained != null) {
                    shaderProgramRetained.updateNative(this.canvas3d, true);
                    ShaderAttributeSetRetained shaderAttributeSetRetained = ((ShaderAppearanceRetained)appearanceRetained).shaderAttributeSet;
                    if (shaderAttributeSetRetained != null) {
                        shaderAttributeSetRetained.updateNative(this.canvas3d, shaderProgramRetained);
                    }
                    this.canvas3d.shaderProgram = shaderProgramRetained;
                    bl2 = true;
                }
            } else if (this.canvas3d.shaderProgram != null) {
                this.canvas3d.shaderProgram.updateNative(this.canvas3d, false);
                this.canvas3d.shaderProgram = null;
                bl2 = false;
            }
            int n2 = bl2 ? this.canvas3d.maxTextureImageUnits : this.canvas3d.maxTextureUnits;
            int n3 = this.canvas3d.getNumActiveTexUnit();
            if (appearanceRetained.texUnitState != null) {
                int n4;
                for (n4 = 0; n4 < appearanceRetained.texUnitState.length; ++n4) {
                    TextureUnitStateRetained textureUnitStateRetained = appearanceRetained.texUnitState[n4];
                    if (textureUnitStateRetained == null || !textureUnitStateRetained.isTextureEnabled()) continue;
                    this.lastActiveTexUnitIndex = n4;
                    this.numActiveTexUnit = n4 + 1;
                    if (textureUnitStateRetained.texAttrs == null) continue;
                    bl = bl || textureUnitStateRetained.texAttrs.textureMode == 4;
                }
                if (this.numActiveTexUnit <= n2) {
                    for (n4 = 0; n4 < appearanceRetained.texUnitState.length && n4 < n2; ++n4) {
                        if (appearanceRetained.texUnitState[n4] != null && appearanceRetained.texUnitState[n4].isTextureEnabled()) {
                            appearanceRetained.texUnitState[n4].updateNative(n4, this.canvas3d, false, false);
                            continue;
                        }
                        this.canvas3d.resetTexture(this.canvas3d.ctx, n4);
                    }
                    for (n4 = appearanceRetained.texUnitState.length; n4 < n3; ++n4) {
                        this.canvas3d.resetTexture(this.canvas3d.ctx, n4);
                    }
                    this.canvas3d.setNumActiveTexUnit(this.numActiveTexUnit);
                } else {
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.canvas3d.resetTexture(this.canvas3d.ctx, n4);
                    }
                    this.canvas3d.setNumActiveTexUnit(0);
                }
                this.canvas3d.activeTextureUnit(this.canvas3d.ctx, 0);
            } else {
                if (this.canvas3d.multiTexAccelerated) {
                    if (this.canvas3d.texUnitState != null) {
                        for (int i = 0; i < n3; ++i) {
                            TextureUnitStateRetained textureUnitStateRetained = this.canvas3d.texUnitState[i];
                            if (textureUnitStateRetained == null || textureUnitStateRetained.texture == null) continue;
                            this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                            this.canvas3d.texUnitState[i].texture = null;
                        }
                    }
                    this.canvas3d.activeTextureUnit(this.canvas3d.ctx, 0);
                }
                if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null && this.canvas3d.texUnitState[0].texture != appearanceRetained.texture) {
                    if (appearanceRetained.texture != null) {
                        appearanceRetained.texture.updateNative(this.canvas3d);
                        this.canvas3d.canvasDirty |= 0xC00;
                        this.numActiveTexUnit = 1;
                        this.lastActiveTexUnitIndex = 0;
                    } else {
                        this.numActiveTexUnit = 0;
                        this.canvas3d.resetTexture(this.canvas3d.ctx, -1);
                        this.canvas3d.canvasDirty |= 0xC00;
                    }
                    this.canvas3d.texUnitState[0].texture = appearanceRetained.texture;
                }
                this.canvas3d.setNumActiveTexUnit(this.numActiveTexUnit);
                if (appearanceRetained.texCoordGeneration != null) {
                    appearanceRetained.texCoordGeneration.updateNative(this.canvas3d);
                    this.canvas3d.canvasDirty |= 0xC00;
                    if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null) {
                        this.canvas3d.texUnitState[0].texGen = appearanceRetained.texCoordGeneration;
                    }
                } else if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null && this.canvas3d.texUnitState[0].texGen != null) {
                    this.canvas3d.resetTexCoordGeneration(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 0xC00;
                    this.canvas3d.texUnitState[0].texGen = appearanceRetained.texCoordGeneration;
                }
                if (appearanceRetained.textureAttributes != null) {
                    if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null) {
                        if (this.canvas3d.texUnitState[0].texture != null) {
                            appearanceRetained.textureAttributes.updateNative(this.canvas3d, false, this.canvas3d.texUnitState[0].texture.format);
                        } else {
                            appearanceRetained.textureAttributes.updateNative(this.canvas3d, false, 6);
                        }
                        this.canvas3d.canvasDirty |= 0xC00;
                        this.canvas3d.texUnitState[0].texAttrs = appearanceRetained.textureAttributes;
                    }
                } else if (this.canvas3d.texUnitState != null && this.canvas3d.texUnitState[0] != null && this.canvas3d.texUnitState[0].texAttrs != null) {
                    this.canvas3d.resetTextureAttributes(this.canvas3d.ctx);
                    this.canvas3d.canvasDirty |= 0xC00;
                    this.canvas3d.texUnitState[0].texAttrs = null;
                }
            }
            if (appearanceRetained.coloringAttributes != null) {
                appearanceRetained.coloringAttributes.updateNative(this.canvas3d.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
                this.canvas3d.canvasDirty |= 0x20;
                this.canvas3d.coloringAttributes = appearanceRetained.coloringAttributes;
            } else if (this.canvas3d.coloringAttributes != null) {
                this.canvas3d.resetColoringAttributes(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                this.canvas3d.canvasDirty |= 0x20;
                this.canvas3d.coloringAttributes = null;
            }
            if (appearanceRetained.transparencyAttributes != null) {
                appearanceRetained.transparencyAttributes.updateNative(this.canvas3d.ctx, this.alpha, n, this.polygonMode, this.lineAA, this.pointAA);
                this.canvas3d.canvasDirty |= 0x10;
                this.canvas3d.transparency = appearanceRetained.transparencyAttributes;
                bl = bl || appearanceRetained.transparencyAttributes.transparencyMode != 4 && (VirtualUniverse.mc.isD3D() || !VirtualUniverse.mc.isD3D() && appearanceRetained.transparencyAttributes.transparencyMode != 3);
            } else {
                this.canvas3d.resetTransparency(this.canvas3d.ctx, n, this.polygonMode, this.lineAA, this.pointAA);
                this.canvas3d.canvasDirty |= 0x10;
                this.canvas3d.transparency = null;
            }
            if (appearanceRetained.renderingAttributes != null) {
                this.ignoreVertexColors = appearanceRetained.renderingAttributes.ignoreVertexColors;
                appearanceRetained.renderingAttributes.updateNative(this.canvas3d, this.canvas3d.depthBufferWriteEnableOverride, this.canvas3d.depthBufferEnableOverride);
                this.canvas3d.canvasDirty |= 0xA00;
                this.canvas3d.renderingAttrs = appearanceRetained.renderingAttributes;
                bl = bl || appearanceRetained.renderingAttributes.alphaTestFunction != 0;
            } else {
                this.ignoreVertexColors = false;
                if (this.canvas3d.renderingAttrs != null) {
                    this.canvas3d.resetRenderingAttributes(this.canvas3d.ctx, this.canvas3d.depthBufferWriteEnableOverride, this.canvas3d.depthBufferEnableOverride);
                    this.canvas3d.canvasDirty |= 0xA00;
                    this.canvas3d.renderingAttrs = null;
                }
            }
            if (appearanceRetained.polygonAttributes != null) {
                appearanceRetained.polygonAttributes.updateNative(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 1;
                this.canvas3d.polygonAttributes = appearanceRetained.polygonAttributes;
            } else if (this.canvas3d.polygonAttributes != null) {
                this.canvas3d.resetPolygonAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 1;
                this.canvas3d.polygonAttributes = null;
            }
            if (appearanceRetained.lineAttributes != null) {
                appearanceRetained.lineAttributes.updateNative(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 2;
                this.canvas3d.lineAttributes = appearanceRetained.lineAttributes;
            } else if (this.canvas3d.lineAttributes != null) {
                this.canvas3d.resetLineAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 2;
                this.canvas3d.lineAttributes = null;
            }
            if (appearanceRetained.pointAttributes != null) {
                appearanceRetained.pointAttributes.updateNative(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 4;
                this.canvas3d.pointAttributes = appearanceRetained.pointAttributes;
            } else if (this.canvas3d.pointAttributes != null) {
                this.canvas3d.resetPointAttributes(this.canvas3d.ctx);
                this.canvas3d.canvasDirty |= 4;
                this.canvas3d.pointAttributes = null;
            }
            this.canvas3d.appearance = appearanceRetained;
        } else if (this.canvas3d.appearance != null) {
            this.resetAppearance();
            this.canvas3d.appearance = null;
        }
        return bl;
    }

    void initializeState() {
        int n;
        this.canvas3d.setSceneAmbient(this.canvas3d.ctx, 0.0f, 0.0f, 0.0f);
        this.canvas3d.disableFog(this.canvas3d.ctx);
        this.canvas3d.resetRenderingAttributes(this.canvas3d.ctx, false, false);
        if (this.canvas3d.shaderProgram != null) {
            this.canvas3d.shaderProgram.updateNative(this.canvas3d, false);
            this.canvas3d.shaderProgram = null;
        }
        if ((n = this.canvas3d.getNumActiveTexUnit()) > 0) {
            for (int i = 0; i < n; ++i) {
                if (this.canvas3d.texUnitState[i].texture != null) {
                    this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                    this.canvas3d.texUnitState[i].texture = null;
                }
                if (this.canvas3d.texUnitState[i].texAttrs != null) {
                    this.canvas3d.resetTextureAttributes(this.canvas3d.ctx);
                    this.canvas3d.texUnitState[i].texAttrs = null;
                }
                if (this.canvas3d.texUnitState[i].texGen != null) {
                    this.canvas3d.resetTexCoordGeneration(this.canvas3d.ctx);
                    this.canvas3d.texUnitState[i].texGen = null;
                }
                this.canvas3d.texUnitState[i].mirror = null;
            }
            this.canvas3d.setNumActiveTexUnit(0);
        }
        this.canvas3d.resetPolygonAttributes(this.canvas3d.ctx);
        this.canvas3d.resetLineAttributes(this.canvas3d.ctx);
        this.canvas3d.resetPointAttributes(this.canvas3d.ctx);
        this.canvas3d.resetTransparency(this.canvas3d.ctx, 4, 2, false, false);
        this.canvas3d.resetColoringAttributes(this.canvas3d.ctx, 1.0f, 1.0f, 1.0f, 1.0f, false);
        this.canvas3d.updateMaterial(this.canvas3d.ctx, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    void resetAppearance() {
        int n;
        if (this.canvas3d.material != null) {
            this.canvas3d.updateMaterial(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha);
            this.canvas3d.material = null;
            this.canvas3d.canvasDirty |= 8;
        }
        if (this.canvas3d.shaderProgram != null) {
            this.canvas3d.shaderProgram.updateNative(this.canvas3d, false);
            this.canvas3d.shaderProgram = null;
        }
        if ((n = this.canvas3d.getNumActiveTexUnit()) > 0) {
            for (int i = 0; i < n; ++i) {
                if (this.canvas3d.texUnitState[i].texture != null) {
                    this.canvas3d.resetTexture(this.canvas3d.ctx, i);
                    this.canvas3d.texUnitState[i].texture = null;
                }
                if (this.canvas3d.texUnitState[i].texAttrs != null) {
                    this.canvas3d.resetTextureAttributes(this.canvas3d.ctx);
                    this.canvas3d.texUnitState[i].texAttrs = null;
                }
                if (this.canvas3d.texUnitState[i].texGen != null) {
                    this.canvas3d.resetTexCoordGeneration(this.canvas3d.ctx);
                    this.canvas3d.texUnitState[i].texGen = null;
                }
                this.canvas3d.texUnitState[i].mirror = null;
            }
            this.canvas3d.canvasDirty |= 0xC00;
            this.canvas3d.setNumActiveTexUnit(0);
        }
        if (this.canvas3d.coloringAttributes != null) {
            this.canvas3d.resetColoringAttributes(this.canvas3d.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
            this.canvas3d.coloringAttributes = null;
            this.canvas3d.canvasDirty |= 0x20;
        }
        if (this.canvas3d.transparency != null) {
            this.canvas3d.resetTransparency(this.canvas3d.ctx, 4, 2, this.lineAA, this.pointAA);
            this.canvas3d.transparency = null;
            this.canvas3d.canvasDirty |= 0x10;
        }
        if (this.canvas3d.renderingAttrs != null) {
            this.ignoreVertexColors = false;
            this.canvas3d.resetRenderingAttributes(this.canvas3d.ctx, this.canvas3d.depthBufferWriteEnableOverride, this.canvas3d.depthBufferEnableOverride);
            this.canvas3d.renderingAttrs = null;
            this.canvas3d.canvasDirty |= 0xA00;
        }
        if (this.canvas3d.polygonAttributes != null) {
            this.canvas3d.resetPolygonAttributes(this.canvas3d.ctx);
            this.canvas3d.polygonAttributes = null;
            this.canvas3d.canvasDirty |= 1;
        }
        if (this.canvas3d.lineAttributes != null) {
            this.canvas3d.resetLineAttributes(this.canvas3d.ctx);
            this.canvas3d.lineAttributes = null;
            this.canvas3d.canvasDirty |= 2;
        }
        if (this.canvas3d.pointAttributes != null) {
            this.canvas3d.resetPointAttributes(this.canvas3d.ctx);
            this.canvas3d.pointAttributes = null;
            this.canvas3d.canvasDirty |= 4;
        }
    }

    void sendRenderMessage(boolean bl, int n, Object object, Object object2) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 16;
        j3dMessage.type = 44;
        j3dMessage.universe = null;
        j3dMessage.view = null;
        j3dMessage.args[0] = this.canvas3d;
        j3dMessage.args[1] = GraphicsContext3D.getImmCommand(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        while (!this.canvas3d.view.inRenderThreadData) {
            MasterControl.threadYield();
        }
        this.canvas3d.screen.renderer.rendererStructure.addMessage(j3dMessage);
        if (bl) {
            VirtualUniverse.mc.sendRunMessage(this.canvas3d.view, 16);
        } else {
            VirtualUniverse.mc.setWorkForRequestRenderer();
        }
    }

    void sendSoundMessage(int n, Object object, Object object2) {
        if (this.canvas3d.view == null || this.canvas3d.view.universe == null) {
            return;
        }
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 2;
        j3dMessage.type = 44;
        j3dMessage.universe = this.canvas3d.view.universe;
        j3dMessage.view = this.canvas3d.view;
        j3dMessage.args[0] = GraphicsContext3D.getImmCommand(n);
        j3dMessage.args[1] = object;
        j3dMessage.args[2] = object2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    static Integer getImmCommand(int n) {
        if (commands[n] == null) {
            GraphicsContext3D.commands[n] = new Integer(n);
        }
        return commands[n];
    }

    synchronized void runMonitor(int n) {
        if (n == 0) {
            while (!this.gcReady) {
                ++this.waiting;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --this.waiting;
            }
            this.gcReady = false;
        } else {
            this.gcReady = true;
            if (this.waiting > 0) {
                this.notify();
            }
        }
    }
}

