/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array8D;
import mitiv.array.Byte8D;
import mitiv.array.Double8D;
import mitiv.array.Float8D;
import mitiv.array.Int8D;
import mitiv.array.Long1D;
import mitiv.array.Long7D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short8D;
import mitiv.array.impl.FlatLong8D;
import mitiv.array.impl.StriddenLong8D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long8D
extends Array8D
implements LongArray {
    protected Long8D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n, n2, n3, n4, n5, n6, n7, n8);
    }

    protected Long8D(int[] nArray) {
        super(nArray);
    }

    protected Long8D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    @Override
    public void fill(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, l);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, l);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) + l);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) + l);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) - l);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) - l);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) * l);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) * l);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, longFunction.apply(this.get(i, j, k, i2, i3, i4, i5, i6)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, longFunction.apply(this.get(i11, i10, i9, i8, i7, k, j, i)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, longGenerator.nextLong());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, longGenerator.nextLong());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                longScanner.update(this.get(i, j, k, i2, i3, i4, i5, i6));
                                                continue;
                                            }
                                            longScanner.initialize(this.get(i, j, k, i2, i3, i4, i5, i6));
                                            bl = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                longScanner.update(this.get(i11, i10, i9, i8, i7, k, j, i));
                                                continue;
                                            }
                                            longScanner.initialize(this.get(i11, i10, i9, i8, i7, k, j, i));
                                            bl = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long l = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            long l2 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (l2 >= l) continue;
                                            l = l2;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            long l3 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (l3 >= l) continue;
                                            l = l3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long max() {
        long l = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            long l2 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (l2 <= l) continue;
                                            l = l2;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            long l3 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (l3 <= l) continue;
                                            l = l3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long[] getMinAndMax() {
        long[] lArray = new long[2];
        this.getMinAndMax(lArray);
        return lArray;
    }

    @Override
    public void getMinAndMax(long[] lArray) {
        long l;
        long l2 = l = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            long l3 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (l3 < l) {
                                                l = l3;
                                            }
                                            if (l3 <= l2) continue;
                                            l2 = l3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            long l4 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (l4 < l) {
                                                l = l4;
                                            }
                                            if (l4 <= l2) continue;
                                            l2 = l4;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        lArray[0] = l;
        lArray[1] = l2;
    }

    @Override
    public long sum() {
        long l = 0L;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            l += this.get(i, j, k, i2, i3, i4, i5, i6);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            l += this.get(i11, i10, i9, i8, i7, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte8D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            byArray[++n] = (byte)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte8D.wrap(byArray, this.getShape());
    }

    @Override
    public Short8D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            sArray[++n] = (short)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short8D.wrap(sArray, this.getShape());
    }

    @Override
    public Int8D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            nArray[++n] = (int)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int8D.wrap(nArray, this.getShape());
    }

    @Override
    public Long8D toLong() {
        return this;
    }

    @Override
    public Float8D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            fArray[++n] = this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float8D.wrap(fArray, this.getShape());
    }

    @Override
    public Double8D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            dArray[++n] = this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double8D.wrap(dArray, this.getShape());
    }

    @Override
    public Long8D copy() {
        return new FlatLong8D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Long8D long8D = shapedArray.getType() == 3 ? (Long8D)shapedArray : (Long8D)shapedArray.toLong();
        if (this.getOrder() == 2 && long8D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, long8D.get(i, j, k, i2, i3, i4, i5, i6));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, long8D.get(i11, i10, i9, i8, i7, k, j, i));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            this.set(i6, i5, i4, i3, i2, k, j, i, (long)doubleShapedVector.get(++n));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, (long)floatShapedVector.get(++n));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long8D create() {
        return new FlatLong8D(this.getShape());
    }

    public static Long8D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new FlatLong8D(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Long8D create(int[] nArray) {
        return new FlatLong8D(nArray);
    }

    public static Long8D create(Shape shape) {
        return new FlatLong8D(shape);
    }

    public static Long8D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new FlatLong8D(lArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Long8D wrap(long[] lArray, int[] nArray) {
        return new FlatLong8D(lArray, nArray);
    }

    public static Long8D wrap(long[] lArray, Shape shape) {
        return new FlatLong8D(lArray, shape);
    }

    public static Long8D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        return new StriddenLong8D(lArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17);
    }

    @Override
    public abstract Long7D slice(int var1);

    @Override
    public abstract Long7D slice(int var1, int var2);

    @Override
    public abstract Long8D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8);

    @Override
    public abstract Long8D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    @Override
    public abstract Long1D as1D();
}

