/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.base.indexing.Range;

public class Helper {
    static int fixSliceIndex(int n, int n2) {
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Slice index out of bounds.");
        }
        return n;
    }

    static int fixIndex(int n, int n2) {
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Index out of bounds.");
        }
        return n;
    }

    private static void badStepDirection() {
        throw new IllegalArgumentException("Bad step direction.");
    }

    private static void badEndPoints() {
        throw new IndexOutOfBoundsException("Range endpoints outside bounds.");
    }

    public static int[] select(int n, int n2, int n3, int[] nArray) {
        int n4 = nArray.length;
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            int n5 = nArray[i];
            if (n5 < 0 || n5 >= n3) {
                throw new IndexOutOfBoundsException("Selection index outside bounds.");
            }
            nArray2[i] = n + n2 * n5;
        }
        return nArray2;
    }

    public static int[] select(int[] nArray, Range range) {
        if (range == null) {
            return nArray;
        }
        int n = nArray.length;
        int n2 = range.getFirst(n);
        int n3 = range.getLast(n);
        int n4 = range.getStep();
        if (n2 <= n3) {
            if (n4 < 0) {
                Helper.badStepDirection();
            }
            if (n4 == 0) {
                n4 = 1;
            }
            if (n2 == 0 && n3 == n - 1 && n4 == 1) {
                return nArray;
            }
            if (n2 < 0 || n3 >= n) {
                Helper.badEndPoints();
            }
            n = (n3 - n2 + 1) / n4;
        } else {
            if (n4 > 0) {
                Helper.badStepDirection();
            }
            if (n4 == 0) {
                n4 = -1;
            }
            if (n3 < 0 || n2 >= n) {
                Helper.badEndPoints();
            }
            n = (n2 - n3 + 1) / -n4;
        }
        int[] nArray2 = new int[n];
        int n5 = 0;
        int n6 = n2;
        while (n5 < n) {
            nArray2[n5] = nArray[n6];
            ++n5;
            n6 += n4;
        }
        return nArray2;
    }

    public static int[] select(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            return nArray;
        }
        int n = nArray2.length;
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }
}

