/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.Byte2D;
import mitiv.array.Byte3D;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte3D;
import mitiv.array.impl.StriddenByte2D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.random.ByteGenerator;

public class StriddenByte3D
extends Byte3D {
    final int order;
    final byte[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final boolean flat;

    public StriddenByte3D(byte[] byArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 3) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = byArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.stride2 = nArray[1];
        this.stride3 = nArray[2];
        this.order = Byte3D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2;
    }

    public StriddenByte3D(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n5, n6, n7);
        this.data = byArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.stride3 = n4;
        this.order = Byte3D.checkViewStrides(this.data.length, n, n2, n3, n4, n5, n6, n7);
        this.flat = n == 0 && n2 == 1 && n3 == n5 && n4 == n6 * n3;
    }

    @Override
    public void checkSanity() {
        Byte3D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
    }

    final int index(int n, int n2, int n3) {
        return this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final byte get(int n, int n2, int n3) {
        return this.data[this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3, byte by) {
        this.data[this.offset + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n] = by;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = by;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = by;
                    }
                }
            }
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = byteGenerator.nextByte();
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = byteGenerator.nextByte();
                    }
                }
            }
        }
    }

    @Override
    public void increment(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = (byte)(this.data[n4] + by);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = (byte)(this.data[n7] + by);
                    }
                }
            }
        }
    }

    @Override
    public void decrement(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = (byte)(this.data[n4] - by);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = (byte)(this.data[n7] - by);
                    }
                }
            }
        }
    }

    @Override
    public void scale(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3;
                        int n4 = n3 = this.stride3 * k + n2;
                        this.data[n4] = (byte)(this.data[n4] * by);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n5 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n6;
                        int n7 = n6 = this.stride1 * k + n5;
                        this.data[n7] = (byte)(this.data[n7] * by);
                    }
                }
            }
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        this.data[n3] = byteFunction.apply(this.data[n3]);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        this.data[n5] = byteFunction.apply(this.data[n5]);
                    }
                }
            }
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        if (bl) {
                            byteScanner.update(this.data[n3]);
                            continue;
                        }
                        byteScanner.initialize(this.data[n3]);
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                int n = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n4 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n5 = this.stride1 * k + n4;
                        if (bl) {
                            byteScanner.update(this.data[n5]);
                            continue;
                        }
                        byteScanner.initialize(this.data[n5]);
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public byte[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        byte[] byArray = new byte[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, byArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                int n2 = this.stride3 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim1; ++k) {
                        int n4 = this.stride1 * k + n3;
                        byArray[++n] = this.data[n4];
                    }
                }
            }
        }
        return byArray;
    }

    @Override
    public byte[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Byte2D slice(int n) {
        return new StriddenByte2D(this.data, this.offset + this.stride3 * n, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    @Override
    public Byte2D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 < 0) {
            n2 += 3;
        }
        if (n2 == 0) {
            n7 = this.offset + this.stride1 * n;
            n6 = this.stride2;
            n5 = this.stride3;
            n4 = this.dim2;
            n3 = this.dim3;
        } else if (n2 == 1) {
            n7 = this.offset + this.stride2 * n;
            n6 = this.stride1;
            n5 = this.stride3;
            n4 = this.dim1;
            n3 = this.dim3;
        } else if (n2 == 2) {
            n7 = this.offset + this.stride3 * n;
            n6 = this.stride1;
            n5 = this.stride2;
            n4 = this.dim1;
            n3 = this.dim2;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenByte2D(this.data, n7, n6, n5, n4, n3);
    }

    @Override
    public Byte3D view(Range range, Range range2, Range range3) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.stride3);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing()) {
            return this;
        }
        return new StriddenByte3D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber());
    }

    @Override
    public Byte3D view(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray5 = Helper.select(0, this.stride2, this.dim2, nArray2);
        int[] nArray6 = Helper.select(0, this.stride3, this.dim3, nArray3);
        return new SelectedByte3D(this.data, nArray4, nArray5, nArray6);
    }

    @Override
    public Byte1D as1D() {
        return new FlatByte1D(this.flatten(), this.number);
    }
}

