/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.cost.PseudoL1NormOfDoubleVector;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;

public class PseudoL1NormOfBoundedDoubleVector
extends PseudoL1NormOfDoubleVector {
    public static final int SCALAR_MIN = 1;
    public static final int VECTOR_MIN = 2;
    public static final int SCALAR_MAX = 4;
    public static final int VECTOR_MAX = 8;
    protected double xmin = Double.NEGATIVE_INFINITY;
    protected double xmax = Double.POSITIVE_INFINITY;
    protected double xmid = 0.0;
    protected int typeOfBounds = 0;

    public PseudoL1NormOfBoundedDoubleVector(DoubleShapedVectorSpace doubleShapedVectorSpace) {
        super(doubleShapedVectorSpace);
    }

    public PseudoL1NormOfBoundedDoubleVector(DoubleShapedVectorSpace doubleShapedVectorSpace, double d, double d2) {
        super(doubleShapedVectorSpace);
        this.setBounds(d, d2);
    }

    public void setBounds(double d, double d2) {
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Bounds must be regular values or +/-infinity.");
        }
        if (d > d2) {
            throw new IllegalArgumentException("Empty feasible set.");
        }
        this.typeOfBounds = 0;
        this.xmid = 0.0;
        if (Double.isInfinite(d)) {
            this.xmin = Double.NEGATIVE_INFINITY;
        } else {
            this.xmin = d;
            this.xmid = Math.max(this.xmid, d);
            this.typeOfBounds |= 1;
        }
        if (Double.isInfinite(d2)) {
            this.xmax = Double.POSITIVE_INFINITY;
        } else {
            this.xmax = d2;
            this.xmid = Math.min(this.xmid, d2);
            this.typeOfBounds |= 4;
        }
    }

    private final double minCut(double d) {
        return Math.max(d, this.xmin);
    }

    private final double maxCut(double d) {
        return Math.min(d, this.xmax);
    }

    private final double cut(double d) {
        return Math.min(Math.max(d, this.xmin), this.xmax);
    }

    @Override
    public void applyProx(Vector vector, double d, Vector vector2, double d2) {
        if (d == 0.0) {
            vector.copy(vector2);
        } else if (d > 0.0) {
            if (!vector2.belongsTo(this.inputSpace) || !vector.belongsTo(this.inputSpace)) {
                throw new IncorrectSpaceException();
            }
            double[] dArray = ((DoubleShapedVector)vector2).getData();
            double[] dArray2 = ((DoubleShapedVector)vector2).getData();
            double d3 = -d;
            double d4 = d;
            int n = dArray.length;
            switch (this.typeOfBounds) {
                case 0: {
                    for (int i = 0; i < n; ++i) {
                        double d5 = dArray[i];
                        dArray2[i] = d5 <= d3 ? d5 - d3 : (d5 >= d4 ? d5 - d4 : this.xmid);
                    }
                    break;
                }
                case 1: {
                    if (this.xmin >= 0.0) {
                        for (int i = 0; i < n; ++i) {
                            dArray2[i] = this.minCut(dArray[i] - d);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            double d6 = dArray[i];
                            dArray2[i] = d6 <= d3 ? this.minCut(d6 - d3) : (d6 >= d4 ? this.minCut(d6 - d4) : this.xmid);
                        }
                    }
                    break;
                }
                case 4: {
                    if (this.xmax <= 0.0) {
                        for (int i = 0; i < n; ++i) {
                            dArray2[i] = this.maxCut(dArray[i] + d);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            double d7 = dArray[i];
                            dArray2[i] = d7 <= d3 ? this.maxCut(d7 - d3) : (d7 >= d4 ? this.maxCut(d7 - d4) : this.xmid);
                        }
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < n; ++i) {
                        double d8 = dArray[i];
                        dArray2[i] = d8 <= d3 ? this.cut(d8 - d3) : (d8 >= d4 ? this.cut(d8 - d4) : this.xmid);
                    }
                    break;
                }
            }
        }
    }
}

