/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;

public class MoreThuenteLineSearch
extends LineSearch {
    private double ftol = 0.0;
    private double gtol = 0.0;
    private double xtol = 0.0;
    private double gtest = 0.0;
    double stx;
    double fx;
    double gx;
    double sty;
    double fy;
    double gy;
    private double stmin = 0.0;
    private double stmax = 0.0;
    private double width = 0.0;
    private double width1 = 0.0;
    private boolean brackt = false;
    private double[] ws = new double[9];
    private int stage = 0;

    public MoreThuenteLineSearch(double d, double d2, double d3) {
        this.ftol = Math.max(d, 0.0);
        this.gtol = Math.max(d2, 0.0);
        this.xtol = Math.max(d3, 0.0);
    }

    @Override
    public boolean useDerivative() {
        return true;
    }

    @Override
    protected void startHook() {
        this.gtest = this.ftol * this.ginit;
        this.stmin = this.stpmin;
        this.stmax = this.stpmax;
        this.width = this.stpmax - this.stpmin;
        this.width1 = 2.0 * this.width;
        this.brackt = false;
        this.stx = 0.0;
        this.fx = this.finit;
        this.gx = this.ginit;
        this.sty = 0.0;
        this.fy = this.finit;
        this.gy = this.ginit;
        this.stage = 1;
        this.success(LineSearchTask.SEARCH);
    }

    @Override
    protected void iterateHook(double d, double d2) {
        OptimStatus optimStatus;
        double d3 = this.finit + this.stp * this.gtest;
        if (d <= d3 && Math.abs(d2) <= -this.gtol * this.ginit) {
            this.success(LineSearchTask.CONVERGENCE);
            return;
        }
        if (this.stp == this.stpmin && (d > d3 || d2 >= this.gtest)) {
            this.failure(OptimStatus.STEP_EQ_STPMIN);
            return;
        }
        if (this.stp == this.stpmax && d <= d3 && d2 <= this.gtest) {
            this.warning(OptimStatus.STEP_EQ_STPMAX);
            return;
        }
        if (this.brackt && this.stmax - this.stmin <= this.xtol * this.stmax) {
            this.warning(OptimStatus.XTOL_TEST_SATISFIED);
            return;
        }
        if (this.brackt && (this.stp <= this.stmin || this.stp >= this.stmax)) {
            this.warning(OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS);
            return;
        }
        if (this.stage == 1 && d <= d3 && d2 >= 0.0) {
            this.stage = 2;
        }
        if (this.stage == 1 && d <= this.fx && d > d3) {
            this.ws[0] = this.stx;
            this.ws[1] = this.fx - this.gtest * this.stx;
            this.ws[2] = this.gx - this.gtest;
            this.ws[3] = this.sty;
            this.ws[4] = this.fy - this.gtest * this.sty;
            this.ws[5] = this.gy - this.gtest;
            this.ws[6] = this.stp;
            this.ws[7] = d - this.gtest * this.stp;
            this.ws[8] = d2 - this.gtest;
            optimStatus = this.cstep();
            if (optimStatus != OptimStatus.SUCCESS) {
                this.failure(optimStatus);
                return;
            }
            this.stx = this.ws[0];
            this.fx = this.ws[1] + this.gtest * this.stx;
            this.gx = this.ws[2] + this.gtest;
            this.sty = this.ws[3];
            this.fy = this.ws[4] + this.gtest * this.sty;
            this.gy = this.ws[5] + this.gtest;
            this.stp = this.ws[6];
        } else {
            this.ws[0] = this.stx;
            this.ws[1] = this.fx;
            this.ws[2] = this.gx;
            this.ws[3] = this.sty;
            this.ws[4] = this.fy;
            this.ws[5] = this.gy;
            this.ws[6] = this.stp;
            this.ws[7] = d;
            this.ws[8] = d2;
            optimStatus = this.cstep();
            if (optimStatus != OptimStatus.SUCCESS) {
                this.failure(optimStatus);
                return;
            }
            this.stx = this.ws[0];
            this.fx = this.ws[1];
            this.gx = this.ws[2];
            this.sty = this.ws[3];
            this.fy = this.ws[4];
            this.gy = this.ws[5];
            this.stp = this.ws[6];
        }
        if (this.brackt) {
            double d4 = Math.abs(this.sty - this.stx);
            if (d4 >= 0.66 * this.width1) {
                this.stp = this.stx + 0.5 * (this.sty - this.stx);
            }
            this.width1 = this.width;
            this.width = d4;
        }
        if (this.brackt) {
            this.stmin = Math.min(this.stx, this.sty);
            this.stmax = Math.max(this.stx, this.sty);
        } else {
            this.stmin = this.stp + (this.stp - this.stx) * 1.1;
            this.stmax = this.stp + (this.stp - this.stx) * 4.0;
        }
        this.stp = Math.max(this.stp, this.stpmin);
        this.stp = Math.min(this.stp, this.stpmax);
        if (this.brackt && (this.stp <= this.stmin || this.stp >= this.stmax || this.stmax - this.stmin <= this.xtol * this.stmax)) {
            this.stp = this.stx;
        }
        this.success(LineSearchTask.SEARCH);
    }

    private static final double max(double d, double d2, double d3) {
        return Math.max(Math.max(d, d2), d3);
    }

    private final OptimStatus cstep() {
        double d;
        boolean bl;
        double d2 = this.ws[0];
        double d3 = this.ws[1];
        double d4 = this.ws[2];
        double d5 = this.ws[3];
        double d6 = this.ws[4];
        double d7 = this.ws[5];
        double d8 = this.ws[6];
        double d9 = this.ws[7];
        double d10 = this.ws[8];
        if (this.brackt && (d2 < d5 ? d8 <= d2 || d8 >= d5 : d8 <= d5 || d8 >= d2)) {
            return OptimStatus.STEP_OUTSIDE_BRACKET;
        }
        if (d4 * (d8 - d2) >= 0.0) {
            return OptimStatus.NOT_A_DESCENT;
        }
        if (this.stpmin > this.stpmax) {
            return OptimStatus.STPMIN_GT_STPMAX;
        }
        boolean bl2 = bl = d10 < 0.0 && d4 > 0.0 || d10 > 0.0 && d4 < 0.0;
        if (d9 > d3) {
            this.brackt = true;
            double d11 = 3.0 * (d3 - d9) / (d8 - d2) + d4 + d10;
            double d12 = MoreThuenteLineSearch.max(Math.abs(d11), Math.abs(d4), Math.abs(d10));
            double d13 = d11 / d12;
            double d14 = d12 * Math.sqrt(d13 * d13 - d4 / d12 * (d10 / d12));
            if (d8 < d2) {
                d14 = -d14;
            }
            double d15 = d14 - d4 + d11;
            double d16 = d14 - d4 + d14 + d10;
            double d17 = d15 / d16;
            double d18 = d2 + d17 * (d8 - d2);
            double d19 = d2 + d4 / ((d3 - d9) / (d8 - d2) + d4) / 2.0 * (d8 - d2);
            d = Math.abs(d18 - d2) < Math.abs(d19 - d2) ? d18 : d18 + (d19 - d18) / 2.0;
        } else if (bl) {
            this.brackt = true;
            double d20 = 3.0 * (d3 - d9) / (d8 - d2) + d4 + d10;
            double d21 = MoreThuenteLineSearch.max(Math.abs(d20), Math.abs(d4), Math.abs(d10));
            double d22 = d20 / d21;
            double d23 = d21 * Math.sqrt(d22 * d22 - d4 / d21 * (d10 / d21));
            if (d8 > d2) {
                d23 = -d23;
            }
            double d24 = d23 - d10 + d20;
            double d25 = d23 - d10 + d23 + d4;
            double d26 = d24 / d25;
            double d27 = d8 + d26 * (d2 - d8);
            double d28 = d8 + d10 / (d10 - d4) * (d2 - d8);
            d = Math.abs(d27 - d8) > Math.abs(d28 - d8) ? d27 : d28;
        } else if (Math.abs(d10) < Math.abs(d4)) {
            double d29;
            double d30;
            double d31;
            double d32;
            double d33 = 3.0 * (d3 - d9) / (d8 - d2) + d4 + d10;
            double d34 = MoreThuenteLineSearch.max(Math.abs(d33), Math.abs(d4), Math.abs(d10));
            double d35 = d33 / d34;
            if ((d35 = d35 * d35 - d4 / d34 * (d10 / d34)) > 0.0) {
                d32 = d34 * Math.sqrt(d35);
                if (d8 > d2) {
                    d32 = -d32;
                }
            } else {
                d32 = 0.0;
            }
            double d36 = (d31 = (d30 = d32 - d10 + d33) / (d29 = d32 + (d4 - d10) + d32)) < 0.0 && d32 != 0.0 ? d8 + d31 * (d2 - d8) : (d8 > d2 ? this.stpmax : this.stpmin);
            double d37 = d8 + d10 / (d10 - d4) * (d2 - d8);
            if (this.brackt) {
                d = Math.abs(d36 - d8) < Math.abs(d37 - d8) ? d36 : d37;
                d35 = d8 + 0.66 * (d5 - d8);
                if (d8 > d2 ? d > d35 : d < d35) {
                    d = d35;
                }
            } else {
                d = Math.abs(d36 - d8) > Math.abs(d37 - d8) ? d36 : d37;
                if (d > this.stpmax) {
                    d = this.stpmax;
                }
                if (d < this.stpmin) {
                    d = this.stpmin;
                }
            }
        } else if (this.brackt) {
            double d38;
            double d39 = 3.0 * (d9 - d6) / (d5 - d8) + d7 + d10;
            double d40 = MoreThuenteLineSearch.max(Math.abs(d39), Math.abs(d7), Math.abs(d10));
            double d41 = d39 / d40;
            double d42 = d40 * Math.sqrt(d41 * d41 - d7 / d40 * (d10 / d40));
            if (d8 > d5) {
                d42 = -d42;
            }
            double d43 = d42 - d10 + d39;
            double d44 = d42 - d10 + d42 + d7;
            double d45 = d43 / d44;
            d = d38 = d8 + d45 * (d5 - d8);
        } else {
            d = d8 > d2 ? this.stpmax : this.stpmin;
        }
        if (d9 > d3) {
            d5 = d8;
            d6 = d9;
            d7 = d10;
        } else {
            if (bl) {
                d5 = d2;
                d6 = d3;
                d7 = d4;
            }
            d2 = d8;
            d3 = d9;
            d4 = d10;
        }
        this.ws[0] = d2;
        this.ws[1] = d3;
        this.ws[2] = d4;
        this.ws[3] = d5;
        this.ws[4] = d6;
        this.ws[5] = d7;
        this.ws[6] = d;
        return OptimStatus.SUCCESS;
    }
}

