/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix3D;

public class DenseLargeLongMatrix3D
extends WrapperLongMatrix3D {
    private static final long serialVersionUID = 1L;
    private long[][][] elements;

    public DenseLargeLongMatrix3D(int slices, int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(slices, rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new long[slices][rows][columns];
    }

    @Override
    public long getQuick(int slice, int row, int column) {
        return this.elements[slice][row][column];
    }

    @Override
    public void setQuick(int slice, int row, int column, long value) {
        this.elements[slice][row][column] = value;
    }

    public long[][][] elements() {
        return this.elements;
    }

    @Override
    protected LongMatrix3D getContent() {
        return this;
    }

    @Override
    public LongMatrix3D like(int slices, int rows, int columns) {
        return new DenseLargeLongMatrix3D(slices, rows, columns);
    }
}

