/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDescriptionRuntime;

public class Shdr {
    StructAccessor accessor;
    private static final int mdIdx = MachineDescriptionRuntime.getStatic().ordinal();
    private static final int[] Shdr_size = new int[]{40, 40, 64, 40, 40, 64};
    private static final int[] sh_name_offset = new int[]{0, 0, 0, 0, 0, 0};
    private static final int[] sh_type_offset = new int[]{4, 4, 4, 4, 4, 4};
    private static final int[] sh_flags_offset = new int[]{8, 8, 8, 8, 8, 8};
    private static final int[] sh_addr_offset = new int[]{12, 12, 16, 12, 12, 16};
    private static final int[] sh_offset_offset = new int[]{16, 16, 24, 16, 16, 24};
    private static final int[] sh_size_offset = new int[]{20, 20, 32, 20, 20, 32};
    private static final int[] sh_link_offset = new int[]{24, 24, 40, 24, 24, 40};
    private static final int[] sh_info_offset = new int[]{28, 28, 44, 28, 28, 44};
    private static final int[] sh_addralign_offset = new int[]{32, 32, 48, 32, 32, 48};
    private static final int[] sh_entsize_offset = new int[]{36, 36, 56, 36, 36, 56};

    public static int size() {
        return Shdr_size[mdIdx];
    }

    public static Shdr create() {
        return Shdr.create(Buffers.newDirectByteBuffer(Shdr.size()));
    }

    public static Shdr create(ByteBuffer byteBuffer) {
        return new Shdr(byteBuffer);
    }

    Shdr(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public Shdr setSh_name(int n) {
        this.accessor.setIntAt(sh_name_offset[mdIdx], n);
        return this;
    }

    public int getSh_name() {
        return this.accessor.getIntAt(sh_name_offset[mdIdx]);
    }

    public Shdr setSh_type(int n) {
        this.accessor.setIntAt(sh_type_offset[mdIdx], n);
        return this;
    }

    public int getSh_type() {
        return this.accessor.getIntAt(sh_type_offset[mdIdx]);
    }

    public Shdr setSh_flags(long l) {
        this.accessor.setLongAt(sh_flags_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getSh_flags() {
        return this.accessor.getLongAt(sh_flags_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }

    public Shdr setSh_addr(long l) {
        this.accessor.setLongAt(sh_addr_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getSh_addr() {
        return this.accessor.getLongAt(sh_addr_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }

    public Shdr setSh_offset(long l) {
        this.accessor.setLongAt(sh_offset_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getSh_offset() {
        return this.accessor.getLongAt(sh_offset_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }

    public Shdr setSh_size(long l) {
        this.accessor.setLongAt(sh_size_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getSh_size() {
        return this.accessor.getLongAt(sh_size_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }

    public Shdr setSh_link(int n) {
        this.accessor.setIntAt(sh_link_offset[mdIdx], n);
        return this;
    }

    public int getSh_link() {
        return this.accessor.getIntAt(sh_link_offset[mdIdx]);
    }

    public Shdr setSh_info(int n) {
        this.accessor.setIntAt(sh_info_offset[mdIdx], n);
        return this;
    }

    public int getSh_info() {
        return this.accessor.getIntAt(sh_info_offset[mdIdx]);
    }

    public Shdr setSh_addralign(long l) {
        this.accessor.setLongAt(sh_addralign_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getSh_addralign() {
        return this.accessor.getLongAt(sh_addralign_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }

    public Shdr setSh_entsize(long l) {
        this.accessor.setLongAt(sh_entsize_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getSh_entsize() {
        return this.accessor.getLongAt(sh_entsize_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }
}

