/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.jet.math.tdcomplex.DComplex;

public final class DComplexMult
implements DComplexDComplexFunction {
    public double[] multiplicator;

    protected DComplexMult(double[] multiplicator) {
        this.multiplicator = multiplicator;
    }

    @Override
    public final double[] apply(double[] a) {
        double[] z = new double[]{a[0] * this.multiplicator[0] - a[1] * this.multiplicator[1], a[1] * this.multiplicator[0] + a[0] * this.multiplicator[1]};
        return z;
    }

    @Override
    public final double[] apply(double re, double im) {
        double[] z = new double[]{re * this.multiplicator[0] - im * this.multiplicator[1], im * this.multiplicator[0] + re * this.multiplicator[1]};
        return z;
    }

    public static DComplexMult div(double[] constant) {
        return DComplexMult.mult(DComplex.inv(constant));
    }

    public static DComplexMult mult(double[] constant) {
        return new DComplexMult(constant);
    }
}

