/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.ConvolutionFloat2D;
import mitiv.deconv.WeightedConvolutionFloat;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;

class WeightedConvolutionFloat2D
extends WeightedConvolutionFloat {
    private final int dim1;
    private final int off1;
    private final int end1;
    private final int dim2;
    private final int off2;
    private final int end2;
    private final ConvolutionFloat2D cnvl;

    public WeightedConvolutionFloat2D(ConvolutionFloat2D convolutionFloat2D) {
        super(convolutionFloat2D.getInputSpace(), convolutionFloat2D.getOutputSpace());
        this.cnvl = convolutionFloat2D;
        Shape shape = convolutionFloat2D.workShape;
        Shape shape2 = convolutionFloat2D.getOutputSpace().getShape();
        int[] nArray = convolutionFloat2D.outputOffsets;
        this.dim1 = shape.dimension(0);
        this.off1 = nArray[0];
        this.end1 = this.off1 + shape2.dimension(0);
        this.dim2 = shape.dimension(1);
        this.off2 = nArray[1];
        this.end2 = this.off2 + shape2.dimension(1);
    }

    @Override
    protected double _cost(double d, Vector vector) {
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        double d2 = 0.0;
        float[] fArray = this.cnvl.getWorkArray();
        int n = 0;
        if (this.wgt == null) {
            for (int i = this.off2; i < this.end2; ++i) {
                int n2 = 2 * (this.off1 + this.dim1 * i);
                for (int j = this.off1; j < this.end1; ++j) {
                    float f = fArray[n2] - this.dat[n];
                    d2 += (double)(f * f);
                    ++n;
                    n2 += 2;
                }
            }
        } else {
            for (int i = this.off2; i < this.end2; ++i) {
                int n3 = 2 * (this.off1 + this.dim1 * i);
                for (int j = this.off1; j < this.end1; ++j) {
                    float f = this.wgt[n];
                    float f2 = fArray[n3] - this.dat[n];
                    d2 += (double)(f * f2 * f2);
                    ++n;
                    n3 += 2;
                }
            }
        }
        return d * d2 / 2.0;
    }

    @Override
    protected double _cost(double d, Vector vector, Vector vector2, boolean bl) {
        int n;
        int n2;
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        boolean bl2 = this.wgt != null;
        float f = (float)d;
        double d2 = 0.0;
        float[] fArray = this.cnvl.getWorkArray();
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.off2; ++n2) {
            for (n = 0; n < this.dim1; ++n) {
                fArray[n4] = 0.0f;
                fArray[n4 + 1] = 0.0f;
                n4 += 2;
            }
        }
        for (n2 = this.off2; n2 < this.end2; ++n2) {
            float f2;
            for (n = 0; n < this.off1; ++n) {
                fArray[n4] = 0.0f;
                fArray[n4 + 1] = 0.0f;
                n4 += 2;
            }
            if (bl2) {
                for (n = this.off1; n < this.end1; ++n) {
                    f2 = this.wgt[n3];
                    float f3 = fArray[n4] - this.dat[n3];
                    float f4 = f2 * f3;
                    d2 += (double)(f3 * f4);
                    fArray[n4] = f * f4;
                    fArray[n4 + 1] = 0.0f;
                    ++n3;
                    n4 += 2;
                }
            } else {
                for (n = this.off1; n < this.end1; ++n) {
                    f2 = fArray[n4] - this.dat[n3];
                    d2 += (double)(f2 * f2);
                    fArray[n4] = f * f2;
                    fArray[n4 + 1] = 0.0f;
                    ++n3;
                    n4 += 2;
                }
            }
            for (n = this.end1; n < this.dim1; ++n) {
                fArray[n4] = 0.0f;
                fArray[n4 + 1] = 0.0f;
                n4 += 2;
            }
        }
        for (n2 = this.end2; n2 < this.dim2; ++n2) {
            for (n = 0; n < this.dim1; ++n) {
                fArray[n4] = 0.0f;
                fArray[n4 + 1] = 0.0f;
                n4 += 2;
            }
        }
        float[] fArray2 = ((FloatShapedVector)vector2).getData();
        this.cnvl.convolve(true);
        if (bl) {
            n3 = 0;
            n4 = 0;
            while (n3 < fArray2.length) {
                fArray2[n3] = fArray[n4];
                ++n3;
                n4 += 2;
            }
        } else {
            n3 = 0;
            n4 = 0;
            while (n3 < fArray2.length) {
                int n5 = n3++;
                fArray2[n5] = fArray2[n5] + fArray[n4];
                n4 += 2;
            }
        }
        return d * d2 / 2.0;
    }

    @Override
    public void setPSF(ShapedArray shapedArray, int[] nArray, boolean bl) {
        this.cnvl.setPSF(shapedArray, nArray, bl);
    }

    @Override
    public void setPSF(ShapedVector shapedVector) {
        this.cnvl.setPSF(shapedVector);
    }
}

